/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.morepistons.common.block;

import com.gollum.morepistons.ModMorePistons;
import com.gollum.morepistons.common.block.BlockMorePistonsBase;
import com.gollum.morepistons.common.block.BlockMorePistonsExtension;
import com.gollum.morepistons.common.tileentities.TileEntityMorePistonsMoving;
import com.gollum.morepistons.common.tileentities.TileEntityMorePistonsPiston;
import com.gollum.morepistons.inits.ModBlocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMorePistonsMagnetic
extends BlockMorePistonsBase {
    private IIcon[] sidesIcon = new IIcon[8];

    public BlockMorePistonsMagnetic(String registerName) {
        super(registerName, true);
    }

    @Override
    public BlockMorePistonsExtension getBlockExtention() {
        return ModBlocks.blockPistonMagneticExtention;
    }

    @Override
    protected void registerBlockIconsSide(IIconRegister iconRegister) {
        for (int i = 0; i < this.sidesIcon.length; ++i) {
            this.sidesIcon[i] = this.helper.loadTexture(iconRegister, this.suffixSide + "_" + (i + 1));
        }
        this.blockIcon = this.sidesIcon[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        this.blockIcon = this.sidesIcon[(this.getStickySize(world, x, y, z) + 7) % 8];
        IIcon icon = super.getIcon(world, x, y, z, side);
        this.blockIcon = this.sidesIcon[0];
        return icon;
    }

    @Override
    protected void registerBlockIconsTop(IIconRegister iconRegister) {
        this.iconTop = this.helper.loadTexture(iconRegister, "morepistonsmagneticextension_top", true);
    }

    public void applyStickySize(World world, int x, int y, int z, int size) {
        ModMorePistons.log.debug(new Object[]{"applyRetractSize = " + size, "remote=" + world.isRemote});
        int metadata = world.getBlockMetadata(x, y, z);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityMorePistonsMoving) {
            te = ((TileEntityMorePistonsMoving)te).subTe;
        }
        if (te instanceof TileEntityMorePistonsPiston) {
            ((TileEntityMorePistonsPiston)te).stickySize = size;
        }
        world.notifyBlockOfNeighborChange(x, y, z, (Block)this);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int faceClicked, float par7, float par8, float par9) {
        int metadata = world.getBlockMetadata(x, y, z);
        int orientation = BlockPistonBase.getPistonOrientation((int)metadata);
        if (faceClicked == orientation) {
            return false;
        }
        int size = this.getStickySize((IBlockAccess)world, x, y, z) % 8 + 1;
        this.applyStickySize(world, x, y, z, size);
        world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        return true;
    }
}

