/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.morepistons.common.block;

import com.gollum.morepistons.ModMorePistons;
import com.gollum.morepistons.common.block.BlockMorePistonsBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class BlockMorePistonsGravitational
extends BlockMorePistonsBase {
    public BlockMorePistonsGravitational(String registerName, boolean isSticky) {
        super(registerName, isSticky);
    }

    @Override
    protected void extend(World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpened) {
        int x2 = x;
        int y2 = y;
        int z2 = z;
        boolean sandEntity = false;
        for (int posEntity = 0; posEntity < lenghtOpened + this.getMaxBlockMove(); ++posEntity) {
            Block block = world.getBlock(x2 += Facing.offsetsXForSide[orientation], y2 += Facing.offsetsYForSide[orientation], z2 += Facing.offsetsZForSide[orientation]);
            if (!this.isEmptyBlock(block)) continue;
            int metadata = world.getBlockMetadata(x2, y2, z2);
            this.dropMobilityFlag1(block, metadata, world, x2, y2, z2);
            break;
        }
        int xSand = x2 - Facing.offsetsXForSide[orientation];
        int ySand = y2 - Facing.offsetsYForSide[orientation];
        int zSand = z2 - Facing.offsetsZForSide[orientation];
        Block block = world.getBlock(xSand, ySand, zSand);
        double i = 0.0;
        while (orientation == 1 && block instanceof BlockFalling) {
            world.setBlockToAir(xSand, ySand, zSand);
            if (!world.isRemote) {
                EntityFallingBlock entityFallingBlock = new EntityFallingBlock(world, (double)((float)x2 + 0.5f), (double)((float)y2 + 0.5f), (double)((float)z2 + 0.5f), block);
                entityFallingBlock.motionY += ModMorePistons.config.powerGravitationalPistons - 1.5 + i * 0.1;
                entityFallingBlock.field_145812_b = 1;
                world.spawnEntityInWorld((Entity)entityFallingBlock);
            }
            block = world.getBlock(xSand -= Facing.offsetsXForSide[orientation], ySand -= Facing.offsetsYForSide[orientation], zSand -= Facing.offsetsZForSide[orientation]);
            i += 1.0;
        }
        List entityList = world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBox((double)x2, (double)y2, (double)z2, (double)((double)x2 + 1.0), (double)((double)y2 + 1.0), (double)((double)z2 + 1.0)));
        if (entityList.size() == 0) {
            ModMorePistons.log.debug(new Object[]{"extend : " + x + ", " + y + ", " + z + " no entity"});
        }
        for (Entity entity : entityList) {
            ModMorePistons.log.debug(new Object[]{"extend : " + x + ", " + y + ", " + z + " entity=" + entity.getClass().getName()});
            entity.motionX += (double)Facing.offsetsXForSide[orientation] * ModMorePistons.config.powerGravitationalPistons * 7.0;
            entity.motionY += (double)Facing.offsetsYForSide[orientation] * ModMorePistons.config.powerGravitationalPistons;
            entity.motionZ += (double)Facing.offsetsZForSide[orientation] * ModMorePistons.config.powerGravitationalPistons * 7.0;
        }
        super.extend(world, x, y, z, orientation, currentOpened, lenghtOpened);
    }
}

