/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.morepistons.client.render;

import com.gollum.morepistons.common.block.BlockMorePistonsRod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class RenderBlocksMorePistons
extends RenderBlocks {
    public RenderBlocksMorePistons(IBlockAccess world) {
        super(world);
    }

    public boolean renderPistonBase(Block block, int x, int y, int z, boolean forceExtend) {
        block.setBlockBoundsBasedOnState(this.blockAccess, x, y, z);
        int metadata = this.blockAccess.getBlockMetadata(x, y, z);
        boolean extend = forceExtend || (metadata & 8) != 0;
        int orientation = BlockPistonBase.getPistonOrientation((int)metadata);
        if (extend) {
            switch (orientation) {
                case 0: {
                    this.uvRotateEast = 3;
                    this.uvRotateWest = 3;
                    this.uvRotateSouth = 3;
                    this.uvRotateNorth = 3;
                    this.setRenderBounds(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 1: {
                    this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                    break;
                }
                case 2: {
                    this.uvRotateSouth = 1;
                    this.uvRotateNorth = 2;
                    this.setRenderBounds(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
                    break;
                }
                case 3: {
                    this.uvRotateSouth = 2;
                    this.uvRotateNorth = 1;
                    this.uvRotateTop = 3;
                    this.uvRotateBottom = 3;
                    this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
                    break;
                }
                case 4: {
                    this.uvRotateEast = 1;
                    this.uvRotateWest = 2;
                    this.uvRotateTop = 2;
                    this.uvRotateBottom = 1;
                    this.setRenderBounds(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 5: {
                    this.uvRotateEast = 2;
                    this.uvRotateWest = 1;
                    this.uvRotateTop = 1;
                    this.uvRotateBottom = 2;
                    this.setRenderBounds(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
                }
            }
            block.setBlockBounds((float)this.renderMinX, (float)this.renderMinY, (float)this.renderMinZ, (float)this.renderMaxX, (float)this.renderMaxY, (float)this.renderMaxZ);
            this.renderStandardBlock(block, x, y, z);
            this.uvRotateEast = 0;
            this.uvRotateWest = 0;
            this.uvRotateSouth = 0;
            this.uvRotateNorth = 0;
            this.uvRotateTop = 0;
            this.uvRotateBottom = 0;
            this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            block.setBlockBounds((float)this.renderMinX, (float)this.renderMinY, (float)this.renderMinZ, (float)this.renderMaxX, (float)this.renderMaxY, (float)this.renderMaxZ);
        } else {
            switch (orientation) {
                case 0: {
                    this.uvRotateEast = 3;
                    this.uvRotateWest = 3;
                    this.uvRotateSouth = 3;
                    this.uvRotateNorth = 3;
                }
                default: {
                    break;
                }
                case 2: {
                    this.uvRotateSouth = 1;
                    this.uvRotateNorth = 2;
                    break;
                }
                case 3: {
                    this.uvRotateSouth = 2;
                    this.uvRotateNorth = 1;
                    this.uvRotateTop = 3;
                    this.uvRotateBottom = 3;
                    break;
                }
                case 4: {
                    this.uvRotateEast = 1;
                    this.uvRotateWest = 2;
                    this.uvRotateTop = 2;
                    this.uvRotateBottom = 1;
                    break;
                }
                case 5: {
                    this.uvRotateEast = 2;
                    this.uvRotateWest = 1;
                    this.uvRotateTop = 1;
                    this.uvRotateBottom = 2;
                }
            }
            this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.renderStandardBlock(block, x, y, z);
            this.uvRotateEast = 0;
            this.uvRotateWest = 0;
            this.uvRotateSouth = 0;
            this.uvRotateNorth = 0;
            this.uvRotateTop = 0;
            this.uvRotateBottom = 0;
        }
        return true;
    }

    public void renderPistonRod(Block block, int x, int y, int z, float progress) {
        int metadata = this.blockAccess.getBlockMetadata(x, y, z);
        this.renderPistonRod(block, x, y, z, metadata, progress);
    }

    public void renderPistonRod(Block block, int x, int y, int z, int metadata, float progress) {
        ((BlockMorePistonsRod)block).setBlockBoundsBasedOnState(metadata);
        this.setRenderBoundsFromBlock(block);
        int direction = BlockPistonExtension.getDirectionMeta((int)metadata);
        float f = 1.0f;
        switch (direction) {
            case 0: {
                this.uvRotateEast = 3;
                this.uvRotateWest = 3;
                this.uvRotateSouth = 3;
                this.uvRotateNorth = 3;
                this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
                this.renderPistonRodUD((float)x + 0.375f, (float)x + 0.625f, (float)y + 0.25f + f - progress, (float)y + 0.25f + f, (float)z + 0.625f, (float)z + 0.625f, 0.8f, 0.0, 16.0f * progress);
                this.renderPistonRodUD((float)x + 0.375f, (float)x + 0.625f, (float)y + 0.25f, (float)y + 0.25f + f - progress, (float)z + 0.625f, (float)z + 0.625f, 0.8f, 16.0f * progress, 16.0);
                this.renderPistonRodUD((float)x + 0.625f, (float)x + 0.375f, (float)y + 0.25f + f - progress, (float)y + 0.25f + f, (float)z + 0.375f, (float)z + 0.375f, 0.8f, 0.0, 16.0f * progress);
                this.renderPistonRodUD((float)x + 0.625f, (float)x + 0.375f, (float)y + 0.25f, (float)y + 0.25f + f - progress, (float)z + 0.375f, (float)z + 0.375f, 0.8f, 16.0f * progress, 16.0);
                this.renderPistonRodUD((float)x + 0.375f, (float)x + 0.375f, (float)y + 0.25f + f - progress, (float)y + 0.25f + f, (float)z + 0.375f, (float)z + 0.625f, 0.6f, 0.0, 16.0f * progress);
                this.renderPistonRodUD((float)x + 0.375f, (float)x + 0.375f, (float)y + 0.25f, (float)y + 0.25f + f - progress, (float)z + 0.375f, (float)z + 0.625f, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodUD((float)x + 0.625f, (float)x + 0.625f, (float)y + 0.25f + f - progress, (float)y + 0.25f + f, (float)z + 0.625f, (float)z + 0.375f, 0.6f, 0.0, 16.0f * progress);
                this.renderPistonRodUD((float)x + 0.625f, (float)x + 0.625f, (float)y + 0.25f, (float)y + 0.25f + f - progress, (float)z + 0.625f, (float)z + 0.375f, 0.6f, 16.0f * progress, 16.0);
                break;
            }
            case 1: {
                this.setRenderBounds(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
                this.renderPistonRodUD((float)x + 0.375f, (float)x + 0.625f, (float)y - 0.25f + 1.0f - f, (float)y - 0.25f + 1.0f - progress, (float)z + 0.625f, (float)z + 0.625f, 0.8f, 16.0f * progress, 16.0);
                this.renderPistonRodUD((float)x + 0.375f, (float)x + 0.625f, (float)y - 0.25f + 1.0f - f + 1.0f - progress, (float)y - 0.25f + 1.0f, (float)z + 0.625f, (float)z + 0.625f, 0.8f, 0.0, 16.0f * progress);
                this.renderPistonRodUD((float)x + 0.625f, (float)x + 0.375f, (float)y - 0.25f + 1.0f - f, (float)y - 0.25f + 1.0f - progress, (float)z + 0.375f, (float)z + 0.375f, 0.8f, 16.0f * progress, 16.0);
                this.renderPistonRodUD((float)x + 0.625f, (float)x + 0.375f, (float)y - 0.25f + 1.0f - f + 1.0f - progress, (float)y - 0.25f + 1.0f, (float)z + 0.375f, (float)z + 0.375f, 0.8f, 0.0, 16.0f * progress);
                this.renderPistonRodUD((float)x + 0.375f, (float)x + 0.375f, (float)y - 0.25f + 1.0f - f, (float)y - 0.25f + 1.0f - progress, (float)z + 0.375f, (float)z + 0.625f, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodUD((float)x + 0.375f, (float)x + 0.375f, (float)y - 0.25f + 1.0f - f + 1.0f - progress, (float)y - 0.25f + 1.0f, (float)z + 0.375f, (float)z + 0.625f, 0.6f, 0.0, 16.0f * progress);
                this.renderPistonRodUD((float)x + 0.625f, (float)x + 0.625f, (float)y - 0.25f + 1.0f - f, (float)y - 0.25f + 1.0f - progress, (float)z + 0.625f, (float)z + 0.375f, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodUD((float)x + 0.625f, (float)x + 0.625f, (float)y - 0.25f + 1.0f - f + 1.0f - progress, (float)y - 0.25f + 1.0f, (float)z + 0.625f, (float)z + 0.375f, 0.6f, 0.0, 16.0f * progress);
                break;
            }
            case 2: {
                this.uvRotateSouth = 1;
                this.uvRotateNorth = 2;
                this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
                this.renderPistonRodSN((float)x + 0.375f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.25f + f - progress, (float)z + 0.25f + f, 0.6f, 0.0, 16.0f * progress);
                this.renderPistonRodSN((float)x + 0.375f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.25f, (float)z + 0.25f + f - progress, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodSN((float)x + 0.625f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.25f + f - progress, (float)z + 0.25f + f, 0.6f, 0.0, 16.0f * progress);
                this.renderPistonRodSN((float)x + 0.625f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.25f, (float)z + 0.25f + f - progress, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodSN((float)x + 0.375f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.25f + f - progress, (float)z + 0.25f + f, 0.5f, 0.0, 16.0f * progress);
                this.renderPistonRodSN((float)x + 0.375f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.25f, (float)z + 0.25f + f - progress, 0.5f, 16.0f * progress, 16.0);
                this.renderPistonRodSN((float)x + 0.625f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.25f + f - progress, (float)z + 0.25f + f, 1.0f, 0.0, 16.0f * progress);
                this.renderPistonRodSN((float)x + 0.625f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.25f, (float)z + 0.25f + f - progress, 1.0f, 16.0f * progress, 16.0);
                break;
            }
            case 3: {
                this.uvRotateSouth = 2;
                this.uvRotateNorth = 1;
                this.uvRotateTop = 3;
                this.uvRotateBottom = 3;
                this.setRenderBounds(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
                this.renderPistonRodSN((float)x + 0.375f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.375f, (float)z - 0.25f + 1.0f - f, (float)z - 0.25f + 1.0f - progress, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodSN((float)x + 0.375f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.375f, (float)z - 0.25f + 1.0f - progress, (float)z - 0.25f + 1.0f, 0.6f, 0.0, 16.0f * progress);
                this.renderPistonRodSN((float)x + 0.625f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.625f, (float)z - 0.25f + 1.0f - f, (float)z - 0.25f + 1.0f - progress, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodSN((float)x + 0.625f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.625f, (float)z - 0.25f + 1.0f - progress, (float)z - 0.25f + 1.0f, 0.6f, 0.0, 16.0f * progress);
                this.renderPistonRodSN((float)x + 0.375f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.375f, (float)z - 0.25f + 1.0f - f, (float)z - 0.25f + 1.0f - progress, 0.5f, 16.0f * progress, 16.0);
                this.renderPistonRodSN((float)x + 0.375f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.375f, (float)z - 0.25f + 1.0f - progress, (float)z - 0.25f + 1.0f, 0.5f, 0.0, 16.0f * progress);
                this.renderPistonRodSN((float)x + 0.625f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.625f, (float)z - 0.25f + 1.0f - f, (float)z - 0.25f + 1.0f - progress, 1.0f, 16.0f * progress, 16.0);
                this.renderPistonRodSN((float)x + 0.625f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.625f, (float)z - 0.25f + 1.0f - progress, (float)z - 0.25f + 1.0f, 1.0f, 0.0, 16.0f * progress);
                break;
            }
            case 4: {
                this.uvRotateEast = 1;
                this.uvRotateWest = 2;
                this.uvRotateTop = 2;
                this.uvRotateBottom = 1;
                this.setRenderBounds(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
                this.renderPistonRodEW((float)x + 0.25f + f - progress, (float)x + 0.25f + f, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.375f, 0.5f, 0.0, 16.0f * progress);
                this.renderPistonRodEW((float)x + 0.25f, (float)x + 0.25f + f - progress, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.375f, 0.5f, 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x + 0.25f + f - progress, (float)x + 0.25f + f, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.625f, 1.0f, 0.0, 16.0f * progress);
                this.renderPistonRodEW((float)x + 0.25f, (float)x + 0.25f + f - progress, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.625f, 1.0f, 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x + 0.25f + f - progress, (float)x + 0.25f + f, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.375f, 0.6f, 0.0, 16.0f * progress);
                this.renderPistonRodEW((float)x + 0.25f, (float)x + 0.25f + f - progress, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.375f, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x + 0.25f + f - progress, (float)x + 0.25f + f, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.625f, 0.6f, 0.0, 16.0f * progress);
                this.renderPistonRodEW((float)x + 0.25f, (float)x + 0.25f + f - progress, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.625f, 0.6f, 16.0f * progress, 16.0);
                break;
            }
            case 5: {
                this.uvRotateEast = 2;
                this.uvRotateWest = 1;
                this.uvRotateTop = 1;
                this.uvRotateBottom = 2;
                this.setRenderBounds(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);
                this.renderPistonRodEW((float)x - 0.25f + 1.0f - f, (float)x - 0.25f + 1.0f - progress, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.375f, 0.5f, 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x - 0.25f + 1.0f, (float)x - 0.25f + 1.0f - progress, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.375f, 0.5f, 16.0f - 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x - 0.25f + 1.0f - f, (float)x - 0.25f + 1.0f - progress, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.625f, 1.0f, 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x - 0.25f + 1.0f, (float)x - 0.25f + 1.0f - progress, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.625f, 1.0f, 16.0f - 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x - 0.25f + 1.0f - f, (float)x - 0.25f + 1.0f - progress, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.375f, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x - 0.25f + 1.0f, (float)x - 0.25f + 1.0f - progress, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.375f, 0.6f, 16.0f - 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x - 0.25f + 1.0f - f, (float)x - 0.25f + 1.0f - progress, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.625f, 0.6f, 16.0f * progress, 16.0);
                this.renderPistonRodEW((float)x - 0.25f + 1.0f, (float)x - 0.25f + 1.0f - progress, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.625f, 0.6f, 16.0f - 16.0f * progress, 16.0);
            }
        }
        this.uvRotateEast = 0;
        this.uvRotateWest = 0;
        this.uvRotateSouth = 0;
        this.uvRotateNorth = 0;
        this.uvRotateTop = 0;
        this.uvRotateBottom = 0;
        this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void renderPistonRodUD(double x1, double x2, double y1, double y2, double z1, double z2, float alpha, double start, double end) {
        IIcon iicon = BlockPistonBase.getPistonBaseIcon((String)"piston_side");
        if (this.hasOverrideBlockTexture()) {
            iicon = this.overrideBlockTexture;
        }
        Tessellator tessellator = Tessellator.instance;
        double d7 = iicon.getInterpolatedU(start);
        double d8 = iicon.getMinV();
        double d9 = iicon.getInterpolatedU(end);
        double d10 = iicon.getInterpolatedV(4.0);
        tessellator.setColorOpaque_F(alpha, alpha, alpha);
        tessellator.addVertexWithUV(x1, y2, z1, d9, d8);
        tessellator.addVertexWithUV(x1, y1, z1, d7, d8);
        tessellator.addVertexWithUV(x2, y1, z2, d7, d10);
        tessellator.addVertexWithUV(x2, y2, z2, d9, d10);
    }

    public void renderPistonRodSN(double x1, double x2, double y1, double y2, double z1, double z2, float alpha, double start, double end) {
        IIcon iicon = BlockPistonBase.getPistonBaseIcon((String)"piston_side");
        if (this.hasOverrideBlockTexture()) {
            iicon = this.overrideBlockTexture;
        }
        Tessellator tessellator = Tessellator.instance;
        double d7 = iicon.getInterpolatedU(start);
        double d8 = iicon.getMinV();
        double d9 = iicon.getInterpolatedU(end);
        double d10 = iicon.getInterpolatedV(4.0);
        tessellator.setColorOpaque_F(alpha, alpha, alpha);
        tessellator.addVertexWithUV(x1, y1, z2, d9, d8);
        tessellator.addVertexWithUV(x1, y1, z1, d7, d8);
        tessellator.addVertexWithUV(x2, y2, z1, d7, d10);
        tessellator.addVertexWithUV(x2, y2, z2, d9, d10);
    }

    public void renderPistonRodEW(double x1, double x2, double y1, double y2, double z1, double z2, float alpha, double start, double end) {
        IIcon iicon = BlockPistonBase.getPistonBaseIcon((String)"piston_side");
        if (this.hasOverrideBlockTexture()) {
            iicon = this.overrideBlockTexture;
        }
        Tessellator tessellator = Tessellator.instance;
        double d7 = iicon.getInterpolatedU(start);
        double d8 = iicon.getMinV();
        double d9 = iicon.getInterpolatedU(end);
        double d10 = iicon.getInterpolatedV(4.0);
        tessellator.setColorOpaque_F(alpha, alpha, alpha);
        tessellator.addVertexWithUV(x2, y1, z1, d9, d8);
        tessellator.addVertexWithUV(x1, y1, z1, d7, d8);
        tessellator.addVertexWithUV(x1, y2, z2, d7, d10);
        tessellator.addVertexWithUV(x2, y2, z2, d9, d10);
    }
}

