/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.morepistons.common.block;

import com.gollum.core.utils.math.Integer3d;
import com.gollum.morepistons.ModMorePistons;
import com.gollum.morepistons.common.block.BlockMorePistonsBase;
import com.gollum.morepistons.common.block.superpiston.SuperPistonManager;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class BlockMorePistonsSuper
extends BlockMorePistonsBase {
    public BlockMorePistonsSuper(String registerName, boolean isSticky) {
        super(registerName, isSticky);
    }

    @Override
    public int getMaxBlockMove() {
        return ModMorePistons.config.numberMovableBlockWithSuperPiston;
    }

    @Override
    protected ArrayList<BlockMorePistonsBase.EMoveInfosExtend> listBlockExtend(World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpened) {
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> infosExtend = super.listBlockExtend(world, x, y, z, orientation, currentOpened, lenghtOpened, false);
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> upBlocks = this.listUpBlocks(infosExtend, world, x, y, z, orientation, currentOpened, lenghtOpened, true);
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> nextBlocks = this.listNextBlocks(infosExtend, world, x, y, z, orientation, currentOpened, lenghtOpened, true);
        for (BlockMorePistonsBase.EMoveInfosExtend infos : infosExtend) {
            if (infos.block == null || infos.position == null) continue;
            world.setTileEntity(infos.position.x, infos.position.y, infos.position.z, null);
            world.setBlock(infos.position.x, infos.position.y, infos.position.z, Blocks.air, 0, 0);
        }
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> all = new ArrayList<BlockMorePistonsBase.EMoveInfosExtend>();
        all.addAll(upBlocks);
        all.addAll(nextBlocks);
        all.addAll(infosExtend);
        return all;
    }

    @Override
    protected ArrayList<BlockMorePistonsBase.EMoveInfosExtend> listBlockRetract(World world, int x, int y, int z, int orientation, int lenghtClose, int stickySize) {
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> infosRetract = super.listBlockRetract(world, x, y, z, orientation, lenghtClose, stickySize, false);
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> upBlocks = this.listUpBlocks(infosRetract, world, x, y, z, orientation, 0, lenghtClose, false);
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> nextBlocks = this.listNextBlocks(infosRetract, world, x, y, z, orientation, 0, lenghtClose, false);
        for (BlockMorePistonsBase.EMoveInfosExtend infos : infosRetract) {
            if (infos.block == null || infos.position == null) continue;
            world.setTileEntity(infos.position.x, infos.position.y, infos.position.z, null);
            world.setBlock(infos.position.x, infos.position.y, infos.position.z, Blocks.air, 0, 0);
        }
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> all = new ArrayList<BlockMorePistonsBase.EMoveInfosExtend>();
        all.addAll(infosRetract);
        all.addAll(upBlocks);
        all.addAll(nextBlocks);
        return all;
    }

    protected ArrayList<BlockMorePistonsBase.EMoveInfosExtend> listUpBlocks(ArrayList<BlockMorePistonsBase.EMoveInfosExtend> blocksOrigin, World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpened, boolean extend) {
        int direction = extend ? 1 : -1;
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> blocksTop = new ArrayList<BlockMorePistonsBase.EMoveInfosExtend>();
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> dropList = new ArrayList<BlockMorePistonsBase.EMoveInfosExtend>();
        for (BlockMorePistonsBase.EMoveInfosExtend blockOrigin : blocksOrigin) {
            Block blockNext;
            int zExtension;
            int yExtension;
            int xExtension;
            int moveBlock;
            if (blockOrigin.block == null || blockOrigin.position == null || orientation == 0 || orientation == 1) continue;
            int xBlock = blockOrigin.position.x;
            int yBlock = blockOrigin.position.y + 1;
            int zBlock = blockOrigin.position.z;
            BlockMorePistonsSuper.cleanBlockMoving(world, xBlock, yBlock, zBlock);
            Block block = world.getBlock(xBlock, yBlock, zBlock);
            int metadata = world.getBlockMetadata(xBlock, yBlock, zBlock);
            TileEntity te = world.getTileEntity(xBlock, yBlock, zBlock);
            if (block == null || block == Blocks.air) continue;
            if (!this.isEmptyBlock(block) && !SuperPistonManager.instance.dontMoveIfOnTop(block, metadata, world, xBlock, yBlock, zBlock, extend ? orientation : Facing.oppositeSide[orientation])) {
                moveBlock = 0;
                if (this.isMovableBlock(block, world, xBlock, yBlock, zBlock)) {
                    xExtension = xBlock;
                    yExtension = yBlock;
                    zExtension = zBlock;
                    for (moveBlock = 0; moveBlock < blockOrigin.move; ++moveBlock) {
                        BlockMorePistonsSuper.cleanBlockMoving(world, xExtension += Facing.offsetsXForSide[orientation] * direction, yExtension += Facing.offsetsYForSide[orientation] * direction, zExtension += Facing.offsetsZForSide[orientation] * direction);
                        blockNext = world.getBlock(xExtension, yExtension, zExtension);
                        if (!this.isEmptyBlock(blockNext)) break;
                        if (blockNext == null || blockNext == Blocks.air) continue;
                        int metadataNext = world.getBlockMetadata(xExtension, yExtension, zExtension);
                        if (block == null || block == Blocks.air || block.getMobilityFlag() != 1) continue;
                        dropList.add(new BlockMorePistonsBase.EMoveInfosExtend(block, metadata, te, new Integer3d(xExtension, yExtension, zExtension), 0, 1));
                    }
                }
                if (moveBlock <= 0) continue;
                world.setTileEntity(xBlock, yBlock, zBlock, null);
                world.setBlock(xBlock, yBlock, zBlock, Blocks.air, 0, 0);
                xExtension = xBlock;
                yExtension = yBlock;
                zExtension = zBlock;
                for (int j = 0; j < moveBlock; ++j) {
                    BlockMorePistonsSuper.cleanBlockMoving(world, xExtension += Facing.offsetsXForSide[orientation] * direction, yExtension += Facing.offsetsYForSide[orientation] * direction, zExtension += Facing.offsetsZForSide[orientation] * direction);
                    Block blockNext2 = world.getBlock(xExtension, yExtension, zExtension);
                    if (blockNext2 == null || block == Blocks.air) continue;
                    int metadataNext = world.getBlockMetadata(xExtension, yExtension, zExtension);
                    if (block == null || block == Blocks.air || block.getMobilityFlag() != 1) continue;
                    dropList.add(new BlockMorePistonsBase.EMoveInfosExtend(block, metadata, te, new Integer3d(xExtension, yExtension, zExtension), 0, 1));
                }
                blocksTop.add(new BlockMorePistonsBase.EMoveInfosExtend(block, metadata, te, new Integer3d(xBlock, yBlock, zBlock), moveBlock, 1));
                continue;
            }
            if (SuperPistonManager.instance.isntAttachOnTop(block, metadata, world, xBlock, yBlock, zBlock, extend ? orientation : Facing.oppositeSide[orientation])) continue;
            moveBlock = 0;
            xExtension = xBlock;
            yExtension = yBlock;
            zExtension = zBlock;
            for (moveBlock = 0; moveBlock < blockOrigin.move; ++moveBlock) {
                BlockMorePistonsSuper.cleanBlockMoving(world, xExtension += Facing.offsetsXForSide[orientation] * direction, yExtension += Facing.offsetsYForSide[orientation] * direction, zExtension += Facing.offsetsZForSide[orientation] * direction);
                blockNext = world.getBlock(xExtension, yExtension, zExtension);
                if (blockNext != null && blockNext != Blocks.air) break;
            }
            if (moveBlock != blockOrigin.move) {
                this.dropMobilityFlag1(block, metadata, world, xBlock, yBlock, zBlock);
                continue;
            }
            world.setTileEntity(xBlock, yBlock, zBlock, null);
            world.setBlock(xBlock, yBlock, zBlock, Blocks.air, 0, 0);
            xExtension = xBlock + Facing.offsetsXForSide[orientation] * moveBlock * direction;
            yExtension = yBlock + Facing.offsetsYForSide[orientation] * moveBlock * direction;
            zExtension = zBlock + Facing.offsetsZForSide[orientation] * moveBlock * direction;
            blocksTop.add(new BlockMorePistonsBase.EMoveInfosExtend(block, metadata, te, new Integer3d(xBlock, yBlock, zBlock), moveBlock, 1));
        }
        for (BlockMorePistonsBase.EMoveInfosExtend info : dropList) {
            this.dropMobilityFlag1(info.block, info.metadata, world, info.position.x, info.position.y, info.position.z);
        }
        return blocksTop;
    }

    protected ArrayList<BlockMorePistonsBase.EMoveInfosExtend> listNextBlocks(ArrayList<BlockMorePistonsBase.EMoveInfosExtend> blocksOrigin, World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpened, boolean extend) {
        int direction = extend ? 1 : -1;
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> blocksList = new ArrayList<BlockMorePistonsBase.EMoveInfosExtend>();
        ArrayList<BlockMorePistonsBase.EMoveInfosExtend> dropList = new ArrayList<BlockMorePistonsBase.EMoveInfosExtend>();
        for (BlockMorePistonsBase.EMoveInfosExtend blockOrigin : blocksOrigin) {
            if (blockOrigin.block == null || blockOrigin.position == null) continue;
            for (int o = 2; o <= 5; ++o) {
                if (o == orientation || o == Facing.oppositeSide[orientation]) continue;
                int xBlock = blockOrigin.position.x + Facing.offsetsXForSide[o] * direction;
                int yBlock = blockOrigin.position.y;
                int zBlock = blockOrigin.position.z + Facing.offsetsZForSide[o] * direction;
                BlockMorePistonsSuper.cleanBlockMoving(world, xBlock, yBlock, zBlock);
                Block block = world.getBlock(xBlock, yBlock, zBlock);
                int metadata = world.getBlockMetadata(xBlock, yBlock, zBlock);
                TileEntity te = world.getTileEntity(xBlock, yBlock, zBlock);
                if (block == null || block == Blocks.air || !this.isEmptyBlock(block) && !SuperPistonManager.instance.isAttachableBlockOnNext(block, metadata, world, xBlock, yBlock, zBlock, extend ? o : Facing.oppositeSide[o]) || !SuperPistonManager.instance.isAttachOnNext(block, metadata, world, xBlock, yBlock, zBlock, extend ? o : Facing.oppositeSide[o])) continue;
                int moveBlock = 0;
                int xExtension = xBlock;
                int yExtension = yBlock;
                int zExtension = zBlock;
                for (moveBlock = 0; moveBlock < blockOrigin.move; ++moveBlock) {
                    BlockMorePistonsSuper.cleanBlockMoving(world, xExtension += Facing.offsetsXForSide[orientation] * direction, yExtension += Facing.offsetsYForSide[orientation] * direction, zExtension += Facing.offsetsZForSide[orientation] * direction);
                    Block blockNext = world.getBlock(xExtension, yExtension, zExtension);
                    if (blockNext != null && blockNext != Blocks.air) break;
                }
                if (moveBlock != blockOrigin.move) {
                    if (block == null || block == Blocks.air || block.getMobilityFlag() != 1) continue;
                    dropList.add(new BlockMorePistonsBase.EMoveInfosExtend(block, metadata, te, new Integer3d(xExtension, yExtension, zExtension), 0, 1));
                    continue;
                }
                world.setBlockToAir(xBlock, yBlock, zBlock);
                xExtension = xBlock + Facing.offsetsXForSide[orientation] * moveBlock;
                yExtension = yBlock + Facing.offsetsYForSide[orientation] * moveBlock;
                zExtension = zBlock + Facing.offsetsZForSide[orientation] * moveBlock;
                blocksList.add(new BlockMorePistonsBase.EMoveInfosExtend(block, metadata, te, new Integer3d(xBlock, yBlock, zBlock), moveBlock, 1));
            }
        }
        for (BlockMorePistonsBase.EMoveInfosExtend info : dropList) {
            this.dropMobilityFlag1(info.block, info.metadata, world, info.position.x, info.position.y, info.position.z);
        }
        return blocksList;
    }
}

