/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.morepistons.common.block;

import com.gollum.core.common.blocks.IBlockDisplayInfos;
import com.gollum.core.tools.helper.blocks.HBlockContainer;
import com.gollum.core.utils.math.Integer3d;
import com.gollum.morepistons.ModMorePistons;
import com.gollum.morepistons.common.CommonProxyMorePistons;
import com.gollum.morepistons.common.block.BlockMorePistonsExtension;
import com.gollum.morepistons.common.block.BlockMorePistonsMoving;
import com.gollum.morepistons.common.block.BlockMorePistonsRod;
import com.gollum.morepistons.common.tileentities.TileEntityMorePistonsMoving;
import com.gollum.morepistons.common.tileentities.TileEntityMorePistonsPiston;
import com.gollum.morepistons.common.tileentities.TileEntityMorePistonsRod;
import com.gollum.morepistons.inits.ModBlocks;
import com.gollum.morepistons.inits.ModCreativeTab;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.RotationHelper;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockMorePistonsBase
extends HBlockContainer
implements IBlockDisplayInfos {
    protected boolean isSticky;
    private int length = 1;
    protected Icon iconTop;
    protected Icon iconOpen;
    protected Icon iconBottom;
    protected String suffixTop = "_top";
    protected String suffixSticky = "_sticky";
    protected String suffixOpen = "_open";
    protected String suffixBottom = "_bottom";
    protected String suffixSide = "_side";

    public BlockMorePistonsBase(int id, String registerName, boolean isSticky) {
        super(id, registerName, Material.field_76233_E);
        this.isSticky = isSticky;
        this.func_71884_a(field_71976_h);
        this.func_71848_c(0.5f);
        this.func_71849_a((CreativeTabs)ModCreativeTab.morePistonsTabs);
    }

    public TileEntity func_72274_a(World p_149915_1) {
        return new TileEntityMorePistonsPiston();
    }

    public BlockMorePistonsBase setLength(int length) {
        this.length = length;
        return this;
    }

    public int getLengthInWorld(World world, int x, int y, int z, int orientation) {
        return this.length;
    }

    public boolean isSticky() {
        return this.isSticky;
    }

    public int getMaxBlockMove() {
        return ModMorePistons.config.numberMovableBlockWithDefaultPiston;
    }

    public boolean func_71886_c() {
        return false;
    }

    public BlockMorePistonsExtension getBlockExtention() {
        return ModBlocks.blockPistonExtention;
    }

    public String getTextureKey() {
        return super.getTextureKey().replace("sticky", "");
    }

    public void func_94332_a(IconRegister iconRegister) {
        if (this.helper.vanillaTexture) {
            super.func_94332_a(iconRegister);
            return;
        }
        this.registerIconsTop(iconRegister);
        this.registerIconsOpen(iconRegister);
        this.registerIconsBottom(iconRegister);
        this.registerIconsSide(iconRegister);
    }

    protected void registerIconsTop(IconRegister iconRegister) {
        this.iconTop = this.helper.loadTexture(iconRegister, "top" + (this.isSticky ? this.suffixSticky : ""), true);
    }

    protected void registerIconsOpen(IconRegister iconRegister) {
        this.iconOpen = this.helper.loadTexture(iconRegister, this.suffixOpen);
    }

    protected void registerIconsBottom(IconRegister iconRegister) {
        this.iconBottom = this.helper.loadTexture(iconRegister, this.suffixBottom);
    }

    protected void registerIconsSide(IconRegister iconRegister) {
        this.field_94336_cN = this.helper.loadTexture(iconRegister, this.suffixSide);
    }

    public Icon func_71858_a(int side, int metadata) {
        if (this.helper.vanillaTexture) {
            return super.func_71858_a(side, metadata);
        }
        int orientation = BlockPistonBase.func_72117_e((int)metadata);
        if (orientation > 5) {
            return this.iconTop;
        }
        if (side == orientation) {
            if (BlockPistonBase.func_72114_f((int)metadata) || this.field_72026_ch > 0.0 || this.field_72023_ci > 0.0 || this.field_72024_cj > 0.0 || this.field_72021_ck < 1.0 || this.field_72022_cl < 1.0 || this.field_72019_cm < 1.0) {
                return this.iconOpen;
            }
            return this.iconTop;
        }
        return side != Facing.field_71588_a[orientation] ? this.field_94336_cN : this.iconBottom;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getPistonExtensionTexture() {
        if (this.helper.vanillaTexture) {
            return this.isSticky ? Block.field_71956_V.func_72118_n() : Block.field_71963_Z.func_72118_n();
        }
        return this.iconTop;
    }

    public boolean func_71926_d() {
        return false;
    }

    public int func_71857_b() {
        return CommonProxyMorePistons.idMorePistonsBaseRenderer;
    }

    public String displayDebugInfos(World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityMorePistonsPiston) {
            TileEntityMorePistonsPiston tileEntityPiston = (TileEntityMorePistonsPiston)te;
            return "T.E.M.P.Piston : currentOpened :" + tileEntityPiston.currentOpened;
        }
        return null;
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_71871_a(world, x, y, z, aabb, list, entity);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71872_e(world, x, y, z);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (BlockPistonBase.func_72114_f((int)metadata)) {
            switch (BlockPistonBase.func_72117_e((int)metadata)) {
                case 0: {
                    this.func_71905_a(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.func_71905_a(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.func_71905_a(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.func_71905_a(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_71919_f() {
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_71898_d(World world, int x, int y, int z, int metadata) {
        ModMorePistons.log.debug(new Object[]{"onBlockDestroyedByPlayer : " + x + ", " + y + ", " + z});
        int orientation = BlockPistonBase.func_72117_e((int)metadata);
        BlockMorePistonsRod block = ModBlocks.blockPistonRod;
        while (block instanceof BlockMorePistonsRod) {
            BlockMorePistonsBase.cleanBlockMoving(world, x += Facing.field_71586_b[orientation], y += Facing.field_71587_c[orientation], z += Facing.field_71585_d[orientation]);
            int id = world.func_72798_a(x, y, z);
            block = Block.field_71973_m[id];
            if (BlockPistonBase.func_72117_e((int)world.func_72805_g(x, y, z)) != orientation || !(block instanceof BlockMorePistonsRod) && !(block instanceof BlockMorePistonsExtension)) continue;
            world.func_94578_a(x, y, z, false);
        }
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int orientation = BlockPistonBase.func_72116_b((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entityLiving);
        world.func_72921_c(x, y, z, orientation, 2);
        ModMorePistons.log.debug(new Object[]{"onBlockPlacedBy : " + x + ", " + y + ", " + z});
        if (!world.field_72995_K) {
            this.updatePistonState(world, x, y, z);
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        ModMorePistons.log.debug(new Object[]{"onNeighborBlockChange : " + x + ", " + y + ", " + z});
        if (!world.field_72995_K && !this.isRunning(world, x, y, z)) {
            this.updatePistonState(world, x, y, z);
        }
    }

    public void func_71861_g(World world, int x, int y, int z) {
        ModMorePistons.log.debug(new Object[]{"onBlockAdded : " + x + ", " + y + ", " + z});
        if (!world.field_72995_K && world.func_72796_p(x, y, z) == null) {
            this.updatePistonState(world, x, y, z);
        }
    }

    public void updatePistonState(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (this.isRunning(world, x, y, z)) {
            ModMorePistons.log.debug(new Object[]{"Piston already running"});
            return;
        }
        if (metadata == 7) {
            return;
        }
        if (BlockMorePistonsBase.isRetract(world, x, y, z)) {
            ModMorePistons.log.debug(new Object[]{"Piston work for retrac"});
            return;
        }
        BlockMorePistonsBase.cleanBlockMoving(world, x, y, z);
        int orientation = BlockPistonBase.func_72117_e((int)metadata);
        boolean powered = this.isIndirectlyPowered(world, x, y, z, orientation);
        int currentOpened = 0;
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityMorePistonsMoving) {
            te = ((TileEntityMorePistonsMoving)te).getPistonOriginTE();
        }
        if (te instanceof TileEntityMorePistonsPiston) {
            currentOpened = ((TileEntityMorePistonsPiston)te).currentOpened;
        }
        this.setRunning(world, x, y, z, true);
        ModMorePistons.log.debug(new Object[]{"updatePistonState : ", x, y, z, "orientation=" + orientation, "powered=" + powered, "currentOpened=" + currentOpened});
        if (powered) {
            world.func_72921_c(x, y, z, orientation | 8, 0);
        } else {
            world.func_72921_c(x, y, z, orientation, 0);
        }
        world.func_72965_b(x, y, z, this.field_71990_ca, 0, currentOpened);
    }

    public boolean func_71883_b(World world, int x, int y, int z, int event, int currentOpened) {
        if (event != 0) {
            return false;
        }
        int lenghtOpened = 0;
        int metadata = world.func_72805_g(x, y, z);
        int orientation = BlockPistonBase.func_72117_e((int)metadata);
        boolean powered = this.isIndirectlyPowered(world, x, y, z, orientation);
        if (powered) {
            lenghtOpened = this.getMaximalOpenedLenght(world, x, y, z, orientation);
        }
        ModMorePistons.log.debug(new Object[]{"onBlockEventReceived : ", x, y, z, "orientation=" + orientation, "lenghtOpened=" + lenghtOpened, "remote=" + world.field_72995_K});
        boolean extendOpen = false;
        boolean extendClose = false;
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityMorePistonsPiston) {
            TileEntityMorePistonsPiston tileEntityPiston = (TileEntityMorePistonsPiston)te;
            if (lenghtOpened > 0) {
                ModMorePistons.log.debug(new Object[]{"demande d'ouverture : ", x, y, z});
                if (currentOpened == lenghtOpened) {
                    ModMorePistons.log.debug(new Object[]{"Le piston reste immobile : ", x, y, z, "currentOpened=" + currentOpened, "remote=" + world.field_72995_K});
                } else if (currentOpened < lenghtOpened) {
                    ModMorePistons.log.debug(new Object[]{"Le piston s'ouvre : ", x, y, z, "currentOpened=" + currentOpened, "remote=" + world.field_72995_K});
                    world.func_72921_c(x, y, z, orientation | 8, 2);
                    tileEntityPiston.currentOpened = lenghtOpened;
                    this.extend(world, x, y, z, orientation, currentOpened, lenghtOpened);
                    extendOpen = true;
                } else {
                    ModMorePistons.log.debug(new Object[]{"Le piston se retracte : ", x, y, z, "currentOpened=" + currentOpened, "remote=" + world.field_72995_K});
                    tileEntityPiston.currentOpened = lenghtOpened;
                    this.retract(world, x, y, z, orientation, currentOpened, lenghtOpened);
                    extendClose = true;
                }
            } else {
                ModMorePistons.log.debug(new Object[]{"demande de fermeture : ", x, y, z});
                if (currentOpened == 0) {
                    ModMorePistons.log.debug(new Object[]{"Le piston reste immobile : ", x, y, z, "currentOpened=" + currentOpened, "remote=" + world.field_72995_K});
                    world.func_72921_c(x, y, z, orientation, 0);
                } else {
                    ModMorePistons.log.debug(new Object[]{"Le piston se ferme : ", x, y, z, "currentOpened=" + currentOpened, "remote=" + world.field_72995_K});
                    tileEntityPiston.currentOpened = lenghtOpened;
                    this.retract(world, x, y, z, orientation, currentOpened, lenghtOpened);
                    extendClose = true;
                }
            }
        }
        if (extendOpen) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
        }
        if (extendClose) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
        }
        this.setRunning(world, x, y, z, false);
        if (extendOpen || extendClose) {
            world.func_72821_m(x, y, z, this.field_71990_ca);
        }
        return true;
    }

    public int getStickySize(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityMorePistonsMoving) {
            te = ((TileEntityMorePistonsMoving)te).getPistonOriginTE();
        }
        if (te instanceof TileEntityMorePistonsPiston) {
            return ((TileEntityMorePistonsPiston)te).stickySize;
        }
        return 1;
    }

    public boolean isRunning(World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityMorePistonsMoving) {
            te = ((TileEntityMorePistonsMoving)te).getPistonOriginTE();
        }
        if (te instanceof TileEntityMorePistonsPiston) {
            return ((TileEntityMorePistonsPiston)te).running;
        }
        return false;
    }

    public void setRunning(World world, int x, int y, int z, boolean running) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityMorePistonsMoving) {
            te = ((TileEntityMorePistonsMoving)te).getPistonOriginTE();
        }
        if (te instanceof TileEntityMorePistonsPiston) {
            ((TileEntityMorePistonsPiston)te).running = running;
        }
    }

    protected boolean isIndirectlyPowered(World world, int x, int y, int z, int orientation) {
        if (orientation != 0 && world.func_94574_k(x, y - 1, z, 0)) {
            return true;
        }
        if (orientation != 1 && world.func_94574_k(x, y + 1, z, 1)) {
            return true;
        }
        if (orientation != 2 && world.func_94574_k(x, y, z - 1, 2)) {
            return true;
        }
        if (orientation != 3 && world.func_94574_k(x, y, z + 1, 3)) {
            return true;
        }
        if (orientation != 5 && world.func_94574_k(x + 1, y, z, 5)) {
            return true;
        }
        if (orientation != 4 && world.func_94574_k(x - 1, y, z, 4)) {
            return true;
        }
        if (world.func_94574_k(x, y, z, 0)) {
            return true;
        }
        if (world.func_94574_k(x, y + 2, z, 1)) {
            return true;
        }
        if (world.func_94574_k(x, y + 1, z - 1, 2)) {
            return true;
        }
        if (world.func_94574_k(x, y + 1, z + 1, 3)) {
            return true;
        }
        if (world.func_94574_k(x - 1, y + 1, z, 4)) {
            return true;
        }
        boolean flag = world.func_94574_k(x + 1, y + 1, z, 5);
        return flag;
    }

    public int getMaximalOpenedLenght(World world, int x, int y, int z, int orientation) {
        return this.getMaximalOpenedLenght(world, x, y, z, orientation, this.getLengthInWorld(world, x, y, z, orientation));
    }

    public int getMaximalOpenedLenght(World world, int x, int y, int z, int orientation, int maxlenght) {
        int oX = x;
        int oY = y;
        int oZ = z;
        ModMorePistons.log.debug(new Object[]{"getMaximalOpenedLenght : " + x + ", " + y + ", " + z + " maxlenght=" + maxlenght});
        int lenght = 0;
        for (int i = 0; i < maxlenght; ++i) {
            x += Facing.field_71586_b[orientation];
            z += Facing.field_71585_d[orientation];
            if ((y += Facing.field_71587_c[orientation]) >= 255) {
                ModMorePistons.log.debug(new Object[]{"getMaximalOpenedLenght : " + x + ", " + y + ", " + z + " y>=255"});
                break;
            }
            int id = world.func_72798_a(x, y, z);
            Block block = Block.field_71973_m[id];
            if (block instanceof BlockPistonMoving || block instanceof BlockMorePistonsMoving) {
                ModMorePistons.log.debug(new Object[]{"getMaximalOpenedLenght : " + x + ", " + y + ", " + z + " find PistonMoving"});
                TileEntity te = world.func_72796_p(x, y, z);
                if (block instanceof BlockMorePistonsMoving && te instanceof TileEntityMorePistonsMoving && ((TileEntityMorePistonsMoving)te).storedBlock instanceof BlockMorePistonsExtension && ((TileEntityMorePistonsMoving)te).positionPiston.equals((Object)new Integer3d(oX, oY, oZ))) {
                    ModMorePistons.log.debug(new Object[]{"getMaximalOpenedLenght : " + x + ", " + y + ", " + z + " is Extention"});
                    return lenght + 1;
                }
                ModMorePistons.log.debug(new Object[]{"getMaximalOpenedLenght : " + x + ", " + y + ", " + z + " clean and continue"});
                BlockMorePistonsBase.cleanBlockMoving(world, x, y, z);
                id = world.func_72798_a(x, y, z);
                block = Block.field_71973_m[id];
            }
            ModMorePistons.log.debug(new Object[]{"getMaximalOpenedLenght : " + x + ", " + y + ", " + z});
            if (!this.isEmptyBlock(block) && !this.isRodInOrientation(block, world, x, y, z, orientation)) {
                lenght += this.getMoveBlockOnDistance(maxlenght - i, world, block, x, y, z, orientation);
                break;
            }
            ++lenght;
        }
        ModMorePistons.log.debug(new Object[]{"getMaximalOpenedLenght : " + x + ", " + y + ", " + z + " : lenght=" + lenght});
        return lenght;
    }

    private boolean isRodInOrientation(Block block, World world, int x, int y, int z, int orientation) {
        if (block instanceof BlockMorePistonsExtension || block instanceof BlockPistonExtension || block instanceof BlockMorePistonsRod) {
            return orientation == BlockPistonBase.func_72117_e((int)world.func_72805_g(x, y, z));
        }
        return false;
    }

    public boolean isEmptyBlock(Block block) {
        return block == null || block.func_71915_e() == 1 || block instanceof BlockFluid || block instanceof IFluidBlock;
    }

    private int getMoveBlockOnDistance(int distance, World world, Block block, int x, int y, int z, int orientation) {
        return this.getMoveBlockOnDistance(distance, world, block, x, y, z, orientation, 1);
    }

    private int getMoveBlockOnDistance(int distance, World world, Block block, int x, int y, int z, int orientation, int nbMoved) {
        if (nbMoved == this.getMaxBlockMove() || !this.isMovableBlock(block, world, x, y, z)) {
            return 0;
        }
        int walking = 0;
        for (int i = 0; i < distance; ++i) {
            x += Facing.field_71586_b[orientation];
            z += Facing.field_71585_d[orientation];
            if ((y += Facing.field_71587_c[orientation]) >= 255) break;
            int idNext = world.func_72798_a(x, y, z);
            Block blockNext = Block.field_71973_m[idNext];
            if (this.isEmptyBlock(blockNext)) {
                ++walking;
                continue;
            }
            int moving = this.getMoveBlockOnDistance(distance - i, world, blockNext, x, y, z, orientation, nbMoved + 1);
            walking += moving;
            break;
        }
        return walking;
    }

    public boolean isMovableBlock(Block block, World world, int x, int y, int z) {
        boolean isPistonClosed = BlockMorePistonsBase.isPiston(block);
        if (isPistonClosed) {
            isPistonClosed = !BlockPistonBase.func_72114_f((int)world.func_72805_g(x, y, z));
        }
        return this.isEmptyBlock(block) || isPistonClosed || block != Block.field_72089_ap && block.func_71915_e() != 2 && !(block instanceof BlockMorePistonsRod) && !(block instanceof BlockPistonExtension) && !(block instanceof BlockMorePistonsExtension) && !(block instanceof BlockMorePistonsMoving) && world.func_72796_p(x, y, z) == null && block.func_71934_m(world, x, y, z) != -1.0f;
    }

    public static boolean isPiston(Block block) {
        return block instanceof BlockPistonBase || block instanceof BlockMorePistonsBase;
    }

    protected void dropMobilityFlag1(Block block, int metadata, World world, int x, int y, int z) {
        if (block != null && block.func_71915_e() == 1) {
            float chance = block instanceof BlockSnow ? -1.0f : 1.0f;
            block.func_71914_a(world, x, y, z, metadata, chance, 0);
            world.func_94571_i(x, y, z);
        }
    }

    protected ArrayList<EMoveInfosExtend> listBlockExtend(World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpened) {
        return this.listBlockExtend(world, x, y, z, orientation, currentOpened, lenghtOpened, true);
    }

    protected ArrayList<EMoveInfosExtend> listBlockExtend(World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpened, boolean removeAfter) {
        int xExtension = x + Facing.field_71586_b[orientation] * currentOpened;
        int yExtension = y + Facing.field_71587_c[orientation] * currentOpened;
        int zExtension = z + Facing.field_71585_d[orientation] * currentOpened;
        ArrayList<EMoveInfosExtend> infosExtend = new ArrayList<EMoveInfosExtend>();
        ArrayList<EMoveInfosExtend> dropList = new ArrayList<EMoveInfosExtend>();
        int size = lenghtOpened - currentOpened;
        for (int i = 0; i < lenghtOpened + this.getMaxBlockMove() && size > 0; ++i) {
            int id = world.func_72798_a(xExtension += Facing.field_71586_b[orientation], yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation]);
            Block block = Block.field_71973_m[id];
            TileEntity te = world.func_72796_p(xExtension, yExtension, zExtension);
            int metadata = world.func_72805_g(xExtension, yExtension, zExtension);
            if (block != null && block.func_71915_e() == 1) {
                dropList.add(new EMoveInfosExtend(block, metadata, te, new Integer3d(xExtension, yExtension, zExtension), 0));
            }
            if (this.isEmptyBlock(block)) {
                infosExtend.add(new EMoveInfosExtend());
                --size;
                continue;
            }
            if (!this.isMovableBlock(block, world, xExtension, yExtension, zExtension)) break;
            infosExtend.add(new EMoveInfosExtend(block, metadata, te, new Integer3d(xExtension, yExtension, zExtension), size));
            if (!removeAfter) continue;
            world.func_72837_a(xExtension, yExtension, zExtension, null);
            world.func_72832_d(xExtension, yExtension, zExtension, 0, 0, 0);
        }
        Collections.reverse(infosExtend);
        for (EMoveInfosExtend info : dropList) {
            this.dropMobilityFlag1(info.block, info.metadata, world, info.position.x, info.position.y, info.position.z);
        }
        return infosExtend;
    }

    protected ArrayList<EMoveInfosExtend> listBlockRetract(World world, int x, int y, int z, int orientation, int lenghtClose, int stickySize) {
        return this.listBlockRetract(world, x, y, z, orientation, lenghtClose, stickySize, true);
    }

    protected ArrayList<EMoveInfosExtend> listBlockRetract(World world, int x, int y, int z, int orientation, int lenghtClose, int stickySize, boolean removeAfter) {
        ArrayList<EMoveInfosExtend> infosRetract = new ArrayList<EMoveInfosExtend>();
        for (int i = 1; i <= stickySize; ++i) {
            int xP1 = x + Facing.field_71586_b[orientation] * (lenghtClose + i);
            int yP1 = y + Facing.field_71587_c[orientation] * (lenghtClose + i);
            int zP1 = z + Facing.field_71585_d[orientation] * (lenghtClose + i);
            BlockMorePistonsBase.cleanBlockMoving(world, xP1, yP1, zP1);
            int id = world.func_72798_a(xP1, yP1, zP1);
            Block block = Block.field_71973_m[id];
            int metadata = world.func_72805_g(xP1, yP1, zP1);
            TileEntity tileEntity = BlockMorePistonsBase.cloneTileEntity(world.func_72796_p(xP1, yP1, zP1));
            if (this.isEmptyBlock(block) || !this.isMovableBlock(block, world, xP1, yP1, zP1)) break;
            infosRetract.add(new EMoveInfosExtend(block, metadata, tileEntity, new Integer3d(xP1, yP1, zP1), lenghtClose));
            if (!removeAfter) continue;
            world.func_72837_a(xP1, yP1, zP1, null);
            world.func_72832_d(xP1, yP1, zP1, 0, 0, 0);
        }
        return infosRetract;
    }

    public static boolean cleanBlockMoving(World world, int x, int y, int z) {
        TileEntity oldTe = world.func_72796_p(x, y, z);
        if (oldTe instanceof TileEntityMorePistonsMoving) {
            ((TileEntityMorePistonsMoving)oldTe).setBlockFinalMove();
            return true;
        }
        if (oldTe instanceof TileEntityPiston) {
            ((TileEntityPiston)oldTe).func_70339_i();
            return true;
        }
        return false;
    }

    public static boolean isRetract(World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityMorePistonsPiston) {
            te = ((TileEntityMorePistonsPiston)te).getBlockTileEntityMoving();
        }
        if (te instanceof TileEntityMorePistonsMoving) {
            return !((TileEntityMorePistonsMoving)te).extending;
        }
        return false;
    }

    public static TileEntity cloneTileEntity(TileEntity te) {
        if (te == null) {
            return null;
        }
        TileEntity teCopy = te;
        try {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            te.func_70310_b(nbtTagCompound);
            teCopy = TileEntity.func_70317_c((NBTTagCompound)nbtTagCompound);
            teCopy.func_70308_a(te.func_70314_l());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return teCopy;
    }

    protected void retract(World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpenned) {
        ModMorePistons.log.debug(new Object[]{"Create PistonMoving : " + x, y, z, "orientation=" + orientation, "currentOpened=" + currentOpened, "lenghtOpenned=" + lenghtOpenned});
        int xOri = x + Facing.field_71586_b[orientation] * currentOpened;
        int yOri = y + Facing.field_71587_c[orientation] * currentOpened;
        int zOri = z + Facing.field_71585_d[orientation] * currentOpened;
        int xDest = x + Facing.field_71586_b[orientation] * lenghtOpenned;
        int yDest = y + Facing.field_71587_c[orientation] * lenghtOpenned;
        int zDest = z + Facing.field_71585_d[orientation] * lenghtOpenned;
        BlockMorePistonsBase.cleanBlockMoving(world, xOri, yOri, zOri);
        TileEntity teCopy = BlockMorePistonsBase.cloneTileEntity(world.func_72796_p(x, y, z));
        HBlockContainer block = this;
        if (!new Integer3d(x, y, z).equals((Object)new Integer3d(xDest, yDest, zDest))) {
            block = ModBlocks.blockPistonRod;
        }
        this.createMoving(world, new Integer3d(x, y, z), new Integer3d(xDest, yDest, zDest), (Block)block, orientation | (this.isSticky ? 8 : 0), teCopy, orientation, 0, currentOpened - lenghtOpenned, false, true, 0);
        world.func_94571_i(xOri, yOri, zOri);
        if (this.isSticky) {
            this.retracSticky(world, x, y, z, orientation, currentOpened, lenghtOpenned);
        }
    }

    protected void retracSticky(World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpenned) {
        int x2 = x + Facing.field_71586_b[orientation] * lenghtOpenned;
        int y2 = y + Facing.field_71587_c[orientation] * lenghtOpenned;
        int z2 = z + Facing.field_71585_d[orientation] * lenghtOpenned;
        ArrayList<EMoveInfosExtend> infosRetract = this.listBlockRetract(world, x2, y2, z2, orientation, currentOpened - lenghtOpenned, this.getStickySize((IBlockAccess)world, x, y, z));
        for (EMoveInfosExtend infos : infosRetract) {
            if (infos.block == null || infos.position == null) continue;
            this.createMoving(world, new Integer3d(x, y, z), new Integer3d(infos.position.x - Facing.field_71586_b[orientation] * infos.move, infos.position.y - Facing.field_71587_c[orientation] * infos.move, infos.position.z - Facing.field_71585_d[orientation] * infos.move), infos.block, infos.metadata, infos.tileEntity, orientation, 0, infos.move, false, false, infos.waitFinish);
        }
        for (EMoveInfosExtend infos : infosRetract) {
            world.func_72851_f(infos.position.x, infos.position.y, infos.position.z, world.func_72798_a(infos.position.x, infos.position.y, infos.position.z));
            world.func_72845_h(infos.position.x, infos.position.y, infos.position.z);
        }
    }

    protected void extend(World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpened) {
        ArrayList<EMoveInfosExtend> infosExtend = this.listBlockExtend(world, x, y, z, orientation, currentOpened, lenghtOpened);
        this.moveBlockExtend(infosExtend, world, x, y, z, orientation, currentOpened, lenghtOpened);
        for (EMoveInfosExtend infos : infosExtend) {
            world.func_72851_f(infos.position.x, infos.position.y, infos.position.z, world.func_72798_a(infos.position.x, infos.position.y, infos.position.z));
            world.func_72845_h(infos.position.x, infos.position.y, infos.position.z);
        }
    }

    protected void moveBlockExtend(ArrayList<EMoveInfosExtend> infosExtend, World world, int x, int y, int z, int orientation, int currentOpened, int lenghtOpened) {
        int zExtension;
        int yExtension;
        int xExtension;
        for (EMoveInfosExtend infos : infosExtend) {
            if (infos.block == null || infos.block == Block.field_72099_aa) continue;
            xExtension = infos.position.x + Facing.field_71586_b[orientation] * infos.move;
            yExtension = infos.position.y + Facing.field_71587_c[orientation] * infos.move;
            zExtension = infos.position.z + Facing.field_71585_d[orientation] * infos.move;
            this.createMoving(world, new Integer3d(x, y, z), new Integer3d(xExtension, yExtension, zExtension), infos.block, infos.metadata, infos.tileEntity, orientation, currentOpened, infos.move, true, false, infos.waitFinish);
        }
        xExtension = x + Facing.field_71586_b[orientation] * (currentOpened - 1);
        yExtension = y + Facing.field_71587_c[orientation] * (currentOpened - 1);
        zExtension = z + Facing.field_71585_d[orientation] * (currentOpened - 1);
        for (int i = currentOpened; i < lenghtOpened; ++i) {
            int id = world.func_72798_a(xExtension += Facing.field_71586_b[orientation], yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation]);
            Block b = Block.field_71973_m[id];
            if (b != null && !(b instanceof BlockMorePistonsExtension)) continue;
            world.func_72832_d(xExtension, yExtension, zExtension, ModBlocks.blockPistonRod.field_71990_ca, orientation, 2);
            world.func_72837_a(xExtension, yExtension, zExtension, (TileEntity)new TileEntityMorePistonsRod(new Integer3d(x, y, z)));
        }
        ModMorePistons.log.debug(new Object[]{"Create PistonMoving : " + (xExtension += Facing.field_71586_b[orientation]), yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation], "orientation=" + orientation, "currentOpened=" + currentOpened, "lenghtOpened=" + lenghtOpened});
        this.createMoving(world, new Integer3d(x, y, z), new Integer3d(xExtension, yExtension, zExtension), (Block)this.getBlockExtention(), orientation | (this.isSticky ? 8 : 0), null, orientation, currentOpened, lenghtOpened, true, false, 0);
    }

    protected void createMoving(World world, Integer3d pistonPos, Integer3d dest, Block block, int metadata, TileEntity teCopy, int orientation, int start, int lenghtOpened, boolean extending, boolean root, int waitFinish) {
        world.func_72832_d(dest.x, dest.y, dest.z, ModBlocks.blockPistonMoving.field_71990_ca, metadata, 2);
        TileEntityMorePistonsMoving teExtension = new TileEntityMorePistonsMoving(block, orientation, extending, start, lenghtOpened, pistonPos, root, waitFinish);
        teExtension.subTe = teCopy;
        world.func_72837_a(dest.x, dest.y, dest.z, (TileEntity)teExtension);
        TileEntity te = world.func_72796_p(pistonPos.x, pistonPos.y, pistonPos.z);
        if (root || block instanceof BlockMorePistonsExtension) {
            if (te instanceof TileEntityMorePistonsPiston) {
                ((TileEntityMorePistonsPiston)te).extentionPos = new Integer3d(dest.x, dest.y, dest.z);
                world.func_72821_m(dest.x, dest.y, dest.z, this.field_71990_ca);
            }
            if (te instanceof TileEntityMorePistonsMoving) {
                ((TileEntityMorePistonsMoving)te).getPistonOriginTE().extentionPos = new Integer3d(dest.x, dest.y, dest.z);
                world.func_72821_m(dest.x, dest.y, dest.z, ModBlocks.blockPistonMoving.field_71990_ca);
            }
        }
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        return RotationHelper.rotateVanillaBlock((Block)Block.field_71963_Z, (World)worldObj, (int)x, (int)y, (int)z, (ForgeDirection)axis);
    }

    protected static class EMoveInfosExtend {
        public Block block = null;
        public int metadata = 0;
        public Integer3d position = new Integer3d();
        public TileEntity tileEntity = null;
        public int move = 0;
        public int waitFinish = 0;

        public EMoveInfosExtend() {
        }

        public EMoveInfosExtend(Block block, int metadata, TileEntity tileEntity, Integer3d position, int move) {
            this(block, metadata, tileEntity, position, move, 0);
        }

        public EMoveInfosExtend(Block block, int metadata, TileEntity tileEntity, Integer3d position, int move, int waitFinish) {
            this.block = block;
            this.metadata = metadata;
            this.position = position;
            this.tileEntity = BlockMorePistonsBase.cloneTileEntity(tileEntity);
            this.move = move;
            this.waitFinish = waitFinish;
        }
    }
}

