/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.morepistons.common.tileentities;

import com.gollum.core.utils.math.Integer3d;
import com.gollum.morepistons.ModMorePistons;
import com.gollum.morepistons.common.block.BlockMorePistonsBase;
import com.gollum.morepistons.common.block.BlockMorePistonsExtension;
import com.gollum.morepistons.common.block.BlockMorePistonsMoving;
import com.gollum.morepistons.common.block.BlockMorePistonsRod;
import com.gollum.morepistons.common.tileentities.TileEntityMorePistonsPiston;
import com.gollum.morepistons.inits.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;

public class TileEntityMorePistonsMoving
extends TileEntity {
    public Block storedBlock = null;
    public int storedOrientation = 0;
    public boolean extending = false;
    public int distance = 0;
    public Integer3d positionPiston = new Integer3d();
    public boolean root = false;
    public TileEntity subTe = null;
    public int waitFinish = 0;
    private float progress = 0.0f;
    private float lastProgress = 0.0f;
    private boolean isInit = false;

    public TileEntityMorePistonsMoving() {
    }

    public TileEntityMorePistonsMoving(Block block, int orientation, boolean extending, int start, int distance, Integer3d positionPiston, boolean root, int waitFinish) {
        if (block == null) {
            ModMorePistons.log.severe(new Object[]{"Block strorage in null in creation TileEntiry"});
        }
        this.storedBlock = block;
        this.storedOrientation = orientation;
        this.extending = extending;
        this.distance = distance;
        this.positionPiston = (Integer3d)positionPiston.clone();
        this.root = root;
        this.isInit = true;
        this.waitFinish = waitFinish;
        if (distance != 0) {
            this.lastProgress = this.progress = (float)((double)Math.abs(start) / (double)Math.abs(distance));
        }
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.isInit) {
            return;
        }
        BlockMorePistonsBase piston = this.pistonOrigin();
        if (piston == null) {
            ModMorePistons.log.debug(new Object[]{"The piston origin of moving block not found", this.positionPiston.x, this.positionPiston.y, this.positionPiston.z});
            this.setBlockFinalMove();
            return;
        }
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            if (this.waitFinish <= 0) {
                this.setBlockFinalMove();
            } else {
                --this.waitFinish;
            }
        } else {
            this.upgradeProgess();
        }
    }

    public BlockMorePistonsBase pistonOrigin() {
        TileEntity te;
        int id = this.worldObj.getBlockId(this.positionPiston.x, this.positionPiston.y, this.positionPiston.z);
        Block b = Block.blocksList[id];
        if (b instanceof BlockMorePistonsBase) {
            return (BlockMorePistonsBase)b;
        }
        if (b instanceof BlockMorePistonsMoving && (te = this.worldObj.getBlockTileEntity(this.positionPiston.x, this.positionPiston.y, this.positionPiston.z)) instanceof TileEntityMorePistonsMoving) {
            TileEntityMorePistonsMoving teM = (TileEntityMorePistonsMoving)te;
            if (teM.storedBlock instanceof BlockMorePistonsBase) {
                return (BlockMorePistonsBase)teM.storedBlock;
            }
        }
        return null;
    }

    public int pistonOriginMetadata() {
        TileEntity te;
        int id = this.worldObj.getBlockId(this.positionPiston.x, this.positionPiston.y, this.positionPiston.z);
        Block b = Block.blocksList[id];
        if (b instanceof BlockMorePistonsMoving && (te = this.worldObj.getBlockTileEntity(this.positionPiston.x, this.positionPiston.y, this.positionPiston.z)) instanceof TileEntityMorePistonsMoving) {
            TileEntityMorePistonsMoving teM = (TileEntityMorePistonsMoving)te;
            if (teM.storedBlock instanceof BlockMorePistonsBase) {
                return teM.getBlockMetadata();
            }
        }
        return this.worldObj.getBlockMetadata(this.positionPiston.x, this.positionPiston.y, this.positionPiston.z);
    }

    public TileEntityMorePistonsPiston getPistonOriginTE() {
        TileEntity te;
        int id = this.worldObj.getBlockId(this.positionPiston.x, this.positionPiston.y, this.positionPiston.z);
        Block b = Block.blocksList[id];
        if (b instanceof BlockMorePistonsMoving && (te = this.worldObj.getBlockTileEntity(this.positionPiston.x, this.positionPiston.y, this.positionPiston.z)) instanceof TileEntityMorePistonsMoving) {
            TileEntityMorePistonsMoving teM = (TileEntityMorePistonsMoving)te;
            if (teM.subTe != null && teM.subTe instanceof TileEntityMorePistonsPiston) {
                return (TileEntityMorePistonsPiston)teM.subTe;
            }
        }
        if ((te = this.worldObj.getBlockTileEntity(this.positionPiston.x, this.positionPiston.y, this.positionPiston.z)) instanceof TileEntityMorePistonsPiston) {
            return (TileEntityMorePistonsPiston)te;
        }
        ModMorePistons.log.severe(new Object[]{"TE Piston origin not found :", this.positionPiston.x, this.positionPiston.y, this.positionPiston.z});
        return null;
    }

    public void setBlockFinalMove() {
        this.updatePushedObjects(1.0f);
        BlockMorePistonsBase piston = this.pistonOrigin();
        int id = this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord);
        Block b = Block.blocksList[id];
        if (b instanceof BlockMorePistonsMoving && (this.root || this.storedBlock instanceof BlockMorePistonsExtension) && !this.extending) {
            this.removePistonRod(this.distance - 1);
        }
        TileEntityMorePistonsPiston te = this.getPistonOriginTE();
        this.worldObj.notifyBlockOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.blockType != null ? this.blockType.blockID : 0);
        this.invalidate();
        this.worldObj.removeBlockTileEntity(this.xCoord, this.yCoord, this.zCoord);
        if (te != null) {
            te.extentionPos = null;
        }
        if (b instanceof BlockMorePistonsMoving) {
            if (this.storedBlock instanceof BlockPistonExtension && piston == null) {
                this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
            } else if (this.storedBlock == null) {
                this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
            } else {
                if (this.root) {
                    if (this.positionPiston.equals((Object)new Integer3d(this.xCoord, this.yCoord, this.zCoord))) {
                        this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, this.storedBlock != null ? this.storedBlock.blockID : 0, this.storedOrientation, 3);
                        this.worldObj.setBlockTileEntity(this.xCoord, this.yCoord, this.zCoord, this.subTe);
                    } else {
                        this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, piston.getBlockExtention().blockID, this.storedOrientation | (piston.isSticky() ? 8 : 0), 3);
                        this.worldObj.setBlockTileEntity(this.xCoord, this.yCoord, this.zCoord, null);
                    }
                } else {
                    this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, this.storedBlock != null ? this.storedBlock.blockID : 0, this.getBlockMetadata(), 3);
                    this.worldObj.setBlockTileEntity(this.xCoord, this.yCoord, this.zCoord, this.subTe);
                }
                this.worldObj.notifyBlockOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.storedBlock != null ? this.storedBlock.blockID : 0);
            }
        }
    }

    private void upgradeProgess() {
        this.progress = (float)((double)this.progress + 0.5);
        if (this.progress >= 1.0f) {
            this.progress = 1.0f;
        }
        if (this.extending) {
            this.updatePushedObjects(this.progress);
        }
        if ((this.root || this.storedBlock instanceof BlockMorePistonsExtension) && !this.extending) {
            this.removePistonRod((int)Math.ceil((float)this.distance * this.progress) - 1);
        }
    }

    private List<Entity> getEntitiesInProgess(float progress) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        AxisAlignedBB axisalignedbb = ModBlocks.blockPistonMoving.getAxisAlignedBB(this.worldObj, this.positionPiston.x, this.positionPiston.y, this.positionPiston.z, this.storedBlock, -progress * (float)this.distance, this.storedOrientation);
        if (axisalignedbb != null) {
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)null, axisalignedbb);
            for (Entity entity : list) {
                entities.add(entity);
            }
        }
        return entities;
    }

    private void updatePushedObjects(float progress) {
        block9: {
            block8: {
                if (!this.extending) break block8;
                List<Entity> entities = this.getEntitiesInProgess(progress);
                for (Entity entity : entities) {
                    double x = entity.posX;
                    double y = entity.posY;
                    double z = entity.posZ;
                    switch (this.storedOrientation) {
                        case 0: 
                        case 1: {
                            y = (double)((float)this.yCoord + this.getOffsetY(progress) + (float)Facing.offsetsYForSide[this.storedOrientation]) + (double)Facing.offsetsYForSide[this.storedOrientation] * (entity.boundingBox.maxY - entity.boundingBox.minY);
                            break;
                        }
                        case 2: 
                        case 3: {
                            z = (double)((float)this.zCoord + this.getOffsetZ(progress) + (float)Facing.offsetsZForSide[this.storedOrientation]) + (double)Facing.offsetsZForSide[this.storedOrientation] * (entity.boundingBox.maxZ - entity.boundingBox.minZ);
                            break;
                        }
                        case 4: 
                        case 5: {
                            x = (double)((float)this.xCoord + this.getOffsetX(progress) + (float)Facing.offsetsXForSide[this.storedOrientation]) + (double)Facing.offsetsXForSide[this.storedOrientation] * (entity.boundingBox.maxX - entity.boundingBox.minX);
                        }
                    }
                    if (Math.abs(x - entity.posX + y - entity.posY + z - entity.posZ) > 4.0) {
                        entity.setPosition(x, y, z);
                        continue;
                    }
                    entity.moveEntity(x - entity.posX, y - entity.posY, z - entity.posZ);
                }
                break block9;
            }
            List<Entity> list = this.getEntitiesInProgess(0.0f);
            if (list.isEmpty()) break block9;
            for (Entity entity : list) {
                entity.moveEntity((double)(0.3f * (float)Facing.offsetsXForSide[this.storedOrientation]), (double)(0.3f * (float)Facing.offsetsYForSide[this.storedOrientation]), (double)(0.3f * (float)Facing.offsetsZForSide[this.storedOrientation]));
            }
        }
    }

    public void removePistonRod(int nb) {
        int x = this.xCoord + Facing.offsetsXForSide[this.storedOrientation] * (this.distance + 1);
        int y = this.yCoord + Facing.offsetsYForSide[this.storedOrientation] * (this.distance + 1);
        int z = this.zCoord + Facing.offsetsZForSide[this.storedOrientation] * (this.distance + 1);
        for (int i = 0; i <= nb; ++i) {
            int id = this.worldObj.getBlockId(x -= Facing.offsetsXForSide[this.storedOrientation], y -= Facing.offsetsYForSide[this.storedOrientation], z -= Facing.offsetsZForSide[this.storedOrientation]);
            Block block = Block.blocksList[id];
            if (!(block instanceof BlockMorePistonsRod) && !(block instanceof BlockMorePistonsExtension)) continue;
            this.worldObj.setBlockToAir(x, y, z);
            this.worldObj.setBlockMetadataWithNotify(x, y, z, 0, 2);
        }
    }

    public float getProgress(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
        return this.lastProgress + (this.progress - this.lastProgress) * f;
    }

    public float getProgressWithDistance(float f) {
        if (this.extending) {
            return this.getProgress(f) * (float)this.distance - (float)this.distance;
        }
        return (float)this.distance - this.getProgress(f) * (float)this.distance;
    }

    public float getOffsetX(float f) {
        return this.getProgressWithDistance(f) * (float)Facing.offsetsXForSide[this.storedOrientation];
    }

    public float getOffsetY(float f) {
        return this.getProgressWithDistance(f) * (float)Facing.offsetsYForSide[this.storedOrientation];
    }

    public float getOffsetZ(float f) {
        return this.getProgressWithDistance(f) * (float)Facing.offsetsZForSide[this.storedOrientation];
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.storedBlock = Block.blocksList[nbtTagCompound.getInteger("blockId")];
        this.storedOrientation = nbtTagCompound.getInteger("orientation");
        this.extending = nbtTagCompound.getBoolean("extending");
        this.distance = nbtTagCompound.getInteger("distance");
        this.progress = nbtTagCompound.getFloat("progress");
        this.lastProgress = nbtTagCompound.getFloat("lastProgress");
        this.root = nbtTagCompound.getBoolean("root");
        this.waitFinish = nbtTagCompound.getInteger("waitFinish");
        this.positionPiston.x = nbtTagCompound.getInteger("pistonX");
        this.positionPiston.y = nbtTagCompound.getInteger("pistonY");
        this.positionPiston.z = nbtTagCompound.getInteger("pistonZ");
        this.subTe = null;
        if (nbtTagCompound.hasKey("subTe")) {
            NBTTagCompound subNBT = nbtTagCompound.getCompoundTag("subTe");
            try {
                this.subTe = TileEntity.createAndLoadEntity((NBTTagCompound)subNBT);
                this.subTe.setWorldObj(this.worldObj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isInit = true;
        ModMorePistons.log.debug(new Object[]{"this.progress", Float.valueOf(this.progress)});
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        nbtTagCompound.setInteger("blockId", this.storedBlock != null ? this.storedBlock.blockID : 0);
        nbtTagCompound.setInteger("orientation", this.storedOrientation);
        nbtTagCompound.setBoolean("extending", this.extending);
        nbtTagCompound.setInteger("distance", this.distance);
        nbtTagCompound.setFloat("progress", this.progress);
        nbtTagCompound.setFloat("lastProgress", this.lastProgress);
        nbtTagCompound.setBoolean("root", this.root);
        nbtTagCompound.setInteger("waitFinish", this.waitFinish);
        nbtTagCompound.setInteger("pistonX", this.positionPiston.x);
        nbtTagCompound.setInteger("pistonY", this.positionPiston.y);
        nbtTagCompound.setInteger("pistonZ", this.positionPiston.z);
        if (this.subTe != null) {
            NBTTagCompound subNBT = new NBTTagCompound();
            this.subTe.writeToNBT(subNBT);
            nbtTagCompound.setTag("subTe", (NBTBase)subNBT);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Packet132TileEntityData(this.xCoord, this.yCoord, this.zCoord, 0, nbttagcompound);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.readFromNBT(pkt.data);
    }
}

