/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.morepistons.common.block.superpiston;

import com.gollum.morepistons.common.block.superpiston.AbstractSuperPistonHandler;
import com.gollum.morepistons.common.block.superpiston.VanillaSuperPistonHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class SuperPistonManager {
    public static SuperPistonManager instance = new SuperPistonManager();
    private ArrayList<AbstractSuperPistonHandler> handlers = new ArrayList();

    protected SuperPistonManager() {
        this.registerHandler(new VanillaSuperPistonHandler());
    }

    public void registerHandler(AbstractSuperPistonHandler handler) {
        this.handlers.add(handler);
    }

    public boolean dontMoveIfOnTop(Block block, int metadata, World world, int x, int y, int z, int orientation) {
        if (block == null) {
            return false;
        }
        for (AbstractSuperPistonHandler h : this.handlers) {
            if (!h.dontMoveIfOnTop(block, metadata, world, x, y, z, orientation)) continue;
            return true;
        }
        return false;
    }

    public boolean isntAttachOnTop(Block block, int metadata, World world, int x, int y, int z, int orientation) {
        if (block == null) {
            return false;
        }
        for (AbstractSuperPistonHandler h : this.handlers) {
            if (!h.isntAttachOnTop(block, metadata, world, x, y, z, orientation)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttachOnNext(Block block, int metadata, World world, int x, int y, int z, int orientation) {
        if (block == null) {
            return false;
        }
        for (AbstractSuperPistonHandler h : this.handlers) {
            if (!h.isAttachOnNext(block, metadata, world, x, y, z, orientation)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttachableBlockOnNext(Block block, int metadata, World world, int x, int y, int z, int orientation) {
        if (block == null) {
            return false;
        }
        for (AbstractSuperPistonHandler h : this.handlers) {
            if (!h.isAttachableBlockOnNext(block, metadata, world, x, y, z, orientation)) continue;
            return true;
        }
        return false;
    }
}

