/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.morepistons.common.block;

import com.gollum.core.tools.helper.blocks.HBlockPistonBase;
import com.gollum.core.tools.registered.RegisteredObjects;
import com.gollum.core.tools.registry.BlockRegistry;
import com.gollum.core.tools.registry.ItemRegistry;
import com.gollum.morepistons.ModMorePistons;
import com.gollum.morepistons.common.block.BlockMorePistonsVanilla;
import com.gollum.morepistons.common.item.ItemMorePistonsVanillaProxy;
import com.gollum.morepistons.common.tileentities.TileEntityMorePistonsPiston;
import com.gollum.morepistons.inits.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class BlockMorePistonsVanillaProxy
extends HBlockPistonBase {
    public BlockMorePistonsVanilla target;
    public BlockPistonBase vanillaPiston;

    public BlockMorePistonsVanillaProxy(int id, BlockMorePistonsVanilla target) throws Exception {
        super(id, target.isSticky() ? RegisteredObjects.instance().getRegisterName((Block)Block.pistonStickyBase) : RegisteredObjects.instance().getRegisterName((Block)Block.pistonBase), target.isSticky());
        this.target = target;
        this.vanillaPiston = target.isSticky() ? Block.pistonStickyBase : Block.pistonBase;
        this.setUnlocalizedName(this.vanillaPiston.getUnlocalizedName().replace("tile.", ""));
        this.helper.vanillaTexture = true;
    }

    protected void registerBlockIconsTop(IconRegister iconRegister) {
        this.iconTop = iconRegister.registerIcon(this.isStickyPiston ? "piston_top_sticky" : "piston_top_normal");
    }

    protected void registerBlockIconsOpen(IconRegister iconRegister) {
        this.iconOpen = iconRegister.registerIcon("piston_inner");
    }

    protected void registerBlockIconsBottom(IconRegister iconRegister) {
        this.iconBottom = iconRegister.registerIcon("piston_bottom");
    }

    protected void registerBlockIconsSide(IconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("piston_side");
    }

    public void register() {
        if (this.helper.vanillaRegister) {
            return;
        }
        int newId = this.vanillaPiston.blockID;
        int oldId = this.blockID;
        ItemMorePistonsVanillaProxy item = new ItemMorePistonsVanillaProxy(this.blockID - 256, Item.itemsList[oldId]);
        Item vanillaItem = Item.itemsList[newId];
        BlockRegistry.instance().overrideBlocksId((Block)this.vanillaPiston, (Block)this);
        ItemRegistry.instance().overrideItemId(vanillaItem, (Item)item);
        BlockRegistry.instance().overrideBlocksClassField((Block)this.vanillaPiston, (Block)this);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float posX, float posY, float posZ) {
        ModMorePistons.log.debug(new Object[]{"VanillaProxy replace onBlockActivated : ", x, y, z});
        world.addBlockEvent(x, y, z, this.blockID, 0, world.getBlockMetadata(x, y, z));
        return false;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        ModMorePistons.log.debug(new Object[]{"VanillaProxy replace onBlockPlacedBy : ", x, y, z});
        world.setBlock(x, y, z, this.target.blockID);
        this.target.onBlockPlacedBy(world, x, y, z, entityLiving, itemStack);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!world.isRemote) {
            ModMorePistons.log.debug(new Object[]{"VanillaProxy replace onNeighborBlockChange : ", x, y, z});
            world.addBlockEvent(x, y, z, this.blockID, 0, world.getBlockMetadata(x, y, z));
        }
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        if (!world.isRemote) {
            ModMorePistons.log.debug(new Object[]{"VanillaProxy replace onBlockAdded : ", x, y, z});
            world.addBlockEvent(x, y, z, this.blockID, 0, world.getBlockMetadata(x, y, z));
        }
    }

    public boolean onBlockEventReceived(World world, int x, int y, int z, int EventId, int metadata) {
        try {
            int orientation = BlockPistonBase.getOrientation((int)metadata);
            boolean open = BlockPistonBase.isExtended((int)metadata);
            ModMorePistons.log.debug(new Object[]{"onBlockEventReceived : ", x, y, z, "metadata=" + metadata, "open=" + open});
            world.setBlock(x, y, z, this.target.blockID, metadata, 2);
            TileEntityMorePistonsPiston te = new TileEntityMorePistonsPiston();
            if (open) {
                te.currentOpened = 1;
            }
            world.setBlockTileEntity(x, y, z, (TileEntity)te);
            if (open) {
                int x2 = x + Facing.offsetsXForSide[orientation];
                int y2 = y + Facing.offsetsYForSide[orientation];
                int z2 = z + Facing.offsetsZForSide[orientation];
                world.setBlock(x2, y2, z2, ModBlocks.blockPistonExtention.blockID, orientation | (this.target.isSticky ? 8 : 0), 2);
            }
            this.target.updatePistonState(world, x, y, z);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean equals(Object o) {
        return super.equals(o) || o == this.vanillaPiston;
    }
}

