/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.morepistons.common.block;

import com.gollum.core.tools.helper.blocks.HBlockContainer;
import com.gollum.morepistons.common.tileentities.TileEntityMorePistonsPiston;
import com.gollum.morepistons.common.tileentities.TileEntityMorePistonsRod;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMorePistonsRod
extends HBlockContainer {
    private Icon iconV;
    private Icon iconH;
    public boolean northSouth = false;
    public boolean upDown = false;

    public BlockMorePistonsRod(int id, String registerName) {
        super(id, registerName, Material.grass);
        this.setStepSound(soundStoneFootstep);
        this.setHardness(0.3f);
    }

    public TileEntity createNewTileEntity(World world) {
        return new TileEntityMorePistonsRod();
    }

    public void registerIcons(IconRegister iconRegister) {
        this.iconV = this.helper.loadTexture(iconRegister, "_v");
        this.iconH = this.helper.loadTexture(iconRegister, "_h");
    }

    public Icon getIcon(int side, int metadata) {
        int orientation = BlockPistonBase.getOrientation((int)metadata);
        if (this.upDown) {
            return this.iconV;
        }
        if (this.northSouth && (side == 1 || side == 0)) {
            return this.iconV;
        }
        return this.iconH;
    }

    public int getRenderType() {
        return -1;
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        TileEntity te = world.getBlockTileEntity(x, y, z);
        if (te instanceof TileEntityMorePistonsRod && !((TileEntityMorePistonsRod)te).isDisplay()) {
            return;
        }
        this.setBlockBoundsBasedOnState(world.getBlockMetadata(x, y, z));
        super.addCollisionBoxesToList(world, x, y, z, aabb, list, entity);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getBlockTileEntity(x, y, z);
        if (te instanceof TileEntityMorePistonsRod && !((TileEntityMorePistonsRod)te).isDisplay()) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        this.setBlockBoundsBasedOnState(world.getBlockMetadata(x, y, z));
    }

    public void setBlockBoundsBasedOnState(int metadata) {
        switch (BlockPistonBase.getOrientation((int)metadata)) {
            case 0: {
                this.upDown = true;
                this.northSouth = false;
                this.setBlockBounds(0.375f, 0.25f, 0.375f, 0.625f, 1.25f, 0.625f);
                break;
            }
            case 1: {
                this.upDown = true;
                this.northSouth = false;
                this.setBlockBounds(0.375f, -0.25f, 0.375f, 0.625f, 0.75f, 0.625f);
                break;
            }
            case 2: {
                this.upDown = false;
                this.northSouth = true;
                this.setBlockBounds(0.375f, 0.375f, 0.25f, 0.625f, 0.625f, 1.25f);
                break;
            }
            case 3: {
                this.upDown = false;
                this.northSouth = true;
                this.setBlockBounds(0.375f, 0.375f, -0.25f, 0.625f, 0.625f, 0.75f);
                break;
            }
            case 4: {
                this.upDown = false;
                this.northSouth = false;
                this.setBlockBounds(0.25f, 0.375f, 0.375f, 1.25f, 0.625f, 0.625f);
                break;
            }
            case 5: {
                this.upDown = false;
                this.northSouth = false;
                this.setBlockBounds(-0.25f, 0.375f, 0.375f, 0.75f, 0.625f, 0.625f);
            }
        }
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return false;
    }

    public boolean canPlaceBlockOnSide(World world, int i, int j, int k, int l) {
        return false;
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntityMorePistonsPiston tep;
        TileEntity te = world.getBlockTileEntity(x, y, z);
        if (te instanceof TileEntityMorePistonsRod && (tep = ((TileEntityMorePistonsRod)te).getBlockTileEntityPiston()) != null) {
            world.destroyBlock(tep.xCoord, tep.yCoord, tep.zCoord, true);
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        TileEntityMorePistonsPiston tep;
        TileEntity te = world.getBlockTileEntity(x, y, z);
        if (te instanceof TileEntityMorePistonsRod && (tep = ((TileEntityMorePistonsRod)te).getBlockTileEntityPiston()) != null) {
            return;
        }
        world.setBlockToAir(x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return null;
    }

    public int idDropped(int par1, Random par2Random, int par3) {
        return 0;
    }
}

