/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniturecompatibility.common.handlers;

import com.gollum.core.tools.registered.RegisteredObjects;
import com.gollum.jammyfurniturecompatibility.ModJammyFurnitureZuxelusCompatibility;
import com.gollum.jammyfurniturecompatibility.common.block.BlockReplace;
import com.gollum.jammyfurniturecompatibility.common.item.ItemBlockReplace;
import com.gollum.jammyfurniturecompatibility.common.item.ItemReplace;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.world.ChunkDataEvent;

public class ChunkLoadHandler {
    public static final String KEY_CHECK_SAVE_CHUNK = "JammyZuxelusCompatibility";
    public HashMap<Integer, HashMap<Integer, HashMap<Integer, Boolean>>> parsed = new HashMap();

    @SubscribeEvent
    public void onLoad(ChunkDataEvent.Load event) {
        Chunk c = event.getChunk();
        NBTTagCompound d = event.getData();
        try {
            if (!(d.hasKey(KEY_CHECK_SAVE_CHUNK) && d.getBoolean(KEY_CHECK_SAVE_CHUNK) || this.isParsed(c))) {
                ModJammyFurnitureZuxelusCompatibility.log.debug(new Object[]{"Migrate chunk start :", c.xPosition, c.zPosition});
                this.markParsed(c);
                this.migrate(c);
                ModJammyFurnitureZuxelusCompatibility.log.debug(new Object[]{"Migrate chunk end :", c.xPosition, c.zPosition});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isParsed(Chunk c) {
        int wId = System.identityHashCode(c.worldObj);
        return this.parsed.containsKey(wId) && this.parsed.get(wId).containsKey(c.xPosition) && this.parsed.get(wId).get(c.xPosition).containsKey(c.zPosition) && this.parsed.get(wId).get(c.xPosition).get(c.zPosition) != false;
    }

    private void markParsed(Chunk c) {
        int wId = System.identityHashCode(c.worldObj);
        if (!this.parsed.containsKey(wId)) {
            this.parsed.put(wId, new HashMap());
        }
        if (!this.parsed.get(wId).containsKey(c.xPosition)) {
            this.parsed.get(wId).put(c.xPosition, new HashMap());
        }
        this.parsed.get(wId).get(c.xPosition).put(c.zPosition, true);
    }

    private void migrate(Chunk chunk) {
        ExtendedBlockStorage[] storages = chunk.getBlockStorageArray();
        int y = 0;
        while (y >> 4 < storages.length) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block b = chunk.getBlock(x, y, z);
                    int m = chunk.getBlockMetadata(x, y, z);
                    TileEntity te = chunk.getTileEntityUnsafe(x, y, z);
                    if (b instanceof BlockReplace) {
                        this.replaceBlock(chunk, x, y, z, (BlockReplace)b, m);
                    }
                    if (!(te instanceof IInventory)) continue;
                    IInventory inv = (IInventory)te;
                    for (int i = 0; i < inv.getSizeInventory(); ++i) {
                        ItemStack nIs;
                        ItemStack is = inv.getStackInSlot(i);
                        if (is != null && is.getItem() instanceof ItemReplace) {
                            nIs = ((ItemReplace)is.getItem()).replaceItemStack(is);
                            inv.setInventorySlotContents(i, nIs);
                            ModJammyFurnitureZuxelusCompatibility.log.message(new Object[]{"Handler item in inventory transform x=" + x * chunk.xPosition * 16 + ", y=" + y + ", z=" + z * chunk.zPosition * 16 + " ,\"" + RegisteredObjects.instance().getRegisterName(is.getItem()) + "\":" + is.getItemDamage() + " => \"" + RegisteredObjects.instance().getRegisterName(nIs.getItem()) + "\":" + nIs.getItemDamage() + ""});
                        }
                        if (is == null || !(is.getItem() instanceof ItemBlockReplace)) continue;
                        nIs = ((ItemBlockReplace)is.getItem()).replaceItemStack(is);
                        inv.setInventorySlotContents(i, nIs);
                        ModJammyFurnitureZuxelusCompatibility.log.message(new Object[]{"Handler item in inventory transform x=" + x * chunk.xPosition * 16 + ", y=" + y + ", z=" + z * chunk.zPosition * 16 + " ,\"" + RegisteredObjects.instance().getRegisterName(is.getItem()) + "\":" + is.getItemDamage() + " => \"" + RegisteredObjects.instance().getRegisterName(nIs.getItem()) + "\":" + nIs.getItemDamage() + ""});
                    }
                }
            }
            ++y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceBlock(Chunk chunk, int x, int y, int z, BlockReplace block, int metadata) {
        BlockReplace.ReplaceBlock target = BlockReplace.ReplaceBlock.get((Block)block, metadata);
        TileEntity te = chunk.func_150806_e(x, y, z);
        ItemStack[] itemStacks = new ItemStack[]{};
        try {
            int i;
            IInventory inventory;
            block.replaceMutex = false;
            if (te instanceof IInventory) {
                inventory = (IInventory)te;
                itemStacks = new ItemStack[inventory.getSizeInventory()];
                for (i = 0; i < inventory.getSizeInventory(); ++i) {
                    itemStacks[i] = inventory.getStackInSlot(i);
                    inventory.setInventorySlotContents(i, null);
                }
            }
            chunk.func_150812_a(x, y, z, te);
            chunk.removeTileEntity(x, y, z);
            chunk.func_150807_a(x, y, z, target.getBlock(), target.getMetadata(metadata));
            ModJammyFurnitureZuxelusCompatibility.log.message(new Object[]{"Handler block transform x=" + (x + chunk.xPosition * 16) + ", y=" + y + ", z=" + (z + chunk.zPosition * 16) + " ,\"" + RegisteredObjects.instance().getRegisterName((Block)block) + "\":" + metadata + "(" + Block.getIdFromBlock((Block)block) + ") => \"" + target.registerName + "\":" + target.getMetadata(metadata) + "(" + Block.getIdFromBlock((Block)target.getBlock()) + ")"});
            te = chunk.func_150806_e(x, y, z);
            if (te instanceof IInventory) {
                inventory = (IInventory)te;
                for (i = 0; i < inventory.getSizeInventory() && i < itemStacks.length; ++i) {
                    inventory.setInventorySlotContents(i, itemStacks[i]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            block.replaceMutex = true;
        }
    }

    @SubscribeEvent
    public void onSave(ChunkDataEvent.Save event) {
        NBTTagCompound d = event.getData();
        d.setBoolean(KEY_CHECK_SAVE_CHUNK, true);
    }
}

