/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniturecompatibility.common.handlers;

import com.gollum.core.tools.registered.RegisteredObjects;
import com.gollum.jammyfurniturecompatibility.ModJammyFurnitureZuxelusCompatibility;
import com.gollum.jammyfurniturecompatibility.common.block.BlockReplace;
import com.gollum.jammyfurniturecompatibility.common.item.ItemBlockReplace;
import com.gollum.jammyfurniturecompatibility.common.item.ItemReplace;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.world.ChunkDataEvent;

public class ChunkLoadHandler {
    public static final String KEY_CHECK_SAVE_CHUNK = "JammyZuxelusCompatibility";
    public HashMap<Integer, HashMap<Integer, HashMap<Integer, Boolean>>> parsed = new HashMap();

    @SubscribeEvent
    public void onLoad(ChunkDataEvent.Load event) {
        Chunk c = event.getChunk();
        NBTTagCompound d = event.getData();
        try {
            if (!(d.func_74764_b(KEY_CHECK_SAVE_CHUNK) && d.func_74767_n(KEY_CHECK_SAVE_CHUNK) || this.isParsed(c))) {
                ModJammyFurnitureZuxelusCompatibility.log.debug(new Object[]{"Migrate chunk start :", c.field_76635_g, c.field_76647_h});
                this.markParsed(c);
                this.migrate(c);
                ModJammyFurnitureZuxelusCompatibility.log.debug(new Object[]{"Migrate chunk end :", c.field_76635_g, c.field_76647_h});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isParsed(Chunk c) {
        int wId = System.identityHashCode(c.field_76637_e);
        return this.parsed.containsKey(wId) && this.parsed.get(wId).containsKey(c.field_76635_g) && this.parsed.get(wId).get(c.field_76635_g).containsKey(c.field_76647_h) && this.parsed.get(wId).get(c.field_76635_g).get(c.field_76647_h) != false;
    }

    private void markParsed(Chunk c) {
        int wId = System.identityHashCode(c.field_76637_e);
        if (!this.parsed.containsKey(wId)) {
            this.parsed.put(wId, new HashMap());
        }
        if (!this.parsed.get(wId).containsKey(c.field_76635_g)) {
            this.parsed.get(wId).put(c.field_76635_g, new HashMap());
        }
        this.parsed.get(wId).get(c.field_76635_g).put(c.field_76647_h, true);
    }

    private void migrate(Chunk chunk) {
        ExtendedBlockStorage[] storages = chunk.func_76587_i();
        int y = 0;
        while (y >> 4 < storages.length) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block b = chunk.func_150810_a(x, y, z);
                    int m = chunk.func_76628_c(x, y, z);
                    TileEntity te = chunk.getTileEntityUnsafe(x, y, z);
                    if (b instanceof BlockReplace) {
                        BlockReplace.ReplaceBlock replace = BlockReplace.ReplaceBlock.get(b, m);
                        ModJammyFurnitureZuxelusCompatibility.log.message(new Object[]{"Block transform x=" + x * chunk.field_76635_g * 16 + ", y=" + y + ", z=" + z * chunk.field_76647_h * 16 + " ,\"" + RegisteredObjects.instance().getRegisterName(b) + "\":" + m + "(" + Block.func_149682_b((Block)b) + ") => \"" + replace.registerName + "\":" + replace.getMetadata(m) + "(" + Block.func_149682_b((Block)replace.getBlock()) + ")"});
                        chunk.func_150807_a(x, y, z, replace.getBlock(), replace.getMetadata(m));
                    }
                    if (!(te instanceof IInventory)) continue;
                    IInventory inv = (IInventory)te;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack nIs;
                        ItemStack is = inv.func_70301_a(i);
                        if (is != null && is.func_77973_b() instanceof ItemReplace) {
                            nIs = ((ItemReplace)is.func_77973_b()).replaceItemStack(is);
                            inv.func_70299_a(i, nIs);
                            ModJammyFurnitureZuxelusCompatibility.log.message(new Object[]{"Item in inventory transform x=" + x * chunk.field_76635_g * 16 + ", y=" + y + ", z=" + z * chunk.field_76647_h * 16 + " ,\"" + RegisteredObjects.instance().getRegisterName(is.func_77973_b()) + "\":" + is.func_77960_j() + " => \"" + RegisteredObjects.instance().getRegisterName(nIs.func_77973_b()) + "\":" + nIs.func_77960_j() + ""});
                        }
                        if (is == null || !(is.func_77973_b() instanceof ItemBlockReplace)) continue;
                        nIs = ((ItemBlockReplace)is.func_77973_b()).replaceItemStack(is);
                        inv.func_70299_a(i, nIs);
                        ModJammyFurnitureZuxelusCompatibility.log.message(new Object[]{"Item in inventory transform x=" + x * chunk.field_76635_g * 16 + ", y=" + y + ", z=" + z * chunk.field_76647_h * 16 + " ,\"" + RegisteredObjects.instance().getRegisterName(is.func_77973_b()) + "\":" + is.func_77960_j() + " => \"" + RegisteredObjects.instance().getRegisterName(nIs.func_77973_b()) + "\":" + nIs.func_77960_j() + ""});
                    }
                }
            }
            ++y;
        }
    }

    @SubscribeEvent
    public void onSave(ChunkDataEvent.Save event) {
        NBTTagCompound d = event.getData();
        d.func_74757_a(KEY_CHECK_SAVE_CHUNK, true);
    }
}

