/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.tilesentities.ceramic;

import com.gollum.core.common.tileentities.GCLInventoryTileEntity;
import com.gollum.jammyfurniture.ModJammyFurniture;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileEntityCeramicBlocksOne
extends GCLInventoryTileEntity {
    private boolean waterOn = false;
    private long waterSoundTime = 0L;

    public TileEntityCeramicBlocksOne() {
        super(8);
    }

    public String getInventoryName() {
        return ModJammyFurniture.i18n.trans("Cupboard", new Object[0]);
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.worldObj.isRemote) {
            if (this.waterIsOn()) {
                if (System.currentTimeMillis() - this.waterSoundTime > 2950L) {
                    ModJammyFurniture.log.debug(new Object[]{"Play sound water"});
                    this.worldObj.playSoundEffect((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, "JammyFurniture".toLowerCase() + ":sink_water", 0.15f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                    this.waterSoundTime = System.currentTimeMillis();
                }
            } else {
                this.waterSoundTime = 0L;
            }
        }
    }

    public void toggleWater() {
        this.waterOn = !this.waterOn;
    }

    public boolean waterIsOn() {
        return this.waterOn;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.waterOn = nbtTagCompound.getBoolean("waterOn");
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        nbtTagCompound.setBoolean("waterOn", this.waterOn);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.func_148857_g());
    }
}

