/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.entities;

import com.gollum.jammyfurniture.common.block.IBlockUnmountEvent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityMountableBlock
extends Entity {
    public int orgBlockPosX;
    public int orgBlockPosY;
    public int orgBlockPosZ;
    public Block orgBlock;
    public EntityPlayer player;

    public EntityMountableBlock(World world) {
        super(world);
        this.noClip = true;
        this.preventEntitySpawning = true;
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public EntityMountableBlock(World world, double x, double y, double z) {
        super(world);
        this.noClip = true;
        this.preventEntitySpawning = true;
        this.width = 0.0f;
        this.height = 0.0f;
        this.setPosition(x, y, z);
    }

    public EntityMountableBlock(World world, EntityPlayer player, int x, int y, int z, double mountingX, double mountingY, double mountingZ) {
        super(world);
        this.player = player;
        this.noClip = true;
        this.preventEntitySpawning = true;
        this.width = 0.0f;
        this.height = 0.0f;
        this.orgBlockPosX = x;
        this.orgBlockPosY = y;
        this.orgBlockPosZ = z;
        this.orgBlock = world.getBlock(x, y, z);
        this.setPosition(mountingX, mountingY, mountingZ);
    }

    public boolean interact(EntityPlayer entityplayer) {
        if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer && this.riddenByEntity != entityplayer) {
            return true;
        }
        if (!this.worldObj.isRemote) {
            entityplayer.mountEntity((Entity)this);
        }
        return true;
    }

    public void onEntityUpdate() {
        this.worldObj.theProfiler.startSection("entityBaseTick");
        if (this.riddenByEntity != null && !this.riddenByEntity.isDead) {
            if (this.worldObj.getBlock(this.orgBlockPosX, this.orgBlockPosY, this.orgBlockPosZ) != this.orgBlock) {
                this.interact((EntityPlayer)this.riddenByEntity);
            }
        } else {
            this.setDead();
            Block block = this.worldObj.getBlock(this.orgBlockPosX, this.orgBlockPosY, this.orgBlockPosZ);
            if (block != null && block instanceof IBlockUnmountEvent) {
                ((IBlockUnmountEvent)block).onBlockPlacedBy(this.worldObj, this.orgBlockPosX, this.orgBlockPosY, this.orgBlockPosZ, this, this.player);
            }
        }
        ++this.ticksExisted;
        this.worldObj.theProfiler.endSection();
    }

    public void entityInit() {
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
    }
}

