/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.block.misc;

import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.block.JFMetadataBlock;
import com.gollum.jammyfurniture.common.tilesentities.misc.TileEntityMiscBlockOne;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MiscBlocksOne
extends JFMetadataBlock {
    IIcon blockIconChimney;
    IIcon blockIconMantle;
    IIcon blockIconChristmasTree;

    public MiscBlocksOne(String registerName) {
        super(registerName, Material.rock, "mantle", TileEntityMiscBlockOne.class, new int[]{0, 4, 8});
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack item) {
        int metadata = world.getBlockMetadata(x, y, z);
        int orientation = this.getOrientation((Entity)entityliving);
        if (metadata == 1 || metadata == 4 || metadata == 8) {
            world.setBlockMetadataWithNotify(x, y, z, metadata + orientation, 2);
        }
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int metadata = world.getBlockMetadata(i, j, k);
        int subBlock = this.getEnabledMetadata(metadata);
        if (subBlock == 0) {
            float f = (float)i + 0.5f;
            float f1 = (float)j + 1.0f + random.nextFloat() * 6.0f / 10.0f;
            float f2 = (float)k + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            world.spawnParticle("smoke", (double)f, (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.spawnParticle("smoke", (double)f, (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.spawnParticle("smoke", (double)f, (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.spawnParticle("smoke", (double)f, (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
        }
    }

    public int getRenderType() {
        return ModJammyFurniture.miscBlocksOneRenderID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIconChimney = this.helper.loadTexture(iconRegister, "chimney", true);
        this.blockIconMantle = this.helper.loadTexture(iconRegister, "mantle", true);
        this.blockIconChristmasTree = this.helper.loadTexture(iconRegister, "christmastree", true);
    }

    public IIcon getIcon(int side, int metadata) {
        int subBlock = this.getEnabledMetadata(metadata);
        switch (subBlock) {
            default: {
                return this.blockIconChimney;
            }
            case 4: {
                return this.blockIconMantle;
            }
            case 8: 
        }
        return this.blockIconChristmasTree;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int rotate = axis == ForgeDirection.DOWN ? 3 : 1;
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        if (subBlock == 4 || subBlock == 8) {
            world.setBlockMetadataWithNotify(x, y, z, (metadata - subBlock + rotate) % 4 + subBlock, 2);
            return true;
        }
        return false;
    }
}

