/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.block.ceramic;

import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.block.BlockMountable;
import com.gollum.jammyfurniture.common.block.IBlockUnmountEvent;
import com.gollum.jammyfurniture.common.block.JFMetadataBlock;
import com.gollum.jammyfurniture.common.crafting.CeramicBlocksOneRecipes;
import com.gollum.jammyfurniture.common.tilesentities.ceramic.TileEntityCeramicBlocksOne;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CeramicBlocksOne
extends JFMetadataBlock
implements IBlockUnmountEvent {
    public CeramicBlocksOne(String registerName) {
        super(registerName, Material.glass, "ceramic", TileEntityCeramicBlocksOne.class, new int[]{0, 4, 8, 12});
    }

    @Override
    protected void getCollisionBoundingBox(int metadata, boolean isSelectBox) {
        switch (metadata) {
            case 0: {
                this.setBlockBounds(0.1f, 0.0f, 0.6f, 0.9f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0f, 0.0f, 0.1f, 0.4f, 1.0f, 0.9f);
                break;
            }
            case 2: {
                this.setBlockBounds(0.1f, 0.0f, 0.0f, 0.9f, 1.0f, 0.4f);
                break;
            }
            case 3: {
                this.setBlockBounds(0.6f, 0.0f, 0.1f, 1.0f, 1.0f, 0.9f);
                break;
            }
            case 4: {
                this.setBlockBounds(0.1f, 0.0f, 0.2f, 0.9f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.0f, 0.0f, 0.1f, 0.8f, 1.0f, 0.9f);
                break;
            }
            case 6: {
                this.setBlockBounds(0.1f, 0.0f, 0.0f, 0.9f, 1.0f, 0.8f);
                break;
            }
            case 7: {
                this.setBlockBounds(0.2f, 0.0f, 0.1f, 1.0f, 1.0f, 0.9f);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.setBlockBounds(0.0f, 0.4f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 12: {
                this.setBlockBounds(0.15f, 0.0f, 0.05f, 0.85f, 1.0f, 1.0f);
                break;
            }
            case 13: {
                this.setBlockBounds(0.05f, 0.0f, 0.15f, 1.0f, 1.0f, 0.85f);
                break;
            }
            case 14: {
                this.setBlockBounds(0.15f, 0.0f, 0.0f, 0.85f, 1.0f, 0.95f);
                break;
            }
            case 15: {
                this.setBlockBounds(0.0f, 0.0f, 0.15f, 0.95f, 1.0f, 0.85f);
                break;
            }
            default: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        int orientation = this.getOrientation((Entity)entityliving);
        if (subBlock == 0 || subBlock == 4 || subBlock == 8 || subBlock == 12) {
            world.setBlockMetadataWithNotify(x, y, z, metadata + orientation, 2);
        }
    }

    public void breakBlock(World world, int x, int y, int z, Block oldBlock, int oldMetadata) {
        this.helper.breakBlockInventory(world, x, y, z, oldBlock);
        super.breakBlock(world, x, y, z, oldBlock, oldMetadata);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        int orientation = this.getOrientation((Entity)player);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileEntityCeramicBlocksOne) {
            TileEntityCeramicBlocksOne teCeramic = (TileEntityCeramicBlocksOne)te;
            switch (subBlock) {
                case 0: {
                    player.openGui((Object)ModJammyFurniture.instance, 0, world, x, y, z);
                    return true;
                }
                case 4: 
                case 8: {
                    if (world.isRemote) {
                        return true;
                    }
                    if (teCeramic.waterIsOn()) {
                        ItemStack itemStack = player.inventory.getCurrentItem();
                        ItemStack newItemStack = CeramicBlocksOneRecipes.smelting().getSmeltingResult(itemStack);
                        if (newItemStack != null) {
                            --itemStack.stackSize;
                            if (itemStack.stackSize <= 0) {
                                player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
                            }
                            if (player.inventory.addItemStackToInventory(newItemStack.copy())) {
                                if (player instanceof EntityPlayerMP) {
                                    ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                                }
                            } else {
                                ModJammyFurniture.log.debug(new Object[]{"Spawn new entity"});
                                world.spawnEntityInWorld((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 1.5, (double)z + 0.5, newItemStack));
                            }
                            return true;
                        }
                    }
                    world.addBlockEvent(x, y, z, (Block)this, 2, 0);
                    return true;
                }
                case 12: {
                    if (world.isRemote) {
                        return true;
                    }
                    if (orientation == 0) {
                        player.rotationYaw = 180.0f;
                    }
                    if (orientation == 1) {
                        player.rotationYaw = -90.0f;
                    }
                    if (orientation == 2) {
                        player.rotationYaw = 0.0f;
                    }
                    if (orientation == 3) {
                        player.rotationYaw = 90.0f;
                    }
                    return BlockMountable.onBlockActivated(world, x, y, z, player, 0.5f, 0.4f, 0.5f, 0, 0, 0, 0);
                }
            }
        }
        return false;
    }

    public boolean onBlockEventReceived(World world, int x, int y, int z, int eventID, int parameter) {
        if (eventID == 2) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (te != null && te instanceof TileEntityCeramicBlocksOne) {
                TileEntityCeramicBlocksOne teCeramicBlocks = (TileEntityCeramicBlocksOne)te;
                teCeramicBlocks.toggleWater();
            }
            return true;
        }
        return super.onBlockEventReceived(world, x, y, z, eventID, parameter);
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, Entity entity, EntityPlayer player) {
        world.playSoundAtEntity((Entity)player, "JammyFurniture".toLowerCase() + ":toilet", 1.0f, 1.0f);
    }

    public int getRenderType() {
        return ModJammyFurniture.ceramicBlocksOneRenderID;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int rotate = axis == ForgeDirection.DOWN ? 3 : 1;
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        if (subBlock == 0 || subBlock == 4 || subBlock == 8 || subBlock == 12) {
            world.setBlockMetadataWithNotify(x, y, z, (metadata - subBlock + rotate) % 4 + subBlock, 2);
            return true;
        }
        return false;
    }
}

