/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.client.render;

import com.gollum.jammyfurniture.client.model.JFIModel;
import com.gollum.jammyfurniture.client.model.JFIModelDoor;
import com.gollum.jammyfurniture.client.render.JFInventoryRenderer;
import java.util.HashMap;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class JFTileEntitySpecialRenderer
extends TileEntitySpecialRenderer {
    private HashMap<String, ResourceLocation> textures = new HashMap();
    protected boolean isInventory;
    protected boolean light = false;
    protected boolean lightInventory = true;
    protected double scale = 1.0;
    protected double scaleInventory = 1.0;
    protected float alpha = 1.0f;

    public void renderTileEntityAt(TileEntity tileEntity, double x, double y, double z, float f) {
        try {
            this.isInventory = tileEntity.getWorldObj() == null;
            int metadata = this.isInventory ? JFInventoryRenderer.getCurrentMetadata() : tileEntity.getBlockMetadata();
            this.renderTileEntityAt(tileEntity, x, y, z, f, metadata);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ResourceLocation getTexture(String name) {
        if (this.textures.containsKey(name)) {
            return this.textures.get(name);
        }
        ResourceLocation texture = new ResourceLocation("JammyFurniture".toLowerCase() + ":textures/models/" + name + ".png");
        this.textures.put(name, texture);
        return texture;
    }

    protected void renderModel(JFIModel model, String textureName, double x, double y, double z, float rotation) {
        this.beforeRender(textureName, x, y, z, rotation);
        model.renderModel(0.0625f);
        this.endRender();
    }

    protected void beforeRender(String textureName, double x, double y, double z, float rotation) {
        this.bindTexture(this.getTexture(textureName));
        if (this.isInventory && this.lightInventory) {
            RenderHelper.enableGUIStandardItemLighting();
        } else if (this.light) {
            RenderHelper.disableStandardItemLighting();
        } else {
            RenderHelper.enableStandardItemLighting();
        }
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f + (float)(this.isInventory ? this.scaleInventory : 1.0)), (float)((float)z + 0.5f));
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)(this.scale * (this.isInventory ? this.scaleInventory : 1.0)), (double)(this.scale * (this.isInventory ? this.scaleInventory : 1.0)), (double)(this.scale * (this.isInventory ? this.scaleInventory : 1.0)));
        if (this.alpha != 1.0f && !this.isInventory) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        }
    }

    protected void endRender() {
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glPopMatrix();
        if (this.alpha != 1.0f && !this.isInventory) {
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
    }

    protected void renderModel(JFIModelDoor model, String textureName, double x, double y, double z, float rotation, float doorProgess) {
        model.setDoorProgess(doorProgess);
        this.renderModel(model, textureName, x, y, z, rotation);
    }

    protected abstract void renderTileEntityAt(TileEntity var1, double var2, double var4, double var6, float var8, int var9);
}

