/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.tilesentities.wood;

import com.gollum.core.common.tileentities.GCLInventoryTileEntity;
import com.gollum.core.tools.helper.IBlockMetadataHelper;
import com.gollum.jammyfurniture.ModJammyFurniture;
import net.minecraft.block.Block;

public class TileEntityWoodBlocksOne
extends GCLInventoryTileEntity {
    private long soundTimeClock = 0L;
    private boolean soundDongClock = false;

    public TileEntityWoodBlocksOne() {
        super(6);
    }

    public String getInventoryName() {
        return ModJammyFurniture.i18n.trans("Hidey Hole", new Object[0]);
    }

    public void updateEntity() {
        int subBlock;
        super.updateEntity();
        Block block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord);
        int metadta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
        if (block instanceof IBlockMetadataHelper && (subBlock = ((IBlockMetadataHelper)block).getEnabledMetadata(metadta)) == 5) {
            double x = (double)this.xCoord + 0.5;
            double y = (double)this.yCoord + 0.5;
            double z = (double)this.zCoord + 0.5;
            int time = (int)this.worldObj.getWorldTime();
            int hour = (time / 1000 + 6) % 24;
            int min = (time - time / 1000 * 1000) * 60 / 1000;
            if (!(this.soundDongClock || hour != 0 && hour != 12 || min != 0)) {
                this.soundDongClock = true;
                this.worldObj.playSoundEffect(x, y, z, "JammyFurniture".toLowerCase() + ":clock-dong", 0.15f, this.worldObj.rand.nextFloat() * 0.1f + 0.8f);
            }
            if (min != 0) {
                this.soundDongClock = false;
            }
            if (System.currentTimeMillis() - this.soundTimeClock >= 2000L) {
                this.worldObj.playSoundEffect(x, y, z, "JammyFurniture".toLowerCase() + ":clock-tick", 0.25f, this.worldObj.rand.nextFloat() * 0.1f + 0.8f);
                this.soundTimeClock = System.currentTimeMillis();
            }
        }
    }
}

