/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.tilesentities.iron;

import com.gollum.core.common.tileentities.GCLInventoryTileEntity;
import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.crafting.DishwasherRecipes;
import com.gollum.jammyfurniture.common.crafting.WashingMachineRecipes;
import com.gollum.jammyfurniture.inits.ModBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityIronBlocksTwo
extends GCLInventoryTileEntity {
    public static final int INDEX_SLOT_BURN = 1;
    public static final int INDEX_SLOT_0 = 0;
    public static final int INDEX_SLOT_1 = 2;
    public static final int INDEX_SLOT_2 = 3;
    public static final int INDEX_SLOT_3 = 4;
    public int currentItemBurnTime = 0;
    public int burnTime = 0;
    public int slot0Time = 0;
    public int slot1Time = 0;
    public int slot2Time = 0;
    public int slot3Time = 0;
    private long soundTimeMachine = 0L;

    public TileEntityIronBlocksTwo() {
        super(5);
    }

    public String getInventoryName() {
        switch (this.getSubBlock()) {
            case 0: {
                return ModJammyFurniture.i18n.trans("Dishwasher", new Object[0]);
            }
            case 4: {
                return ModJammyFurniture.i18n.trans("Washing Machine", new Object[0]);
            }
        }
        return "ERROR";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isItemValidForSlot(int slot, ItemStack itemStack) {
        int subBlock = this.getSubBlock();
        if (slot == 1) {
            if (TileEntityIronBlocksTwo.isItemFuel(itemStack)) return true;
        }
        if (slot == 1) return false;
        if (subBlock == 0) {
            if (DishwasherRecipes.smelting().getSmeltingResult(itemStack) == null) return true;
        }
        if (subBlock != 4) return false;
        if (WashingMachineRecipes.smelting().getSmeltingResult(itemStack) != null) return false;
        return true;
    }

    public void updateEntity() {
        super.updateEntity();
        int metadata = this.getBlockMetadata();
        boolean inventoryChange = false;
        if (!this.worldObj.isRemote) {
            if (this.isBurning()) {
                --this.burnTime;
                double x = (double)this.xCoord + 0.5;
                double y = (double)this.yCoord + 0.5;
                double z = (double)this.zCoord + 0.5;
                if (System.currentTimeMillis() - this.soundTimeMachine >= 13000L && this.canSmelt()) {
                    this.worldObj.playSoundEffect(x, y, z, "JammyFurniture".toLowerCase() + ":machine", 0.6f, this.worldObj.rand.nextFloat() * 0.1f + 0.8f);
                    this.soundTimeMachine = System.currentTimeMillis();
                }
            }
            if (!this.isBurning() && this.canSmelt()) {
                this.currentItemBurnTime = this.burnTime = TileEntityIronBlocksTwo.getItemBurnTime(this.inventory[1]);
                if (this.burnTime > 0) {
                    inventoryChange = true;
                    if (this.inventory[1] != null) {
                        --this.inventory[1].stackSize;
                        if (this.inventory[1].stackSize == 0) {
                            this.inventory[1] = this.inventory[1].getItem().getContainerItem(this.inventory[1]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt(0)) {
                ++this.slot0Time;
                if (this.slot0Time >= this.getSmeltTime(0)) {
                    this.slot0Time = 0;
                    this.smeltItem(0);
                    inventoryChange = true;
                }
            } else {
                this.slot0Time = 0;
            }
            if (this.isBurning() && this.canSmelt(1)) {
                ++this.slot1Time;
                if (this.slot1Time >= this.getSmeltTime(1)) {
                    this.slot1Time = 0;
                    this.smeltItem(1);
                    inventoryChange = true;
                }
            } else {
                this.slot1Time = 0;
            }
            if (this.isBurning() && this.canSmelt(2)) {
                ++this.slot2Time;
                if (this.slot2Time >= this.getSmeltTime(2)) {
                    this.slot2Time = 0;
                    this.smeltItem(2);
                    inventoryChange = true;
                }
            } else {
                this.slot2Time = 0;
            }
            if (this.isBurning() && this.canSmelt(3)) {
                ++this.slot3Time;
                if (this.slot3Time >= this.getSmeltTime(3)) {
                    this.slot3Time = 0;
                    this.smeltItem(3);
                    inventoryChange = true;
                }
            } else {
                this.slot3Time = 0;
            }
            if (inventoryChange) {
                this.markDirty();
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.readItems(nbtTagCompound, "dwItems", true);
        this.readItems(nbtTagCompound, "wmItems", true);
        this.burnTime = nbtTagCompound.getShort("burnTime");
        this.slot0Time = nbtTagCompound.getShort("slot0Time");
        this.slot1Time = nbtTagCompound.getShort("slot1Time");
        this.slot2Time = nbtTagCompound.getShort("slot2Time");
        this.slot3Time = nbtTagCompound.getShort("slot3Time");
        this.currentItemBurnTime = TileEntityIronBlocksTwo.getItemBurnTime(this.inventory[1]);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        nbtTagCompound.setShort("burnTime", (short)this.burnTime);
        nbtTagCompound.setShort("slot0Time", (short)this.slot0Time);
        nbtTagCompound.setShort("slot1Time", (short)this.slot1Time);
        nbtTagCompound.setShort("slot2Time", (short)this.slot2Time);
        nbtTagCompound.setShort("slot3Time", (short)this.slot3Time);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.func_148857_g());
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityIronBlocksTwo.getItemBurnTime(par0ItemStack) > 0;
    }

    protected static int getItemBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.getItemBurnTime((ItemStack)itemStack);
    }

    public int getSmeltTime(int i) {
        int slot;
        int time = 0;
        int subBlock = this.getSubBlock();
        switch (i) {
            default: {
                slot = 0;
                break;
            }
            case 1: {
                slot = 2;
                break;
            }
            case 2: {
                slot = 3;
                break;
            }
            case 3: {
                slot = 4;
            }
        }
        time = subBlock == 0 ? DishwasherRecipes.smelting().getSmeltingTime(this.inventory[slot]) : WashingMachineRecipes.smelting().getSmeltingTime(this.inventory[slot]);
        return time;
    }

    public boolean canSmelt(int i) {
        int slot;
        int subBlock = this.getSubBlock();
        switch (i) {
            default: {
                slot = 0;
                break;
            }
            case 1: {
                slot = 2;
                break;
            }
            case 2: {
                slot = 3;
                break;
            }
            case 3: {
                slot = 4;
            }
        }
        if (this.inventory[slot] == null) {
            return false;
        }
        ItemStack itemBurned = subBlock == 0 ? DishwasherRecipes.smelting().getSmeltingResult(this.inventory[slot]) : WashingMachineRecipes.smelting().getSmeltingResult(this.inventory[slot]);
        return itemBurned != null;
    }

    public boolean canSmelt() {
        return this.canSmelt(0) || this.canSmelt(1) || this.canSmelt(2) || this.canSmelt(3);
    }

    public void smeltItem(int i) {
        int slot;
        int subBlock = this.getSubBlock();
        switch (i) {
            default: {
                slot = 0;
                break;
            }
            case 1: {
                slot = 2;
                break;
            }
            case 2: {
                slot = 3;
                break;
            }
            case 3: {
                slot = 4;
            }
        }
        if (this.canSmelt(i)) {
            if (this.inventory[slot].stackSize <= 0) {
                this.inventory[slot] = null;
            }
            this.inventory[slot].setItemDamage(0);
        }
    }

    public int getBurnTimeRemainingScaled(int maxSize) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTime * maxSize / this.currentItemBurnTime;
    }

    public int getProgressSlot0(int par1) {
        int time = this.getSmeltTime(0);
        return time == 0 ? 0 : this.slot0Time * par1 / time;
    }

    public int getProgressSlot1(int par1) {
        int time = this.getSmeltTime(1);
        return time == 0 ? 0 : this.slot1Time * par1 / time;
    }

    public int getProgressSlot2(int par1) {
        int time = this.getSmeltTime(2);
        return time == 0 ? 0 : this.slot2Time * par1 / time;
    }

    public int getProgressSlot3(int par1) {
        int time = this.getSmeltTime(3);
        return time == 0 ? 0 : this.slot3Time * par1 / time;
    }

    private int getSubBlock() {
        int metadata = this.getBlockMetadata();
        return ModBlocks.blockIronBlocksOne.getEnabledMetadata(metadata);
    }
}

