/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.containers;

import com.gollum.jammyfurniture.common.crafting.CookerRecipes;
import com.gollum.jammyfurniture.common.tilesentities.iron.TileEntityIronBlocksOne;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.ItemStack;

public class ContainerCooker
extends Container {
    private TileEntityIronBlocksOne tileEntity;
    private int CookTime = 0;
    private int CookTime2 = 0;
    private int BurnTime = 0;
    private int ItemBurnTime = 0;

    public ContainerCooker(InventoryPlayer inventoryPlayer, TileEntityIronBlocksOne tileEntityCooker) {
        int j;
        this.tileEntity = tileEntityCooker;
        tileEntityCooker.openInventory();
        this.addSlotToContainer(new Slot((IInventory)tileEntityCooker, 0, 77, 20));
        this.addSlotToContainer(new Slot((IInventory)tileEntityCooker, 1, 20, 44));
        this.addSlotToContainer((Slot)new SlotFurnace(inventoryPlayer.player, (IInventory)tileEntityCooker, 2, 143, 22));
        this.addSlotToContainer(new Slot((IInventory)tileEntityCooker, 3, 77, 49));
        this.addSlotToContainer((Slot)new SlotFurnace(inventoryPlayer.player, (IInventory)tileEntityCooker, 4, 143, 49));
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, j, 8 + j * 18, 142));
        }
    }

    public void onContainerClosed(EntityPlayer par1EntityPlayer) {
        super.onContainerClosed(par1EntityPlayer);
        this.tileEntity.closeInventory();
    }

    public void updateProgressBar(int progressID, int value) {
        if (progressID == 0) {
            this.tileEntity.cookerCookTime0 = value;
        }
        if (progressID == 1) {
            this.tileEntity.cookerCookTime1 = value;
        }
        if (progressID == 2) {
            this.tileEntity.cookerBurnTime = value;
        }
        if (progressID == 3) {
            this.tileEntity.currentItemBurnTime = value;
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.crafters.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            if (this.CookTime != this.tileEntity.cookerCookTime0) {
                icrafting.sendProgressBarUpdate((Container)this, 0, this.tileEntity.cookerCookTime0);
            }
            if (this.CookTime2 != this.tileEntity.cookerCookTime1) {
                icrafting.sendProgressBarUpdate((Container)this, 1, this.tileEntity.cookerCookTime1);
            }
            if (this.BurnTime != this.tileEntity.cookerBurnTime) {
                icrafting.sendProgressBarUpdate((Container)this, 2, this.tileEntity.cookerBurnTime);
            }
            if (this.ItemBurnTime == this.tileEntity.currentItemBurnTime) continue;
            icrafting.sendProgressBarUpdate((Container)this, 3, this.tileEntity.currentItemBurnTime);
        }
        this.CookTime = this.tileEntity.cookerCookTime0;
        this.CookTime2 = this.tileEntity.cookerCookTime1;
        this.BurnTime = this.tileEntity.cookerBurnTime;
        this.ItemBurnTime = this.tileEntity.currentItemBurnTime;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.tileEntity.isUseableByPlayer(entityplayer);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotId) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotId);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemStack = itemstack1.copy();
            if (slotId < this.tileEntity.getSizeInventory()) {
                if (!this.mergeItemStack(itemstack1, this.tileEntity.getSizeInventory(), this.inventorySlots.size(), true)) {
                    return null;
                }
            } else if (TileEntityIronBlocksOne.isItemFuel(itemstack1)) {
                if (!this.mergeItemStack(itemstack1, 1, 2, false)) {
                    return null;
                }
            } else {
                if (CookerRecipes.smelting().getSmeltingResult(itemstack1) == null) {
                    return null;
                }
                if (!this.mergeItemStack(itemstack1, 0, 1, false) && !this.mergeItemStack(itemstack1, 3, 4, false)) {
                    return null;
                }
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemStack;
    }
}

