/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.block.wood;

import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.block.JFMetadataBlock;
import com.gollum.jammyfurniture.common.item.ItemWoodBlocksFour;
import com.gollum.jammyfurniture.common.tilesentities.wood.TileEntityWoodBlocksFour;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WoodBlocksFour
extends JFMetadataBlock {
    public static int rotation;

    public WoodBlocksFour(String registerName) {
        super(registerName, Material.wood, "wood", TileEntityWoodBlocksFour.class, new int[]{0, 8});
        this.setItemBlockClass(ItemWoodBlocksFour.class);
    }

    @Override
    protected void getCollisionBoundingBox(int metadata, boolean isSelectBox) {
        int subBlock = this.getEnabledMetadata(metadata);
        switch (subBlock) {
            case 0: {
                this.setBlockBounds(0.06f, 0.0f, 0.06f, 0.94f, 0.95f, 0.94f);
                break;
            }
            case 8: {
                if (isSelectBox) {
                    this.setBlockBounds(0.3f, 0.0f, 0.3f, 0.7f, 1.0f, 0.7f);
                    break;
                }
                this.setBlockBounds(0.47f, 0.0f, 0.47f, 0.53f, 1.0f, 0.53f);
                break;
            }
            default: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, int metadata) {
        int y2 = y + 1;
        if (WoodBlocksFour.isBlockHead(metadata)) {
            y2 = y - 1;
        }
        if (world.getBlock(x, y2, z) == this) {
            world.func_147480_a(x, y2, z, true);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int hitX, float hitY, float hitZ, float par9) {
        int metadata = world.getBlockMetadata(x, y, z);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileEntityWoodBlocksFour) {
            TileEntityWoodBlocksFour teWoodBlocks = (TileEntityWoodBlocksFour)te;
            switch (metadata) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    player.openGui((Object)ModJammyFurniture.instance, 9, world, x, y, z);
                    return true;
                }
            }
        }
        return false;
    }

    public void breakBlock(World world, int x, int y, int z, Block oldBlock, int oldMetadtaID) {
        this.breakBlockInventory(world, x, y, z, oldBlock);
        super.breakBlock(world, x, y, z, oldBlock, oldMetadtaID);
    }

    public int getRenderType() {
        return ModJammyFurniture.woodBlocksFourRenderID;
    }

    public Item getItemDropped(int metadata, Random random, int j) {
        return WoodBlocksFour.isBlockHead(metadata) ? super.getItemDropped(metadata, random, j) : null;
    }

    public static boolean isBlockHead(int metadata) {
        return metadata == 4 || metadata == 5 || metadata == 6 || metadata == 7 || metadata == 12 || metadata == 13 || metadata == 14 || metadata == 15;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int rotate = axis == ForgeDirection.DOWN ? 3 : 1;
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        if (WoodBlocksFour.isBlockHead(metadata)) {
            subBlock += 4;
        }
        world.setBlockMetadataWithNotify(x, y, z, (metadata - subBlock + rotate) % 4 + subBlock, 2);
        metadata = world.getBlockMetadata(x, y += WoodBlocksFour.isBlockHead(metadata) ? -1 : 1, z);
        subBlock = this.getEnabledMetadata(metadata);
        if (WoodBlocksFour.isBlockHead(metadata)) {
            subBlock += 4;
        }
        world.setBlockMetadataWithNotify(x, y, z, (metadata - subBlock + rotate) % 4 + subBlock, 2);
        return true;
    }
}

