/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.block.iron;

import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.block.JFMetadataBlock;
import com.gollum.jammyfurniture.common.tilesentities.iron.TileEntityIronBlocksTwo;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class IronBlocksTwo
extends JFMetadataBlock {
    public IronBlocksTwo(String registerName) {
        super(registerName, Material.iron, "iron", TileEntityIronBlocksTwo.class, new int[]{0, 4});
    }

    @Override
    protected void getCollisionBoundingBox(int metadata, boolean isSelectBox) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        int metadata = world.getBlockMetadata(x, y, z);
        int orientation = this.getOrientation((Entity)entityliving);
        if (metadata == 0 || metadata == 4) {
            world.setBlockMetadataWithNotify(x, y, z, metadata + orientation, 2);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.getBlockMetadata(x, y, z);
        int orientation = this.getOrientation((Entity)player);
        int subBlock = this.getEnabledMetadata(metadata);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileEntityIronBlocksTwo) {
            TileEntityIronBlocksTwo teIron = (TileEntityIronBlocksTwo)te;
            switch (subBlock) {
                case 0: {
                    player.openGui((Object)ModJammyFurniture.instance, 7, world, x, y, z);
                    return true;
                }
                case 4: {
                    player.openGui((Object)ModJammyFurniture.instance, 4, world, x, y, z);
                    return true;
                }
            }
        }
        return false;
    }

    public void breakBlock(World world, int x, int y, int z, Block oldBlock, int oldMetadata) {
        this.breakBlockInventory(world, x, y, z, oldBlock);
        super.breakBlock(world, x, y, z, oldBlock, oldMetadata);
    }

    public int getRenderType() {
        return ModJammyFurniture.ironBlocksTwoRenderID;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int rotate = axis == ForgeDirection.DOWN ? 3 : 1;
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        if (subBlock == 0 || subBlock == 4) {
            world.setBlockMetadataWithNotify(x, y, z, (metadata - subBlock + rotate) % 4 + subBlock, 2);
            return true;
        }
        return false;
    }
}

