/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.block;

import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.block.BlockMountable;
import com.gollum.jammyfurniture.common.block.JFMetadataBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSofa
extends JFMetadataBlock {
    private IIcon blockIconRed;
    private IIcon blockIconBlue;
    private IIcon blockIconGreen;
    private IIcon blockIconGrey;

    public BlockSofa(String registerName, Class tileEntityClass) {
        super(registerName, Material.wood, "wood", tileEntityClass, new int[]{0, 4, 8, 12});
    }

    @Override
    protected void getCollisionBoundingBox(int metadata, boolean isSelectBox) {
        if (isSelectBox) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.7f, 1.0f);
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack item) {
        int metadata = world.getBlockMetadata(x, y, z);
        int orientation = this.getOrientation((Entity)entityliving);
        if (metadata == 0 || metadata == 4 || metadata == 8 || metadata == 12) {
            world.setBlockMetadataWithNotify(x, y, z, metadata + orientation, 2);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int hitX, float hitY, float hitZ, float par9) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (world.isRemote) {
            return true;
        }
        if ((metadata %= 4) == 0) {
            player.rotationYaw = 180.0f;
        }
        if (metadata == 1) {
            player.rotationYaw = -90.0f;
        }
        if (metadata == 2) {
            player.rotationYaw = 0.0f;
        }
        if (metadata == 3) {
            player.rotationYaw = 90.0f;
        }
        return BlockMountable.onBlockActivated(world, x, y, z, player, 0.5f, 0.4f, 0.5f, 0, 0, 0, 0);
    }

    public int getRenderType() {
        return ModJammyFurniture.sofaRenderID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIconRed = this.helper.loadTexture(par1IconRegister, "sofa_red", true);
        this.blockIconGreen = this.helper.loadTexture(par1IconRegister, "sofa_green", true);
        this.blockIconGrey = this.helper.loadTexture(par1IconRegister, "sofa_grey", true);
        this.blockIconBlue = this.helper.loadTexture(par1IconRegister, "sofa_blue", true);
    }

    public IIcon getIcon(int side, int metadata) {
        int subBlock = this.getEnabledMetadata(metadata);
        switch (subBlock) {
            default: {
                return this.blockIconRed;
            }
            case 4: {
                return this.blockIconBlue;
            }
            case 8: {
                return this.blockIconGreen;
            }
            case 12: 
        }
        return this.blockIconGrey;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int rotate = axis == ForgeDirection.DOWN ? 3 : 1;
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        if (subBlock == 0 || subBlock == 4 || subBlock == 8 || subBlock == 12) {
            world.setBlockMetadataWithNotify(x, y, z, (metadata - subBlock + rotate) % 4 + subBlock, 2);
            return true;
        }
        return false;
    }
}

