/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.tilesentities.iron;

import com.gollum.core.common.tileentities.GCLInventoryTileEntity;
import com.gollum.core.tools.helper.IBlockMetadataHelper;
import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.crafting.CookerRecipes;
import com.gollum.jammyfurniture.inits.ModBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityIronBlocksOne
extends GCLInventoryTileEntity {
    public static final int INV_SIZE_FRIDGE = 9;
    public static final int INV_SIZE_COOKER = 5;
    public static final int INV_SIZE_RUBBISHBIN = 27;
    public static final int INDEX_SLOT_BURN = 1;
    public static final int INDEX_SLOT_BEFORE0 = 0;
    public static final int INDEX_SLOT_BEFORE1 = 3;
    public static final int INDEX_SLOT_AFTER0 = 2;
    public static final int INDEX_SLOT_AFTER1 = 4;
    public static final int COOKING_SPEED0 = 200;
    public static final int COOKING_SPEED1 = 150;
    public int currentItemBurnTime = 0;
    public int cookerBurnTime = 0;
    public int cookerCookTime0 = 0;
    public int cookerCookTime1 = 0;
    long lastClearance = System.currentTimeMillis();
    public short rubishBinOrientation = 0;

    public TileEntityIronBlocksOne() {
        super(Math.max(9, Math.max(5, 27)));
    }

    public int getSizeInventory() {
        if (this.worldObj != null && this.worldObj.blockExists(this.xCoord, this.yCoord, this.zCoord)) {
            switch (this.getSubBlock()) {
                case 0: 
                case 4: {
                    return 9;
                }
                case 8: {
                    return 5;
                }
                case 12: {
                    return 27;
                }
            }
        }
        return super.getSizeInventory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isItemValidForSlot(int slot, ItemStack itemStack) {
        if (slot == 1) {
            if (TileEntityIronBlocksOne.isItemFuel(itemStack)) return true;
        }
        if (slot == 0) {
            if (CookerRecipes.smelting().getSmeltingResult(itemStack) == null) return true;
        }
        if (slot != 3) return false;
        if (CookerRecipes.smelting().getSmeltingResult(itemStack) != null) return false;
        return true;
    }

    public String getInvName() {
        switch (this.getSubBlock()) {
            case 0: {
                return ModJammyFurniture.i18n.trans("Fridge", new Object[0]);
            }
            case 4: {
                return ModJammyFurniture.i18n.trans("Freezer", new Object[0]);
            }
            case 8: {
                return ModJammyFurniture.i18n.trans("Cooker", new Object[0]);
            }
            case 12: {
                return ModJammyFurniture.i18n.trans("Rubbish Bin", new Object[0]);
            }
        }
        return "ERROR";
    }

    protected void playSoundClosedInventory() {
        String oldSound = this.soundClosedInventory;
        float oldVolume = this.volumeSoundOpenClosedInventory;
        if (this.getSubBlock() == 12) {
            this.soundClosedInventory = "JammyFurniture".toLowerCase() + ":trashclosed";
            this.volumeSoundOpenClosedInventory = 1.5f;
        }
        super.playSoundClosedInventory();
        this.soundClosedInventory = oldSound;
        this.volumeSoundOpenClosedInventory = oldVolume;
    }

    protected void playSoundOpenInventory() {
        String oldSound = this.soundOpenInventory;
        float oldVolume = this.volumeSoundOpenClosedInventory;
        if (this.getSubBlock() == 12) {
            this.soundOpenInventory = "JammyFurniture".toLowerCase() + ":trashopen";
            this.volumeSoundOpenClosedInventory = 1.5f;
        }
        super.playSoundOpenInventory();
        this.soundOpenInventory = oldSound;
        this.volumeSoundOpenClosedInventory = oldVolume;
    }

    public void updateEntity() {
        super.updateEntity();
        int metadata = this.getBlockMetadata();
        int subBlock = this.getSubBlock();
        if (subBlock == 12) {
            if (System.currentTimeMillis() - this.lastClearance >= 60000L) {
                this.removeAllItems();
                this.lastClearance = System.currentTimeMillis();
            }
            return;
        }
        if (subBlock == 8) {
            boolean inventoryChange = false;
            if (this.isBurning()) {
                --this.cookerBurnTime;
            }
            if (!this.worldObj.isRemote) {
                if (this.cookerBurnTime == 0 && (this.canSmelt(0) || this.canSmelt(1))) {
                    this.currentItemBurnTime = this.cookerBurnTime = TileEntityIronBlocksOne.getItemBurnTime(this.inventory[1]);
                    if (this.cookerBurnTime > 0) {
                        inventoryChange = true;
                        if (this.inventory[1] != null) {
                            --this.inventory[1].stackSize;
                            if (this.inventory[1].stackSize == 0) {
                                this.inventory[1] = this.inventory[1].getItem().getContainerItemStack(this.inventory[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(0)) {
                    ++this.cookerCookTime0;
                    if (this.cookerCookTime0 == 200) {
                        this.cookerCookTime0 = 0;
                        this.smeltItem(0);
                        inventoryChange = true;
                    }
                } else {
                    this.cookerCookTime0 = 0;
                }
                if (this.isBurning() && this.canSmelt(1)) {
                    ++this.cookerCookTime1;
                    if (this.cookerCookTime1 >= 150) {
                        this.cookerCookTime1 = 0;
                        this.smeltItem(1);
                        inventoryChange = true;
                    }
                } else {
                    this.cookerCookTime1 = 0;
                }
            }
            if (inventoryChange) {
                this.onInventoryChanged();
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.readItems(nbtTagCompound, "FriFreItems", true);
        this.readItems(nbtTagCompound, "CookerItems", true);
        this.readItems(nbtTagCompound, "BinItems", true);
        this.cookerBurnTime = nbtTagCompound.getShort("BurnTime");
        this.cookerCookTime0 = nbtTagCompound.getShort("CookTime");
        this.cookerCookTime1 = nbtTagCompound.getShort("CookTime2");
        this.rubishBinOrientation = nbtTagCompound.getShort("rubishBinOrientation");
        this.currentItemBurnTime = TileEntityIronBlocksOne.getItemBurnTime(this.inventory[1]);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        nbtTagCompound.setShort("BurnTime", (short)this.cookerBurnTime);
        nbtTagCompound.setShort("CookTime", (short)this.cookerCookTime0);
        nbtTagCompound.setShort("CookTime2", (short)this.cookerCookTime1);
        nbtTagCompound.setShort("rubishBinOrientation", this.rubishBinOrientation);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Packet132TileEntityData(this.xCoord, this.yCoord, this.zCoord, 0, nbttagcompound);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.readFromNBT(pkt.data);
        this.worldObj.markBlockRangeForRenderUpdate(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
    }

    public void removeAllItems() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            this.setInventorySlotContents(i, null);
        }
    }

    private int getSubBlock() {
        int metadata = this.getBlockMetadata();
        return ((IBlockMetadataHelper)ModBlocks.blockIronBlocksOne).getEnabledMetadata(metadata);
    }

    public boolean isBurning() {
        return this.cookerBurnTime > 0;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityIronBlocksOne.getItemBurnTime(par0ItemStack) > 0;
    }

    protected static int getItemBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.getItemBurnTime((ItemStack)itemStack);
    }

    private boolean canSmelt(int i) {
        int after;
        int before = i == 0 ? 0 : 3;
        int n = after = i == 0 ? 2 : 4;
        if (this.inventory[before] == null) {
            return false;
        }
        ItemStack itemCooked = CookerRecipes.smelting().getSmeltingResult(this.inventory[before]);
        if (itemCooked == null) {
            return false;
        }
        if (this.inventory[after] == null) {
            return true;
        }
        if (!this.inventory[after].isItemEqual(itemCooked)) {
            return false;
        }
        int total = this.inventory[after].stackSize + itemCooked.stackSize;
        return total <= this.getInventoryStackLimit() && total <= itemCooked.getMaxStackSize();
    }

    public void smeltItem(int i) {
        int after;
        int before = i == 0 ? 0 : 3;
        int n = after = i == 0 ? 2 : 4;
        if (this.canSmelt(i)) {
            ItemStack itemStack = CookerRecipes.smelting().getSmeltingResult(this.inventory[before]);
            if (this.inventory[after] == null) {
                this.inventory[after] = itemStack.copy();
            } else if (this.inventory[after].isItemEqual(itemStack)) {
                this.inventory[after].stackSize += itemStack.stackSize;
            }
            --this.inventory[before].stackSize;
            if (this.inventory[before].stackSize <= 0) {
                this.inventory[before] = null;
            }
        }
    }

    public int getBurnTimeRemainingScaled(int maxSize) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.cookerBurnTime * maxSize / this.currentItemBurnTime;
    }

    public int getCookProgressScaled0(int par1) {
        return this.cookerCookTime0 * par1 / 200;
    }

    public int getCookProgressScaled1(int par1) {
        return this.cookerCookTime1 * par1 / 150;
    }
}

