/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.crafting;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class WashingMachineRecipes {
    private static final WashingMachineRecipes smeltingBase = new WashingMachineRecipes();
    private Map<Item, RecipesResult> smeltingList = new HashMap<Item, RecipesResult>();

    public static final WashingMachineRecipes smelting() {
        return smeltingBase;
    }

    private WashingMachineRecipes() {
        this.addSmelting((Item)Item.bootsLeather, new ItemStack((Item)Item.bootsLeather), 1500);
        this.addSmelting((Item)Item.helmetLeather, new ItemStack((Item)Item.helmetLeather), 1500);
        this.addSmelting((Item)Item.plateLeather, new ItemStack((Item)Item.plateLeather), 1500);
        this.addSmelting((Item)Item.legsLeather, new ItemStack((Item)Item.legsLeather), 1500);
        this.addSmelting((Item)Item.bootsIron, new ItemStack((Item)Item.bootsIron), 4000);
        this.addSmelting((Item)Item.helmetIron, new ItemStack((Item)Item.helmetIron), 4000);
        this.addSmelting((Item)Item.plateIron, new ItemStack((Item)Item.plateIron), 4000);
        this.addSmelting((Item)Item.legsIron, new ItemStack((Item)Item.legsIron), 4000);
        this.addSmelting((Item)Item.bootsGold, new ItemStack((Item)Item.bootsGold), 4800);
        this.addSmelting((Item)Item.helmetGold, new ItemStack((Item)Item.helmetGold), 4800);
        this.addSmelting((Item)Item.plateGold, new ItemStack((Item)Item.plateGold), 4800);
        this.addSmelting((Item)Item.legsGold, new ItemStack((Item)Item.legsGold), 4800);
        this.addSmelting((Item)Item.bootsChain, new ItemStack((Item)Item.bootsChain), 6000);
        this.addSmelting((Item)Item.helmetChain, new ItemStack((Item)Item.helmetChain), 6000);
        this.addSmelting((Item)Item.plateChain, new ItemStack((Item)Item.plateChain), 6000);
        this.addSmelting((Item)Item.legsChain, new ItemStack((Item)Item.legsChain), 6000);
        this.addSmelting((Item)Item.bootsDiamond, new ItemStack((Item)Item.bootsDiamond), 7200);
        this.addSmelting((Item)Item.helmetDiamond, new ItemStack((Item)Item.helmetDiamond), 7200);
        this.addSmelting((Item)Item.plateDiamond, new ItemStack((Item)Item.plateDiamond), 7200);
        this.addSmelting((Item)Item.legsDiamond, new ItemStack((Item)Item.legsDiamond), 7200);
    }

    public void addSmelting(Item itemArmor, ItemStack itemStack, int smeltTime) {
        this.smeltingList.put(itemArmor, new RecipesResult(itemStack, smeltTime));
    }

    public ItemStack getSmeltingResult(ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemDamage() == 0) {
            return null;
        }
        Item item = itemStack.getItem();
        ItemStack rtn = null;
        if (this.smeltingList.containsKey(item)) {
            rtn = this.smeltingList.get((Object)item).itemStack.copy();
        }
        if (item instanceof ItemArmor) {
            rtn = itemStack.copy();
            rtn.setItemDamage(0);
        }
        return rtn;
    }

    public int getSmeltingTime(ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemDamage() == 0) {
            return 0;
        }
        Item item = itemStack.getItem();
        int time = 0;
        if (this.smeltingList.containsKey(item)) {
            time = this.smeltingList.get((Object)item).smeltTime;
        } else if (item instanceof ItemArmor) {
            time = 8000;
        }
        return time;
    }

    private class RecipesResult {
        public ItemStack itemStack;
        public int smeltTime;

        public RecipesResult(ItemStack itemStack, int smeltTime) {
            this.itemStack = itemStack;
            this.smeltTime = smeltTime;
        }
    }
}

