/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.building.handler;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.building.handler.BuildingBlockHandler;
import com.gollum.jammyfurniture.common.block.ceramic.CeramicBlocksOne;
import com.gollum.jammyfurniture.common.tilesentities.ceramic.TileEntityCeramicBlocksOne;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CeramicBlocksOneBuildingHandler
extends BuildingBlockHandler {
    protected boolean mustApply(World world, int x, int y, int z, Block block) {
        return block instanceof CeramicBlocksOne;
    }

    public void applyOrientation(World world, int x, int y, int z, Block block, int metadata, int orientation, int rotate) {
        int subBlock = ((CeramicBlocksOne)block).getEnabledMetadata(metadata);
        if (subBlock == 0 || subBlock == 4 || subBlock == 8 || subBlock == 12) {
            if (orientation == 0) {
                metadata = subBlock + 0;
            } else if (orientation == 1) {
                metadata = subBlock + 0;
            } else if (orientation == 2) {
                metadata = subBlock + 2;
            } else if (orientation == 3) {
                metadata = subBlock + 3;
            } else if (orientation == 4) {
                metadata = subBlock + 1;
            } else {
                ModGollumCoreLib.log.severe(new Object[]{"Bad orientation : " + orientation + " name:" + block.getUnlocalizedName() + " pos:" + x + "," + y + "," + z});
            }
        }
        world.setBlockMetadataWithNotify(x, y, z, metadata, 0);
    }

    protected void applyExtra(Block block, World world, Random random, int x, int y, int z, HashMap<String, String> extra, int initX, int initY, int initZ, int rotate, int dx, int dz, int maxX, int maxZ) {
        TileEntity te;
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = ((CeramicBlocksOne)block).getEnabledMetadata(metadata);
        if ((subBlock == 4 || subBlock == 8) && (te = world.getBlockTileEntity(x, y, z)) instanceof TileEntityCeramicBlocksOne) {
            boolean open = false;
            try {
                open = Boolean.parseBoolean(extra.get("open"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (((TileEntityCeramicBlocksOne)te).waterIsOn() != open) {
                ((TileEntityCeramicBlocksOne)te).toggleWater();
            }
        }
    }
}

