/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.block.wood;

import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.block.BlockMountable;
import com.gollum.jammyfurniture.common.block.JFMetadataBlock;
import com.gollum.jammyfurniture.common.tilesentities.wood.TileEntityWoodBlocksThree;
import com.gollum.jammyfurniture.inits.ModBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class WoodBlocksThree
extends JFMetadataBlock {
    public static int rotation;
    private Icon jfm_blockIcon;

    public WoodBlocksThree(int id, String registerName) {
        super(id, registerName, Material.wood, "wood", TileEntityWoodBlocksThree.class, new int[]{0, 4});
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        if (subBlock == 0) {
            this.setBlockBounds(0.15f, 0.0f, 0.15f, 0.85f, 0.5f, 0.85f);
            super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            if (metadata == 0) {
                this.setBlockBounds(0.15f, 0.0f, 0.75f, 0.85f, 1.0f, 0.85f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metadata == 1) {
                this.setBlockBounds(0.15f, 0.0f, 0.15f, 0.25f, 1.0f, 0.85f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metadata == 2) {
                this.setBlockBounds(0.15f, 0.0f, 0.15f, 0.85f, 1.0f, 0.25f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            } else if (metadata == 3) {
                this.setBlockBounds(0.75f, 0.0f, 0.15f, 0.85f, 1.0f, 0.85f);
                super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
            }
            return;
        }
        super.addCollisionBoxesToList(world, x, y, z, axisAlignedBB, list, entity);
    }

    @Override
    protected void getCollisionBoundingBox(int metadata, boolean isSelectBox) {
        switch (metadata) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (!isSelectBox) break;
                this.setBlockBounds(0.15f, 0.0f, 0.15f, 0.85f, 1.0f, 0.85f);
                break;
            }
            case 4: 
            case 6: {
                this.setBlockBounds(0.0f, 0.0f, 0.3f, 1.0f, 0.7f, 0.7f);
                break;
            }
            case 5: 
            case 7: {
                this.setBlockBounds(0.3f, 0.0f, 0.0f, 0.7f, 0.7f, 1.0f);
                break;
            }
            case 8: {
                this.setBlockBounds(0.0f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 9: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.1f, 1.0f, 1.0f);
                break;
            }
            case 10: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1f);
                break;
            }
            case 11: {
                this.setBlockBounds(0.9f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 12: {
                if (isSelectBox) {
                    this.setBlockBounds(0.0f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                this.setBlockBounds(0.0f, 0.85f, 0.9f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 13: {
                if (isSelectBox) {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.1f, 1.0f, 1.0f);
                    break;
                }
                this.setBlockBounds(0.0f, 0.85f, 0.0f, 0.1f, 1.0f, 1.0f);
                break;
            }
            case 14: {
                if (isSelectBox) {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1f);
                    break;
                }
                this.setBlockBounds(0.0f, 0.85f, 0.0f, 1.0f, 1.0f, 0.1f);
                break;
            }
            case 15: {
                if (isSelectBox) {
                    this.setBlockBounds(0.9f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                this.setBlockBounds(0.9f, 0.85f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            default: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        int metadata = world.getBlockMetadata(x, y, z);
        int orientation = this.getOrientation((Entity)entityliving);
        if (metadata == 0 || metadata == 4) {
            world.setBlockMetadataWithNotify(x, y, z, metadata + orientation, 2);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int hitX, float hitY, float hitZ, float par9) {
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        switch (metadata) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                world.playSoundEffect((double)x, (double)y, (double)z, "JammyFurniture".toLowerCase() + ":radio", 0.5f, world.rand.nextFloat() * 0.1f + 0.9f);
                return true;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                world.setBlock(x, y, z, ModBlocks.blockWoodBlocksThree.blockID, metadata + 4, 2);
                return true;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                world.setBlock(x, y, z, ModBlocks.blockWoodBlocksOne.blockID, metadata - 3, 2);
                return true;
            }
        }
        if (world.isRemote) {
            return true;
        }
        if ((metadata %= 4) == 0) {
            player.rotationYaw = 180.0f;
        }
        if (metadata == 1) {
            player.rotationYaw = -90.0f;
        }
        if (metadata == 2) {
            player.rotationYaw = 0.0f;
        }
        if (metadata == 3) {
            player.rotationYaw = 90.0f;
        }
        return BlockMountable.onBlockActivated(world, x, y, z, player, 0.5f, 0.4f, 0.5f, 0, 0, 0, 0);
    }

    public int idDropped(int metadata, Random random, int j) {
        return metadata >= 8 ? ModBlocks.blockWoodBlocksOne.blockID : ModBlocks.blockWoodBlocksThree.blockID;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        return metadata >= 8 ? new ItemStack(ModBlocks.blockWoodBlocksOne.blockID, 1, 9) : super.getPickBlock(target, world, x, y, z);
    }

    public int getRenderType() {
        return ModJammyFurniture.woodBlocksThreeRenderID;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int rotate = axis == ForgeDirection.DOWN ? 3 : 1;
        int metadata = world.getBlockMetadata(x, y, z);
        int subBlock = this.getEnabledMetadata(metadata);
        if (subBlock == 0 || subBlock == 4) {
            world.setBlockMetadataWithNotify(x, y, z, (metadata - subBlock + rotate) % 4 + subBlock, 2);
            return true;
        }
        return false;
    }
}

