/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.block;

import com.gollum.core.tools.helper.blocks.HBlockContainer;
import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.block.BlockMountable;
import com.gollum.jammyfurniture.common.item.ItemBath;
import com.gollum.jammyfurniture.common.tilesentities.TileEntityBath;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BathBlock
extends HBlockContainer {
    public static final int[][] footBlockToHeadBlockMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public BathBlock(int par1, String registerName) {
        super(par1, registerName, Material.iron);
        this.setItemBlockClass(ItemBath.class);
    }

    public TileEntity createNewTileEntity(World world) {
        return new TileEntityBath();
    }

    public void setBlockBoundsBasedOnState(IBlockAccess blockAccess, int x, int y, int z) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.8f, 1.0f);
    }

    public String getTextureKey() {
        return "ceramic";
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, int metadata) {
        int direction = BathBlock.getDirection(metadata);
        int x2 = x + footBlockToHeadBlockMap[direction][0];
        int z2 = z + footBlockToHeadBlockMap[direction][1];
        boolean isHead = BathBlock.isBlockHead(metadata);
        if (isHead) {
            x2 = x - footBlockToHeadBlockMap[direction][0];
            z2 = z - footBlockToHeadBlockMap[direction][1];
        }
        if (world.getBlockId(x2, y, z2) == this.blockID) {
            world.destroyBlock(x2, y, z2, true);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int hitX, float hitY, float hitZ, float par9) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (world.isRemote) {
            return true;
        }
        if ((metadata %= 4) == 0) {
            player.rotationYaw = 180.0f;
        }
        if (metadata == 1) {
            player.rotationYaw = -90.0f;
        }
        if (metadata == 2) {
            player.rotationYaw = 0.0f;
        }
        if (metadata == 3) {
            player.rotationYaw = 90.0f;
        }
        return BlockMountable.onBlockActivated(world, x, y, z, player, 0.5f, 0.4f, 0.5f, 0, 0, 0, 0);
    }

    public int idDropped(int metadata, Random random, int j) {
        return BathBlock.isBlockHead(metadata) ? super.idDropped(metadata, random, j) : 0;
    }

    public int getRenderType() {
        return ModJammyFurniture.bathTubRenderID;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public static boolean isBlockHead(int metadata) {
        return (metadata & 7) != metadata;
    }

    public static int getDirection(int metadata) {
        return metadata & 3;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int rotate = axis == ForgeDirection.DOWN ? 3 : 1;
        int metadata = world.getBlockMetadata(x, y, z);
        world.setBlockMetadataWithNotify(x, y, z, (metadata + rotate) % 4, 2);
        return true;
    }
}

