/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.registry;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.client.gui.GCLGuiContainer;
import com.gollum.core.common.container.GCLContainer;
import java.util.Hashtable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;

public class InventoryRegistry {
    private static InventoryRegistry instance = new InventoryRegistry();
    private Hashtable<Integer, GuiContainerInventoryClass> guiInventoryList = new Hashtable();

    public static InventoryRegistry instance() {
        return instance;
    }

    public static void registerInventory(int guiId, int numColumns) {
        InventoryRegistry.registerContainer(guiId, GCLContainer.class, numColumns);
        if (ModGollumCoreLib.proxy.isRemote()) {
            InventoryRegistry.registerGui(guiId, GCLGuiContainer.class);
        }
    }

    public Hashtable<Integer, GuiContainerInventoryClass> getGuiInventoryList() {
        Hashtable<Integer, GuiContainerInventoryClass> guiInventoryList = this.guiInventoryList;
        this.guiInventoryList = new Hashtable();
        return guiInventoryList;
    }

    public static void registerContainer(int guiId, Class<? extends Container> classContainer) {
        InventoryRegistry.registerContainer(guiId, classContainer, -1);
    }

    public static void registerContainer(int guiId, Class<? extends Container> classContainer, int numColumns) {
        GuiContainerInventoryClass guiContainerInventory = new GuiContainerInventoryClass(classContainer, numColumns);
        if (InventoryRegistry.instance().guiInventoryList.containsKey(guiId)) {
            ModGollumCoreLib.log.warning("Override registry Container in id : " + guiId);
        }
        InventoryRegistry.instance().guiInventoryList.put(guiId, guiContainerInventory);
    }

    public static void registerGui(int guiId, Class<? extends GuiContainer> classGuiContainer) {
        if (!InventoryRegistry.instance().guiInventoryList.containsKey(guiId)) {
            ModGollumCoreLib.log.severe("Not foud register Container in id : " + guiId);
            return;
        }
        InventoryRegistry.instance().guiInventoryList.get((Object)Integer.valueOf((int)guiId)).classGuiContainer = classGuiContainer;
    }

    public static class GuiContainerInventoryClass {
        public Class<? extends Container> classContainer;
        public Class classGuiContainer = null;
        public Object parameter;

        public GuiContainerInventoryClass(Class<? extends Container> classContainer, int numColumns) {
            this.classContainer = classContainer;
            this.parameter = numColumns;
        }
    }
}

