/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.worldgenerator;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.building.Building;
import com.gollum.core.common.building.BuildingParser;
import com.gollum.core.common.building.ModBuildingParser;
import com.gollum.core.common.config.type.BuildingConfigType;
import com.gollum.core.common.worldgenerator.WorldGeneratorByBuilding;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Map;

public class WorldGeneratorByBuildingLoader {
    private ArrayList<BuildingConfigType> configs = new ArrayList();

    public WorldGeneratorByBuilding load() {
        WorldGeneratorByBuilding worldGeneratorByBuilding = new WorldGeneratorByBuilding();
        this.loadBuildingList();
        this.addBuildingList(worldGeneratorByBuilding);
        return worldGeneratorByBuilding;
    }

    public void loadBuildingList() {
        ModBuildingParser parser = new ModBuildingParser();
        for (String modId : Loader.instance().getIndexedModList().keySet()) {
            ModGollumCoreLib.log.info("Search buildings in mod : " + modId);
            BuildingConfigType config = parser.parse(modId);
            if (config == null) continue;
            this.configs.add(config);
        }
    }

    private void addBuildingList(WorldGeneratorByBuilding worldGeneratorByBuilding) {
        BuildingParser parser = new BuildingParser();
        for (BuildingConfigType config : this.configs) {
            String modId = config.modId;
            for (Map.Entry<String, BuildingConfigType.Group> groupEntry : config.lists.entrySet()) {
                BuildingConfigType.Group group = groupEntry.getValue();
                int idGroup = worldGeneratorByBuilding.addGroup(group.globalSpawnRate);
                for (Map.Entry<String, BuildingConfigType.Group.Building> buildingEntry : group.buildings.entrySet()) {
                    String buildingName = buildingEntry.getKey();
                    BuildingConfigType.Group.Building configBuilding = buildingEntry.getValue();
                    if (!configBuilding.enabled) continue;
                    Building building = parser.parse(buildingName, modId);
                    for (Map.Entry<Integer, BuildingConfigType.Group.Building.Dimention> entryDimentions : configBuilding.dimentions.entrySet()) {
                        Integer dimentionId = entryDimentions.getKey();
                        BuildingConfigType.Group.Building.Dimention configDimention = entryDimentions.getValue();
                        ModGollumCoreLib.log.info("Register building : modId=" + modId + ", idGroup=" + idGroup + ", buildingName=" + buildingName);
                        ModGollumCoreLib.log.info(" - For dimention : " + dimentionId);
                        ModGollumCoreLib.log.info(" -     spawnRate : " + configDimention.spawnRate);
                        ModGollumCoreLib.log.info(" -     spawnMin  : " + configDimention.spawnMin);
                        ModGollumCoreLib.log.info(" -     spawnMax  : " + configDimention.spawnMax);
                        building.dimentionsInfos.put(dimentionId, new Building.DimentionSpawnInfos(configDimention.spawnRate, configDimention.spawnMin, configDimention.spawnMax, configDimention.blocksSpawn));
                    }
                    worldGeneratorByBuilding.addBuilding(idGroup, building);
                }
            }
        }
    }
}

