/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.tileentities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public abstract class GCLInventoryTileEntity
extends TileEntity
implements IInventory {
    protected ItemStack[] inventory;
    protected int maxSize;
    protected boolean playSoundChest = true;
    protected float volumeSoundOpenClosedInventory = 0.5f;
    protected String soundOpenInventory = "random.chestopen";
    protected String soundClosedInventory = "random.chestclosed";
    private float doorOpenProgress = 0.0f;
    private float prevDoorOpenProgress = 0.0f;
    private float doorSpeed = 0.1f;
    protected int numUsingPlayers;

    public GCLInventoryTileEntity(int maxSize) {
        this.maxSize = maxSize;
        this.inventory = new ItemStack[maxSize];
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.func_70302_i_()) {
            return null;
        }
        return this.inventory[slot];
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70298_a(int slot, int number) {
        if (slot >= this.func_70302_i_()) {
            return null;
        }
        ItemStack itemStack = null;
        if (this.inventory[slot] != null) {
            number = Math.min(number, this.inventory[slot].field_77994_a);
            itemStack = this.inventory[slot].func_77979_a(number);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        if (slot >= this.func_70302_i_()) {
            return null;
        }
        ItemStack itemstack = null;
        if (this.inventory[slot] != null) {
            itemstack = this.inventory[slot];
            this.inventory[slot] = null;
        }
        return itemstack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot >= this.func_70302_i_()) {
            // empty if block
        }
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public void func_70295_k_() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
    }

    public void func_70305_f() {
        if (this.func_145838_q() != null && this.func_145838_q() == this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            --this.numUsingPlayers;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        }
    }

    public boolean func_145842_c(int idEvent, int value) {
        if (idEvent == 1) {
            this.numUsingPlayers = value;
            return true;
        }
        return super.func_145842_c(idEvent, value);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        boolean rtn = false;
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this) {
            rtn = par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
        }
        return rtn;
    }

    public void func_145843_s() {
        this.func_145836_u();
        super.func_145843_s();
    }

    protected void playSoundClosedInventory() {
        double x = (double)this.field_145851_c + 0.5;
        double y = (double)this.field_145848_d + 0.5;
        double z = (double)this.field_145849_e + 0.5;
        this.field_145850_b.func_72908_a(x, y, z, this.soundClosedInventory, this.volumeSoundOpenClosedInventory, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    protected void playSoundOpenInventory() {
        double x = (double)this.field_145851_c + 0.5;
        double y = (double)this.field_145848_d + 0.5;
        double z = (double)this.field_145849_e + 0.5;
        this.field_145850_b.func_72908_a(x, y, z, this.soundOpenInventory, this.volumeSoundOpenClosedInventory, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.prevDoorOpenProgress = this.doorOpenProgress;
        if (this.numUsingPlayers > 0 && this.doorOpenProgress == 0.0f && this.playSoundChest) {
            this.playSoundOpenInventory();
        }
        if (this.numUsingPlayers == 0 && this.doorOpenProgress > 0.0f || this.numUsingPlayers > 0 && this.doorOpenProgress < 1.0f) {
            this.doorOpenProgress = this.numUsingPlayers > 0 ? (this.doorOpenProgress += this.doorSpeed) : (this.doorOpenProgress -= this.doorSpeed);
            this.doorOpenProgress = this.doorOpenProgress > 1.0f ? 1.0f : this.doorOpenProgress;
            float f = this.doorOpenProgress = this.doorOpenProgress < 0.0f ? 0.0f : this.doorOpenProgress;
            if (this.doorOpenProgress < 0.7f && this.prevDoorOpenProgress >= 0.7f && this.playSoundChest) {
                this.playSoundClosedInventory();
            }
        }
    }

    protected void readItems(NBTTagCompound nbtTagCompound, String tagName) {
        this.readItems(nbtTagCompound, tagName, false);
    }

    protected void readItems(NBTTagCompound nbtTagCompound, String tagName, boolean merge) {
        if (!nbtTagCompound.func_74764_b(tagName)) {
            return;
        }
        NBTTagList nbttaglist = nbtTagCompound.func_150295_c(tagName, 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            try {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                byte j = nbttagcompound.func_74771_c("Slot");
                if (j < 0 || j >= this.inventory.length) continue;
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
                if (merge && itemStack == null) continue;
                this.inventory[j] = itemStack;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory = new ItemStack[this.maxSize];
        this.readItems(nbtTagCompound, "Items");
    }

    protected void writeItems(NBTTagCompound nbtTagCompound, String tagName, ItemStack[] inventory) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound subNBTTagCompound = new NBTTagCompound();
            subNBTTagCompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(subNBTTagCompound);
            nbttaglist.func_74742_a((NBTBase)subNBTTagCompound);
        }
        nbtTagCompound.func_74782_a(tagName, (NBTBase)nbttaglist);
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.writeItems(nbtTagCompound, "Items", this.inventory);
    }

    public GCLInventoryTileEntity setDoorSpeed(float doorSpeed) {
        this.doorSpeed = doorSpeed;
        return this;
    }

    public float getDoorOpenProgress() {
        return this.doorOpenProgress;
    }

    public float getPreviousDoorOpenProgress() {
        return this.prevDoorOpenProgress;
    }
}

