/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.client.gui.config.entry;

import com.gollum.core.client.gui.config.GuiConfigEntries;
import com.gollum.core.client.gui.config.element.ConfigElement;
import com.gollum.core.client.gui.config.entry.ConfigEntry;
import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.client.config.GuiUtils;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;

public class BuildingEntryTab
extends ConfigEntry {
    private String selected = "";
    public int index = 0;
    private TreeMap<String, GuiButtonExt> values = new TreeMap();
    private GuiButtonExt btnPrev;
    private GuiButtonExt btnNext;
    private GuiButtonExt btnAdd;
    private GuiButtonExt btnRemove;
    private boolean modalEnabled = false;
    private GuiButtonExt btnAddDone;
    private ConfigEntry addEntry;

    public BuildingEntryTab(int index, Minecraft mc, GuiConfigEntries parent, ConfigElement configElement) {
        super(index, mc, parent, configElement);
        this.setValue(configElement.getValue());
        this.setIndex0();
        this.init();
    }

    private void init() {
        this.btnPrev = new GuiButtonExt(0, 0, 0, 10, 18, "<");
        this.btnNext = new GuiButtonExt(0, 0, 0, 10, 18, ">");
        this.btnAdd = new GuiButtonExt(0, 0, 0, 18, 18, "+");
        this.btnRemove = new GuiButtonExt(0, 0, 0, 18, 18, "x");
        this.btnAdd.packedFGColour = GuiUtils.getColorCode((char)'2', (boolean)true);
        this.btnRemove.packedFGColour = GuiUtils.getColorCode((char)'c', (boolean)true);
        this.btnAddDone = new GuiButtonExt(0, 0, 0, this.mc.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])) + 10, 18, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.addEntry = this.createSubEntry("", 0, 0, 0);
        this.addEntry.btUndoIsVisible = false;
        this.addEntry.btResetIsVisible = false;
    }

    @Override
    public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected, boolean resetControlWidth) {
        super.drawEntry(slotIndex, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected, resetControlWidth);
        if (this.modalEnabled) {
            this.btnAddDone.field_146128_h = this.parent.controlX + this.parent.controlWidth - this.btnAddDone.field_146120_f;
            this.btnAddDone.field_146129_i = y;
            this.btnAddDone.func_146112_a(this.mc, mouseX, mouseY);
            this.parent.controlWidth -= this.btnAddDone.field_146120_f;
            this.addEntry.drawEntry(0, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected, false);
            this.parent.controlWidth += this.btnAddDone.field_146120_f;
        } else {
            this.btnPrev.field_146124_l = this.index != 0;
            this.btnPrev.field_146128_h = this.parent.controlX;
            this.btnPrev.field_146129_i = y;
            this.btnPrev.func_146112_a(this.mc, mouseX, mouseY);
            int btX = 10;
            int i = 0;
            boolean moreLong = false;
            for (Map.Entry<String, GuiButtonExt> entry : this.values.entrySet()) {
                if (i < this.index) {
                    ++i;
                    continue;
                }
                GuiButtonExt bt = entry.getValue();
                bt.field_146124_l = !bt.field_146126_j.equals(this.selected);
                bt.field_146124_l = !bt.field_146124_l;
                bt.field_146128_h = this.parent.controlX + btX;
                bt.field_146129_i = y;
                bt.func_146112_a(this.mc, mouseX, mouseY);
                boolean bl = bt.field_146124_l = !bt.field_146124_l;
                if (!bt.field_146124_l) {
                    this.drawRec(bt.field_146128_h + 1, y + 15, 1, 3, -8487298);
                    this.drawRec(bt.field_146128_h + 2, y + 15, bt.field_146120_f - 3, 3, -11382190);
                    this.drawRec(bt.field_146128_h + bt.field_146120_f - 2, y + 15, 1, 3, -12632257);
                }
                if (moreLong = this.parent.controlX + (btX += bt.field_146120_f - 1) > this.parent.controlX + this.parent.controlWidth - 48) break;
                ++i;
            }
            this.btnNext.field_146124_l = moreLong;
            this.btnNext.field_146128_h = this.parent.controlX + this.parent.controlWidth - 48;
            this.btnNext.field_146129_i = y;
            this.btnNext.func_146112_a(this.mc, mouseX, mouseY);
            this.btnAdd.field_146128_h = this.parent.controlX + this.parent.controlWidth - 18;
            this.btnAdd.field_146129_i = y;
            this.btnAdd.func_146112_a(this.mc, mouseX, mouseY);
            this.btnRemove.field_146128_h = this.parent.controlX + this.parent.controlWidth - 37;
            this.btnRemove.field_146129_i = y;
            this.btnRemove.func_146112_a(this.mc, mouseX, mouseY);
        }
    }

    @Override
    public Object getValue() {
        super.getValue();
        return this.values.keySet().toArray(new String[0]);
    }

    @Override
    public ConfigEntry setValue(Object values) {
        this.values.clear();
        for (String value : (String[])values) {
            this.addValues(value);
        }
        return super.setValue(values);
    }

    public ConfigEntry addValues(String value) {
        this.values.put(value, new GuiButtonExt(0, this.parent.controlX, 0, this.mc.field_71466_p.func_78256_a(value) + 10, 18, value));
        this.select(value);
        return this;
    }

    private void prev() {
        --this.index;
        if (this.index < 0) {
            this.index = 0;
        }
    }

    private void next() {
        ++this.index;
    }

    private void remove() {
        if (this.values.containsKey(this.selected)) {
            this.values.remove(this.selected);
        }
        this.setIndex0();
    }

    public void setIndex0() {
        this.index = 0;
        if (this.values.size() > 0) {
            this.select(this.values.firstKey());
            return;
        }
        this.select(null);
    }

    public void select(String value) {
        this.selected = value;
        this.fireEvent(ConfigEntry.Event.Type.CHANGE, new Object[0]);
    }

    public String getSelected() {
        return this.selected;
    }

    @Override
    public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        if (this.modalEnabled) {
            if (this.btnAddDone.func_146116_c(this.mc, x, y)) {
                this.btnAddDone.func_146113_a(this.mc.func_147118_V());
                this.modalEnabled = false;
                String tab = this.addEntry.getValue().toString().trim();
                this.addValues(tab);
                return true;
            }
            if (this.addEntry.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY)) {
                return true;
            }
        } else {
            if (this.btnNext.func_146116_c(this.mc, x, y)) {
                this.btnNext.func_146113_a(this.mc.func_147118_V());
                this.next();
                return true;
            }
            if (this.btnPrev.func_146116_c(this.mc, x, y)) {
                this.btnPrev.func_146113_a(this.mc.func_147118_V());
                this.prev();
                return true;
            }
            if (this.btnAdd.func_146116_c(this.mc, x, y)) {
                this.btnAdd.func_146113_a(this.mc.func_147118_V());
                this.modalEnabled = true;
                return true;
            }
            if (this.btnRemove.func_146116_c(this.mc, x, y)) {
                this.btnRemove.func_146113_a(this.mc.func_147118_V());
                this.remove();
                return true;
            }
            for (Map.Entry<String, GuiButtonExt> entry : this.values.entrySet()) {
                GuiButtonExt bt = entry.getValue();
                if (!bt.func_146116_c(this.mc, x, y)) continue;
                bt.func_146113_a(this.mc.func_147118_V());
                this.select(bt.field_146126_j);
                return true;
            }
        }
        return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
    }

    @Override
    public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        if (this.modalEnabled) {
            this.btnAddDone.func_146118_a(x, y);
            this.addEntry.func_148277_b(index, x, y, mouseEvent, relativeX, relativeY);
        } else {
            this.btnNext.func_146118_a(x, y);
            this.btnPrev.func_146118_a(x, y);
        }
    }
}

