/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.client.gui.config.element;

import com.gollum.core.client.gui.config.entry.ArrayEntry;
import com.gollum.core.client.gui.config.entry.BlockEntry;
import com.gollum.core.client.gui.config.entry.BooleanEntry;
import com.gollum.core.client.gui.config.entry.ByteEntry;
import com.gollum.core.client.gui.config.entry.ConfigEntry;
import com.gollum.core.client.gui.config.entry.ConfigJsonTypeEntry;
import com.gollum.core.client.gui.config.entry.DoubleEntry;
import com.gollum.core.client.gui.config.entry.FloatEntry;
import com.gollum.core.client.gui.config.entry.IntegerEntry;
import com.gollum.core.client.gui.config.entry.ItemEntry;
import com.gollum.core.client.gui.config.entry.JsonEntry;
import com.gollum.core.client.gui.config.entry.JsonObjectEntry;
import com.gollum.core.client.gui.config.entry.ListEntry;
import com.gollum.core.client.gui.config.entry.ListInlineEntry;
import com.gollum.core.client.gui.config.entry.LongEntry;
import com.gollum.core.client.gui.config.entry.ModIdEntry;
import com.gollum.core.client.gui.config.entry.ShortEntry;
import com.gollum.core.client.gui.config.entry.SliderEntry;
import com.gollum.core.client.gui.config.entry.StringEntry;
import com.gollum.core.common.config.ConfigProp;
import com.gollum.core.common.config.JsonConfigProp;
import com.gollum.core.common.config.type.ConfigJsonType;
import com.gollum.core.tools.simplejson.Json;
import java.util.Set;

public abstract class ConfigElement {
    private String name;
    protected Object value = null;
    protected Object defaultValue = null;
    public static final double DOUBLE_MAX = 9999999.0;
    public static final double DOUBLE_MIN = -9999999.0;
    public static final float FLOAT_MAX = 99999.0f;
    public static final float FLOAT_MIN = -99999.0f;

    public ConfigElement(String name) {
        this.name = name;
    }

    public abstract ConfigProp getConfigProp();

    public Class<? extends ConfigEntry> getEntryClass() {
        return this.getEntryClass(this.getType());
    }

    private Class<? extends ConfigEntry> getEntryClass(Class clazz) {
        ConfigProp prop = this.getConfigProp();
        if (!prop.entryClass().equals("")) {
            try {
                return Class.forName(prop.entryClass());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (clazz == null) {
            return null;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return JsonObjectEntry.class;
        }
        if (Json.class.isAssignableFrom(clazz)) {
            return JsonEntry.class;
        }
        if (ConfigJsonType.class.isAssignableFrom(clazz)) {
            return ConfigJsonTypeEntry.class;
        }
        if (String.class.isAssignableFrom(clazz)) {
            if (prop.type() == ConfigProp.Type.LIST_INLINE) {
                return ListInlineEntry.class;
            }
            if (prop.validValues() != null && (prop.validValues().length > 1 || prop.validValues().length == 1 && !prop.validValues()[0].equals(""))) {
                return ListEntry.class;
            }
            if (prop.type() == ConfigProp.Type.MOD) {
                return ModIdEntry.class;
            }
            if (prop.type() == ConfigProp.Type.ITEM) {
                return ItemEntry.class;
            }
            if (prop.type() == ConfigProp.Type.BLOCK) {
                return BlockEntry.class;
            }
            return StringEntry.class;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            if (prop.type() == ConfigProp.Type.SLIDER) {
                return SliderEntry.class;
            }
            if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
                return ByteEntry.class;
            }
            if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
                return ShortEntry.class;
            }
            if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
                return IntegerEntry.class;
            }
            if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
                return LongEntry.class;
            }
            if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
                return FloatEntry.class;
            }
            if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
                return DoubleEntry.class;
            }
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return BooleanEntry.class;
        }
        if (clazz.isArray()) {
            return ArrayEntry.class;
        }
        return null;
    }

    public Class getType() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        Object value = this.value;
        try {
            Object cloned;
            value = cloned = value.getClass().getMethod("clone", new Class[0]).invoke(value, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object newValue() {
        block44: {
            Class<?> componentType = this.value.getClass().getComponentType();
            Class<? extends ConfigEntry> clazz = this.getEntryClass(componentType);
            String newValue = this.getConfigProp().newValue();
            if (clazz == StringEntry.class) {
                return newValue;
            }
            if (!newValue.equals("") && clazz != null && ListEntry.class.isAssignableFrom(clazz)) {
                return newValue;
            }
            if (clazz == ConfigJsonTypeEntry.class) {
                try {
                    return componentType.newInstance();
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (clazz == JsonEntry.class) {
                if (this.getConfigProp() instanceof JsonConfigProp) {
                    return ((JsonConfigProp)this.getConfigProp()).newJsonValue();
                }
            } else {
                if (clazz == SliderEntry.class) {
                    try {
                        if (Byte.class.isAssignableFrom(componentType) || Byte.TYPE.isAssignableFrom(componentType)) {
                            return Byte.parseByte(newValue);
                        }
                        if (Short.class.isAssignableFrom(componentType) || Short.TYPE.isAssignableFrom(componentType)) {
                            return Short.parseShort(newValue);
                        }
                        if (Integer.class.isAssignableFrom(componentType) || Integer.TYPE.isAssignableFrom(componentType)) {
                            return Integer.parseInt(newValue);
                        }
                        if (Long.class.isAssignableFrom(componentType) || Long.TYPE.isAssignableFrom(componentType)) {
                            return Long.parseLong(newValue);
                        }
                        if (Float.class.isAssignableFrom(componentType) || Float.TYPE.isAssignableFrom(componentType)) {
                            return Float.valueOf(Float.parseFloat(newValue));
                        }
                        if (Double.class.isAssignableFrom(componentType) || Double.TYPE.isAssignableFrom(componentType)) {
                            return Double.parseDouble(newValue);
                        }
                        break block44;
                    }
                    catch (Exception e) {
                        if (Byte.class.isAssignableFrom(componentType) || Byte.TYPE.isAssignableFrom(componentType)) {
                            return (byte)0;
                        }
                        if (Short.class.isAssignableFrom(componentType) || Short.TYPE.isAssignableFrom(componentType)) {
                            return (short)0;
                        }
                        if (Integer.class.isAssignableFrom(componentType) || Integer.TYPE.isAssignableFrom(componentType)) {
                            return 0;
                        }
                        if (Long.class.isAssignableFrom(componentType) || Long.TYPE.isAssignableFrom(componentType)) {
                            return 0L;
                        }
                        if (Float.class.isAssignableFrom(componentType) || Float.TYPE.isAssignableFrom(componentType)) {
                            return 0.0;
                        }
                        if (Double.class.isAssignableFrom(componentType) || Double.TYPE.isAssignableFrom(componentType)) {
                            return Float.valueOf(0.0f);
                        }
                        break block44;
                    }
                }
                if (clazz == LongEntry.class) {
                    try {
                        return Long.parseLong(newValue);
                    }
                    catch (Exception e) {
                        return 0L;
                    }
                }
                if (clazz == IntegerEntry.class) {
                    try {
                        return Integer.parseInt(newValue);
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
                if (clazz == ShortEntry.class) {
                    try {
                        return Short.parseShort(newValue);
                    }
                    catch (Exception e) {
                        return (short)0;
                    }
                }
                if (clazz == ByteEntry.class) {
                    try {
                        return Byte.parseByte(newValue);
                    }
                    catch (Exception e) {
                        return (byte)0;
                    }
                }
                if (clazz == DoubleEntry.class) {
                    try {
                        return Double.parseDouble(newValue);
                    }
                    catch (Exception e) {
                        return 0.0;
                    }
                }
                if (clazz == FloatEntry.class) {
                    try {
                        return Float.valueOf(Float.parseFloat(newValue));
                    }
                    catch (Exception e) {
                        return Float.valueOf(0.0f);
                    }
                }
                if (clazz == BooleanEntry.class) {
                    try {
                        return Boolean.parseBoolean(newValue);
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
        }
        return null;
    }

    public ConfigElement setValue(Object value) {
        this.value = value;
        return this;
    }

    public ConfigElement setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMin() {
        Number min = null;
        String str = this.getConfigProp().minValue();
        Class<? extends ConfigEntry> clazz = this.getEntryClass();
        if (str != null && !str.equals("")) {
            try {
                min = DoubleEntry.class.isAssignableFrom(clazz) || SliderEntry.class.isAssignableFrom(clazz) ? (Number)Double.parseDouble(str) : (Number)Long.parseLong(str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (min == null) {
            if (clazz == SliderEntry.class) {
                Class<?> clazz2 = this.getValue().getClass();
                if (Double.class.isAssignableFrom(clazz2)) return -9999999.0;
                if (Double.TYPE.isAssignableFrom(clazz2)) {
                    return -9999999.0;
                }
                if (Float.class.isAssignableFrom(clazz2)) return new Double(-99999.0);
                if (Float.TYPE.isAssignableFrom(clazz2)) {
                    return new Double(-99999.0);
                }
                if (Long.class.isAssignableFrom(clazz2)) return -9999999.0;
                if (Long.TYPE.isAssignableFrom(clazz2)) {
                    return -9999999.0;
                }
                if (Integer.class.isAssignableFrom(clazz2)) return new Double(-99999.0);
                if (Integer.TYPE.isAssignableFrom(clazz2)) {
                    return new Double(-99999.0);
                }
                if (Short.class.isAssignableFrom(clazz2)) return new Double(-32768.0);
                if (Short.TYPE.isAssignableFrom(clazz2)) {
                    return new Double(-32768.0);
                }
                if (Byte.class.isAssignableFrom(clazz2)) return new Double(-128.0);
                if (!Byte.TYPE.isAssignableFrom(clazz2)) return min;
                return new Double(-128.0);
            }
            if (clazz == DoubleEntry.class) {
                return new Double(-9999999.0);
            }
            if (clazz == FloatEntry.class) {
                return new Double(-99999.0);
            }
            if (clazz == LongEntry.class) {
                return Long.MIN_VALUE;
            }
            if (clazz == IntegerEntry.class) {
                return Integer.MIN_VALUE;
            }
            if (clazz == ShortEntry.class) {
                return -32768L;
            }
            if (clazz != ByteEntry.class) return min;
            return -128L;
        }
        if (clazz == SliderEntry.class) {
            Class<?> clazz2 = this.getValue().getClass();
            if (Double.class.isAssignableFrom(clazz2) || Double.TYPE.isAssignableFrom(clazz2)) {
                if ((Double)min < -9999999.0) {
                    return -9999999.0;
                }
            }
            if (Float.class.isAssignableFrom(clazz2) || Float.TYPE.isAssignableFrom(clazz2)) {
                if ((Double)min < -99999.0) {
                    return new Double(-99999.0);
                }
            }
            if (Long.class.isAssignableFrom(clazz2) || Long.TYPE.isAssignableFrom(clazz2)) {
                if ((Double)min < -9999999.0) {
                    return new Double(-9999999.0);
                }
            }
            if (Integer.class.isAssignableFrom(clazz2) || Integer.TYPE.isAssignableFrom(clazz2)) {
                if ((Double)min < -99999.0) {
                    return new Double(-99999.0);
                }
            }
            if (Short.class.isAssignableFrom(clazz2)) return new Double(-32768.0);
            if (Short.TYPE.isAssignableFrom(clazz2) && (Double)min < -32768.0) {
                return new Double(-32768.0);
            }
            if (!Byte.class.isAssignableFrom(clazz2)) {
                if (!Byte.TYPE.isAssignableFrom(clazz2)) return min;
            }
            if (!((Double)min < -128.0)) return min;
            return new Double(-128.0);
        }
        if (clazz == DoubleEntry.class) {
            if ((Double)min < -9999999.0) {
                return new Double(-9999999.0);
            }
        }
        if (clazz == FloatEntry.class) {
            if ((Double)min < -99999.0) {
                return new Double(-99999.0);
            }
        }
        if (clazz == LongEntry.class && (Long)min < Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (clazz == IntegerEntry.class && (Long)min < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (clazz == ShortEntry.class && (Long)min < -32768L) {
            return -32768L;
        }
        if (clazz != ByteEntry.class) return min;
        if ((Long)min >= -128L) return min;
        return -128L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMax() {
        Number max = null;
        String str = this.getConfigProp().maxValue();
        Class<? extends ConfigEntry> clazz = this.getEntryClass();
        if (str != null && !str.equals("")) {
            try {
                max = DoubleEntry.class.isAssignableFrom(clazz) ? (Number)Double.parseDouble(str) : (Number)Long.parseLong(str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (max == null) {
            if (clazz == SliderEntry.class) {
                Class<?> clazz2 = this.getValue().getClass();
                if (Double.class.isAssignableFrom(clazz2)) return 9999999.0;
                if (Double.TYPE.isAssignableFrom(clazz2)) {
                    return 9999999.0;
                }
                if (Float.class.isAssignableFrom(clazz2)) return new Double(99999.0);
                if (Float.TYPE.isAssignableFrom(clazz2)) {
                    return new Double(99999.0);
                }
                if (Long.class.isAssignableFrom(clazz2)) return 9999999.0;
                if (Long.TYPE.isAssignableFrom(clazz2)) {
                    return 9999999.0;
                }
                if (Integer.class.isAssignableFrom(clazz2)) return new Double(99999.0);
                if (Integer.TYPE.isAssignableFrom(clazz2)) {
                    return new Double(99999.0);
                }
                if (Short.class.isAssignableFrom(clazz2)) return new Double(32767.0);
                if (Short.TYPE.isAssignableFrom(clazz2)) {
                    return new Double(32767.0);
                }
                if (Byte.class.isAssignableFrom(clazz2)) return new Double(127.0);
                if (!Byte.TYPE.isAssignableFrom(clazz2)) return max;
                return new Double(127.0);
            }
            if (clazz == DoubleEntry.class) {
                return new Double(9999999.0);
            }
            if (clazz == FloatEntry.class) {
                return new Double(99999.0);
            }
            if (clazz == LongEntry.class) {
                return Long.MAX_VALUE;
            }
            if (clazz == IntegerEntry.class) {
                return Integer.MAX_VALUE;
            }
            if (clazz == ShortEntry.class) {
                return 32767L;
            }
            if (clazz != ByteEntry.class) return max;
            return 127L;
        }
        if (clazz == SliderEntry.class) {
            Class<?> clazz2 = this.getValue().getClass();
            if (Double.class.isAssignableFrom(clazz2) || Double.TYPE.isAssignableFrom(clazz2)) {
                if ((Double)max > 9999999.0) {
                    return 9999999.0;
                }
            }
            if (Float.class.isAssignableFrom(clazz2) || Float.TYPE.isAssignableFrom(clazz2)) {
                if ((Double)max > 99999.0) {
                    return new Double(99999.0);
                }
            }
            if (Long.class.isAssignableFrom(clazz2) || Long.TYPE.isAssignableFrom(clazz2)) {
                if ((double)((Long)max).longValue() > 9999999.0) {
                    return 9999999.0;
                }
            }
            if (Integer.class.isAssignableFrom(clazz2) || Integer.TYPE.isAssignableFrom(clazz2)) {
                if ((float)((Long)max).longValue() > 99999.0f) {
                    return new Double(2.147483647E9);
                }
            }
            if (Short.class.isAssignableFrom(clazz2)) return new Double(32767.0);
            if (Short.TYPE.isAssignableFrom(clazz2) && (Long)max > 32767L) {
                return new Double(32767.0);
            }
            if (!Byte.class.isAssignableFrom(clazz2)) {
                if (!Byte.TYPE.isAssignableFrom(clazz2)) return max;
            }
            if ((Long)max <= 127L) return max;
            return new Double(127.0);
        }
        if (clazz == DoubleEntry.class) {
            if ((Double)max > 9999999.0) {
                return new Double(9999999.0);
            }
        }
        if (clazz == FloatEntry.class) {
            if ((Double)max > 99999.0) {
                return new Double(99999.0);
            }
        }
        if (clazz == LongEntry.class && (Long)max > Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        if (clazz == IntegerEntry.class && (Long)max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (clazz == ShortEntry.class && (Long)max > 32767L) {
            return 32767L;
        }
        if (clazz != ByteEntry.class) return max;
        if ((Long)max <= 127L) return max;
        return 127L;
    }
}

