/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.registry;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.tools.helper.IItemHelper;
import com.gollum.core.tools.registered.RegisteredObjects;
import com.gollum.core.utils.reflection.Reflection;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.RegistryNamespaced;
import net.minecraft.util.RegistrySimple;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ItemRegistry {
    private static ItemRegistry instance = new ItemRegistry();
    private ArrayList<IItemHelper> items = new ArrayList();

    public static ItemRegistry instance() {
        return instance;
    }

    public void add(IItemHelper item) {
        if (!this.items.contains(item)) {
            this.items.add(item);
        }
    }

    public void registerAll() {
        for (IItemHelper item : this.items) {
            item.register();
        }
        this.items.clear();
    }

    public void overrideItemsClassField(Item vanillaItem, Item item) {
        try {
            Field field = null;
            for (Field f : Items.class.getFields()) {
                f.setAccessible(true);
                if (!Modifier.isStatic(f.getModifiers()) || f.get(null) != vanillaItem) continue;
                field = f;
            }
            if (field == null) {
                throw new Exception("This item \"" + vanillaItem.getClass().getName() + "\" not found in fields " + Items.class.getName());
            }
            this.overrideItemsClassField(field.getName(), item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void overrideItemsClassField(String fieldName, Item item) {
        try {
            Reflection.setFinalStatic(Items.class.getDeclaredField(fieldName), item);
            ModGollumCoreLib.log.message("Override Items field fieldName=\"" + fieldName + "\" by " + item.getClass().getSimpleName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void overrideRegistered(String registerName, Item item) {
        block8: {
            try {
                Item vanillaItem = RegisteredObjects.instance().getItem(registerName);
                if (vanillaItem != null) {
                    ModGollumCoreLib.log.message("Override registery item \"" + registerName + "\" by " + item.getClass().getSimpleName());
                    FMLControlledNamespacedRegistry itemRegistry = GameData.getItemRegistry();
                    Field f1 = null;
                    try {
                        f1 = RegistrySimple.class.getDeclaredField("field_82596_a");
                    }
                    catch (Exception e) {
                        ModGollumCoreLib.log.message("Unofuscate property RegistrySimple : field_82596_a => registryObjects");
                        f1 = RegistrySimple.class.getDeclaredField("registryObjects");
                    }
                    f1.setAccessible(true);
                    Map registryObjects = (Map)f1.get(itemRegistry);
                    registryObjects.put(registerName, item);
                    ModGollumCoreLib.log.debug(" 1 - Replace \"" + registerName + "\" registery : registryObjects");
                    Field f2 = null;
                    try {
                        f2 = RegistryNamespaced.class.getDeclaredField("field_148759_a");
                    }
                    catch (Exception e) {
                        ModGollumCoreLib.log.message("Unofuscate property RegistrySimple : field_148759_a => underlyingIntegerMap");
                        f2 = RegistryNamespaced.class.getDeclaredField("underlyingIntegerMap");
                    }
                    f2.setAccessible(true);
                    ObjectIntIdentityMap underlyingIntegerMap = (ObjectIntIdentityMap)f2.get(itemRegistry);
                    int id = underlyingIntegerMap.func_148747_b((Object)vanillaItem);
                    if (id == -1) {
                        throw new Exception(" 2 - Replace \"" + registerName + "\" registery is KO because id not found");
                    }
                    underlyingIntegerMap.func_148746_a((Object)item, id);
                    ModGollumCoreLib.log.debug(" 2 - Replace \"" + registerName + "\" registery : underlyingIntegerMap id=" + id);
                    this.overrideStatItem(StatList.objectMineStats, item, vanillaItem);
                    this.overrideStatItem(StatList.itemStats, item, vanillaItem);
                    this.overrideStatItem(StatList.objectBreakStats, item, vanillaItem);
                    ModGollumCoreLib.log.debug(" 3 - Replace \"" + registerName + "\" stats");
                    this.overrideCraftings(item, vanillaItem);
                    ModGollumCoreLib.log.debug(" 4 - Replace \"" + registerName + "\" crafting");
                    break block8;
                }
                ModGollumCoreLib.log.severe("The original item \"" + registerName + "\" not found for replace registery.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void overrideCraftings(Item item, Item vanillaItem) {
        for (Object o : CraftingManager.getInstance().getRecipeList()) {
            ItemStack is;
            ShapedRecipes recipes;
            if (o instanceof ShapedRecipes) {
                recipes = (ShapedRecipes)o;
                if (recipes.getRecipeOutput().getItem() == vanillaItem) {
                    ModGollumCoreLib.log.debug(" 4 - Block found in ShapedRecipes out");
                    recipes.getRecipeOutput().func_150996_a(item);
                }
                for (int i = 0; i < recipes.recipeItems.length; ++i) {
                    ItemStack is2 = recipes.recipeItems[i];
                    if (is2 == null || is2.getItem() != vanillaItem) continue;
                    ModGollumCoreLib.log.debug(" 4 - Block found in ShapedRecipes");
                    is2.func_150996_a(item);
                }
                continue;
            }
            if (o instanceof ShapelessRecipes) {
                recipes = (ShapelessRecipes)o;
                if (recipes.getRecipeOutput().getItem() == vanillaItem) {
                    recipes.getRecipeOutput().func_150996_a(item);
                    ModGollumCoreLib.log.debug(" 4 - Block found in ShapelessRecipes out");
                }
                for (Object subO : recipes.recipeItems) {
                    if (!(subO instanceof ItemStack) || (is = (ItemStack)subO) == null || is.getItem() != vanillaItem) continue;
                    ModGollumCoreLib.log.debug(" 4 - Block found in ShapelessRecipes");
                    is.func_150996_a(item);
                }
                continue;
            }
            if (o instanceof ShapedOreRecipe) {
                recipes = (ShapedOreRecipe)o;
                if (recipes.getRecipeOutput().getItem() == vanillaItem) {
                    recipes.getRecipeOutput().func_150996_a(item);
                    ModGollumCoreLib.log.debug(" 4 - Block found in ShapedOreRecipe out");
                }
                Object[] subList = recipes.getInput();
                for (int i = 0; i < subList.length; ++i) {
                    if (!(subList[i] instanceof ItemStack) || (is = (ItemStack)subList[i]) == null || is.getItem() != vanillaItem) continue;
                    ModGollumCoreLib.log.debug(" 4 - Block found in ShapedOreRecipe");
                    is.func_150996_a(item);
                }
                continue;
            }
            if (!(o instanceof ShapelessOreRecipe)) continue;
            recipes = (ShapelessOreRecipe)o;
            if (recipes.getRecipeOutput().getItem() == vanillaItem) {
                recipes.getRecipeOutput().func_150996_a(item);
                ModGollumCoreLib.log.debug(" 4 - Block found in ShapelessOreRecipe out");
            }
            for (Object subO : recipes.getInput()) {
                if (!(subO instanceof ItemStack) || (is = (ItemStack)subO) == null || is.getItem() != vanillaItem) continue;
                ModGollumCoreLib.log.debug(" 4 - Block found in ShapelessOreRecipe");
                is.func_150996_a(item);
            }
        }
    }

    private void overrideStatItem(StatBase[] itemStats, Item item, Item vanillaItem) throws Exception {
        for (int i = 0; i < itemStats.length; ++i) {
            if (!(itemStats[i] instanceof StatCrafting)) continue;
            StatCrafting stat = (StatCrafting)itemStats[i];
            Field f = StatCrafting.class.getDeclaredField("field_150960_a");
            f.setAccessible(true);
            Item subItem = (Item)f.get(stat);
            if (subItem != vanillaItem) continue;
            f.set(stat, item);
        }
    }

    private void overrideStatItem(List itemStats, Item item, Item vanillaItem) throws Exception {
        for (StatCrafting stat : itemStats) {
            Field f = StatCrafting.class.getDeclaredField("field_150960_a");
            f.setAccessible(true);
            Item subItem = (Item)f.get(stat);
            if (subItem != vanillaItem) continue;
            f.set(stat, item);
        }
    }
}

