/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.helper;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.context.ModContext;
import com.gollum.core.common.mod.GollumMod;
import com.gollum.core.tools.helper.IItemHelper;
import com.gollum.core.tools.helper.items.HItem;
import com.gollum.core.tools.registry.ItemRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;

public class ItemHelper
implements IItemHelper {
    public boolean vanillaRegister = false;
    public boolean vanillaTexture = false;
    protected GollumMod mod;
    protected Item parent;
    protected String registerName;

    public ItemHelper(Item item, String registerName) {
        this.parent = item;
        this.registerName = registerName;
        this.mod = ModContext.instance().getCurrent();
        if (!this.vanillaRegister) {
            ItemRegistry.instance().add((HItem)this.parent);
        }
    }

    @Override
    public ItemHelper getGollumHelper() {
        return this;
    }

    @Override
    public void register() {
        this.parent.setUnlocalizedName(this.registerName);
        GameRegistry.registerItem((Item)this.parent, (String)this.getRegisterName(), (String)this.mod.getModId());
    }

    @Override
    public String getRegisterName() {
        return this.registerName;
    }

    @Override
    public String getTextureKey() {
        return ((IItemHelper)this.parent).getRegisterName().toLowerCase();
    }

    public IIcon loadTexture(IIconRegister iconRegister) {
        return this.loadTexture(iconRegister, "");
    }

    public IIcon loadTexture(IIconRegister iconRegister, String sufixe) {
        return this.loadTexture(iconRegister, sufixe, false);
    }

    public IIcon loadTexture(IIconRegister iconRegister, String sufixe, boolean dontUseTextureKey) {
        String key = (dontUseTextureKey ? "" : ((IItemHelper)this.parent).getTextureKey()) + sufixe;
        String texture = this.mod.getModId().toLowerCase() + ":" + key;
        ModGollumCoreLib.log.debug("Register icon " + texture + "\"");
        return iconRegister.registerIcon(texture);
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        ((IItemHelper)this.parent).setIcon(this.loadTexture(iconRegister));
    }

    @Override
    public void setIcon(IIcon icon) {
        ModGollumCoreLib.log.warning("setIcon don't be call by helper. It's stub");
    }
}

