/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.helper;

import com.gollum.core.tools.helper.BlockHelper;
import com.gollum.core.tools.helper.IBlockMetadataHelper;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockMetadataHelper
extends BlockHelper
implements IBlockMetadataHelper {
    protected TreeSet<Integer> listSubEnabled = new TreeSet();
    public TreeMap<Integer, IIcon> blockIcons = new TreeMap();

    public BlockMetadataHelper(Block parent, String registerName) {
        super(parent, registerName);
        this.listSubEnabled.clear();
        for (int metadata = 0; metadata < 16; ++metadata) {
            this.listSubEnabled.add(metadata);
        }
    }

    public BlockMetadataHelper(Block parent, String registerName, int[] listSubBlock) {
        this(parent, registerName);
        this.listSubEnabled.clear();
        for (int metadata : listSubBlock) {
            this.listSubEnabled.add(metadata);
        }
    }

    public BlockMetadataHelper(Block parent, String registerName, int numberSubBlock) {
        this(parent, registerName);
        this.listSubEnabled.clear();
        for (int metadata = 0; metadata < numberSubBlock; ++metadata) {
            this.listSubEnabled.add(metadata);
        }
    }

    @Override
    public BlockMetadataHelper getGollumHelperMetadata() {
        return this;
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs ctabs, List list) {
        for (int metadata : this.listSubEnabled) {
            list.add(new ItemStack(item, 1, metadata));
        }
    }

    @Override
    public int damageDropped(int dammage) {
        return this.getEnabledMetadata(dammage);
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.parent.getPickBlock(target, world, x, y, z);
    }

    public ItemStack getPickBlock(ItemStack is, World world, int x, int y, int z) {
        if (is == null) {
            return null;
        }
        int dammage = this.parent.getDamageValue(world, x, y, z);
        return new ItemStack(is.getItem(), 1, this.getEnabledMetadata(dammage));
    }

    @Override
    public TreeSet<Integer> listSubEnabled() {
        return this.listSubEnabled;
    }

    @Override
    public int getEnabledMetadata(int dammage) {
        int lastSubblock = -1;
        for (Integer metadata : this.listSubEnabled) {
            if (metadata > dammage) break;
            lastSubblock = metadata;
        }
        return lastSubblock == -1 ? dammage : lastSubblock;
    }

    @Override
    public void registerBlockIcons(IIconRegister iconRegister) {
        for (int metadata : this.listSubEnabled) {
            this.blockIcons.put(metadata, this.loadTexture(iconRegister, "_" + metadata));
        }
    }

    @Override
    public IIcon getIcon(int side, int metadata) {
        int subBlock = this.getEnabledMetadata(metadata);
        if (this.blockIcons.containsKey(subBlock)) {
            return this.blockIcons.get(subBlock);
        }
        return null;
    }
}

