/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.worldgenerator;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.building.Builder;
import com.gollum.core.common.building.Building;
import com.gollum.core.common.events.BuildingGenerateEvent;
import com.gollum.core.utils.math.Integer3d;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;

public class WorldGeneratorByBuilding
implements IWorldGenerator {
    private static final int ARROUND_CHUNK_NOBUILDING = 6;
    private static ArrayList<String> chunkHasABuilding = new ArrayList();
    private Builder builder = new Builder();
    ArrayList<Integer> globalSpawnRate = new ArrayList();
    private HashMap<Integer, HashMap<Integer, ArrayList<Building>>> buildings = new HashMap();

    public int addGroup(int groupSpawnRate) {
        int id = this.globalSpawnRate.size();
        this.globalSpawnRate.add(groupSpawnRate);
        return id;
    }

    public void addBuilding(int idGroup, Building building) {
        for (Map.Entry<Integer, Building.DimentionSpawnInfos> entry : building.dimentionsInfos.entrySet()) {
            int dimensionId = entry.getKey();
            if (!this.buildings.containsKey(dimensionId)) {
                this.buildings.put(dimensionId, new HashMap());
            }
            if (!this.buildings.get(dimensionId).containsKey(idGroup)) {
                this.buildings.get(dimensionId).put(idGroup, new ArrayList());
            }
            this.buildings.get(dimensionId).get(idGroup).add(building);
        }
    }

    public boolean chunkHasBuilding(int chunkX, int chunkZ) {
        return chunkHasABuilding.contains(chunkX + "x" + chunkZ);
    }

    public boolean hasBuildingArround(int chunkX, int chunkZ) {
        for (int x = chunkX - 6; x < chunkX + 6; ++x) {
            for (int z = chunkZ - 6; z < chunkZ + 6; ++z) {
                if (!this.chunkHasBuilding(x, z)) continue;
                return true;
            }
        }
        return false;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        block2: {
            int i2;
            int dimention = world.provider.dimensionId;
            if (!this.buildings.containsKey(dimention)) break block2;
            HashMap<Integer, ArrayList<Building>> buildingsByDim = this.buildings.get(dimention);
            ArrayList<Integer> randomGenerate = new ArrayList<Integer>();
            for (int i2 : buildingsByDim.keySet()) {
                randomGenerate.add(i2);
            }
            Collections.shuffle(randomGenerate);
            Iterator<Integer> i$ = randomGenerate.iterator();
            while (i$.hasNext() && !this.generateBuilding(world, random, chunkX, chunkZ, buildingsByDim.get(i2 = i$.next().intValue()), this.globalSpawnRate.get(i2), dimention)) {
            }
        }
    }

    private boolean generateBuilding(World world, Random random, int chunkX, int chunkZ, ArrayList<Building> buildings, int groupSpawnRate, int dimention) {
        if (buildings.size() == 0) {
            return false;
        }
        float multiplicateur = 2.0f;
        if ((double)random.nextInt((int)(Math.pow(10.0, multiplicateur) * (double)this.globalSpawnRate.size() / 1.5)) < Math.pow(Math.min(groupSpawnRate, 10), multiplicateur)) {
            int rotate = random.nextInt(4);
            Block[] blocksList = new Block[256];
            buildings = (ArrayList)buildings.clone();
            Collections.shuffle(buildings);
            if (!this.hasBuildingArround(chunkX, chunkZ)) {
                for (Building building : buildings) {
                    int initY;
                    if (building == null) continue;
                    Building.DimentionSpawnInfos dimentionsInfos = building.dimentionsInfos.get(dimention);
                    int strengSpawn = random.nextInt(600);
                    if (strengSpawn >= dimentionsInfos.spawnRate) continue;
                    int initX = chunkX * 16 + random.nextInt(8) - random.nextInt(8);
                    int initZ = chunkZ * 16 + random.nextInt(8) - random.nextInt(8);
                    if (dimentionsInfos.spawnMax < dimentionsInfos.spawnMin) continue;
                    for (initY = dimentionsInfos.spawnMax; initY >= dimentionsInfos.spawnMin; --initY) {
                        if (initY > 255 || initY < 3) continue;
                        if (blocksList[initY] == null) {
                            blocksList[initY] = world.getBlock(initX + 3, initY, initZ + 3);
                        }
                        if (blocksList[initY + 1] == null) {
                            blocksList[initY + 1] = world.getBlock(initX + 3, initY + 1, initZ + 3);
                        }
                        Block block = blocksList[initY];
                        Block blockP1 = blocksList[initY + 1];
                        if (block == null || block == Blocks.air || blockP1 != null && blockP1 != Blocks.air || !dimentionsInfos.blocksSpawn.contains(block)) continue;
                        chunkHasABuilding.add(chunkX + "x" + chunkZ);
                        BuildingGenerateEvent.Pre event = new BuildingGenerateEvent.Pre(world, building, rotate, new Integer3d(initX, ++initY, initZ));
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (event.isCanceled()) {
                            return false;
                        }
                        this.builder.build(world, building, rotate, initX, initY, initZ);
                        return true;
                    }
                    if (initY <= dimentionsInfos.spawnMin) continue;
                    ModGollumCoreLib.log.debug("No block found for building " + building.name);
                }
            }
        }
        return false;
    }
}

