/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.tileentities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public abstract class GCLInventoryTileEntity
extends TileEntity
implements IInventory {
    protected ItemStack[] inventory;
    protected int maxSize;
    protected boolean playSoundChest = true;
    protected float volumeSoundOpenClosedInventory = 0.5f;
    protected String soundOpenInventory = "random.chestopen";
    protected String soundClosedInventory = "random.chestclosed";
    private float doorOpenProgress = 0.0f;
    private float prevDoorOpenProgress = 0.0f;
    private float doorSpeed = 0.1f;
    protected int numUsingPlayers;

    public GCLInventoryTileEntity(int maxSize) {
        this.maxSize = maxSize;
        this.inventory = new ItemStack[maxSize];
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.getSizeInventory()) {
            return null;
        }
        return this.inventory[slot];
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public ItemStack decrStackSize(int slot, int number) {
        if (slot >= this.getSizeInventory()) {
            return null;
        }
        ItemStack itemStack = null;
        if (this.inventory[slot] != null) {
            number = Math.min(number, this.inventory[slot].stackSize);
            itemStack = this.inventory[slot].splitStack(number);
            if (this.inventory[slot].stackSize == 0) {
                this.inventory[slot] = null;
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (slot >= this.getSizeInventory()) {
            return null;
        }
        ItemStack itemstack = null;
        if (this.inventory[slot] != null) {
            itemstack = this.inventory[slot];
            this.inventory[slot] = null;
        }
        return itemstack;
    }

    public void setInventorySlotContents(int slot, ItemStack itemStack) {
        if (slot >= this.getSizeInventory()) {
            // empty if block
        }
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
            itemStack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public void openInventory() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, this.numUsingPlayers);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType());
    }

    public void closeInventory() {
        if (this.getBlockType() != null && this.getBlockType() == this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord)) {
            --this.numUsingPlayers;
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, this.numUsingPlayers);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType());
        }
    }

    public boolean receiveClientEvent(int idEvent, int value) {
        if (idEvent == 1) {
            this.numUsingPlayers = value;
            return true;
        }
        return super.receiveClientEvent(idEvent, value);
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemStack) {
        return true;
    }

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        boolean rtn = false;
        if (this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this) {
            rtn = par1EntityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
        }
        return rtn;
    }

    public void invalidate() {
        this.updateContainingBlockInfo();
        super.invalidate();
    }

    protected void playSoundClosedInventory() {
        double x = (double)this.xCoord + 0.5;
        double y = (double)this.yCoord + 0.5;
        double z = (double)this.zCoord + 0.5;
        this.worldObj.playSoundEffect(x, y, z, this.soundClosedInventory, this.volumeSoundOpenClosedInventory, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
    }

    protected void playSoundOpenInventory() {
        double x = (double)this.xCoord + 0.5;
        double y = (double)this.yCoord + 0.5;
        double z = (double)this.zCoord + 0.5;
        this.worldObj.playSoundEffect(x, y, z, this.soundOpenInventory, this.volumeSoundOpenClosedInventory, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
    }

    public void updateEntity() {
        super.updateEntity();
        this.prevDoorOpenProgress = this.doorOpenProgress;
        if (this.numUsingPlayers > 0 && this.doorOpenProgress == 0.0f && this.playSoundChest) {
            this.playSoundOpenInventory();
        }
        if (this.numUsingPlayers == 0 && this.doorOpenProgress > 0.0f || this.numUsingPlayers > 0 && this.doorOpenProgress < 1.0f) {
            this.doorOpenProgress = this.numUsingPlayers > 0 ? (this.doorOpenProgress += this.doorSpeed) : (this.doorOpenProgress -= this.doorSpeed);
            this.doorOpenProgress = this.doorOpenProgress > 1.0f ? 1.0f : this.doorOpenProgress;
            float f = this.doorOpenProgress = this.doorOpenProgress < 0.0f ? 0.0f : this.doorOpenProgress;
            if (this.doorOpenProgress < 0.7f && this.prevDoorOpenProgress >= 0.7f && this.playSoundChest) {
                this.playSoundClosedInventory();
            }
        }
    }

    protected void readItems(NBTTagCompound nbtTagCompound, String tagName) {
        this.readItems(nbtTagCompound, tagName, false);
    }

    protected void readItems(NBTTagCompound nbtTagCompound, String tagName, boolean merge) {
        if (!nbtTagCompound.hasKey(tagName)) {
            return;
        }
        NBTTagList nbttaglist = nbtTagCompound.getTagList(tagName, 10);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            try {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                byte j = nbttagcompound.getByte("Slot");
                if (j < 0 || j >= this.inventory.length) continue;
                ItemStack itemStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound);
                if (merge && itemStack == null) continue;
                this.inventory[j] = itemStack;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.inventory = new ItemStack[this.maxSize];
        this.readItems(nbtTagCompound, "Items");
    }

    protected void writeItems(NBTTagCompound nbtTagCompound, String tagName, ItemStack[] inventory) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound subNBTTagCompound = new NBTTagCompound();
            subNBTTagCompound.setByte("Slot", (byte)i);
            this.inventory[i].writeToNBT(subNBTTagCompound);
            nbttaglist.appendTag((NBTBase)subNBTTagCompound);
        }
        nbtTagCompound.setTag(tagName, (NBTBase)nbttaglist);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        this.writeItems(nbtTagCompound, "Items", this.inventory);
    }

    public GCLInventoryTileEntity setDoorSpeed(float doorSpeed) {
        this.doorSpeed = doorSpeed;
        return this;
    }

    public float getDoorOpenProgress() {
        return this.doorOpenProgress;
    }

    public float getPreviousDoorOpenProgress() {
        return this.prevDoorOpenProgress;
    }
}

