/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.log;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.context.ModContext;
import com.gollum.core.common.log.LogFormatter;
import java.util.Hashtable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.OnStartupTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;

public class Logger {
    private static final String FILE_NAME = "logs/GollumCoreLib.log";
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_MESSAGE = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_SEVERE = 4;
    public static final int LEVEL_NONE = 99;
    private static final LogFormatter formater = new LogFormatter();
    private static int level = 1;
    private static RollingFileAppender fileAppender = null;
    private static Hashtable<String, org.apache.logging.log4j.Logger> loggers = new Hashtable();
    private String modId = ModContext.instance().getCurrent().getModId();

    public static int getLevel() {
        return level;
    }

    public static void setLevelDisplay(int levelDisplay) {
        level = levelDisplay;
    }

    private String implode(Object[] list) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Object s : list) {
            if (i != 0) {
                builder.append(", ");
            }
            if (s == null) {
                builder.append("null");
            } else {
                builder.append(s.toString());
            }
            ++i;
        }
        return builder.toString();
    }

    public static void setLevelDisplay(String levelDisplay) {
        level = 1;
        if (levelDisplay.equals("DEBUG")) {
            level = 0;
        }
        if (levelDisplay.equals("MESSAGE")) {
            level = 2;
        }
        if (levelDisplay.equals("WARNING")) {
            level = 3;
        }
        if (levelDisplay.equals("SEVERE")) {
            level = 4;
        }
        if (levelDisplay.equals("NONE")) {
            level = 99;
        }
    }

    public void debug(Object ... msg) {
        Logger.log(this.modId, 0, this.implode(msg));
    }

    public void info(Object ... msg) {
        Logger.log(this.modId, 1, this.implode(msg));
    }

    public void message(Object ... msg) {
        Logger.log(this.modId, 2, this.implode(msg));
    }

    public void warning(Object ... msg) {
        Logger.log(this.modId, 3, this.implode(msg));
    }

    public void severe(Object ... msg) {
        Logger.log(this.modId, 4, this.implode(msg));
    }

    public static org.apache.logging.log4j.Logger getLogger(String key) {
        if (loggers.containsKey(key)) {
            return loggers.get(key);
        }
        org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)key);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration conf = ctx.getConfiguration();
        conf.getLoggerConfig(key).setLevel(Level.DEBUG);
        if (fileAppender == null) {
            try {
                if (ModGollumCoreLib.config != null) {
                    DefaultRolloverStrategy strategy = DefaultRolloverStrategy.createStrategy((String)new Integer(ModGollumCoreLib.config.numberLogFilesUse).toString(), null, null, null, (Configuration)conf);
                    OnStartupTriggeringPolicy policy = OnStartupTriggeringPolicy.createPolicy();
                    fileAppender = RollingFileAppender.createAppender((String)FILE_NAME, (String)"logs/%dGollumCoreLib{yyyy-MM-dd}-%i.log.gz", (String)"true", (String)FILE_NAME, (String)"false", (String)"true", (TriggeringPolicy)policy, (RolloverStrategy)strategy, null, null, (String)"false", (String)"false", null, (Configuration)conf);
                    fileAppender.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fileAppender != null) {
                // empty if block
            }
        }
        if (fileAppender != null) {
            conf.getLoggerConfig(key).addAppender((Appender)fileAppender, Level.DEBUG, null);
            ctx.updateLoggers(conf);
            loggers.put(key, logger);
        }
        return logger;
    }

    public static void log(String key, int level, Object msg) {
        org.apache.logging.log4j.Logger log = Logger.getLogger(key);
        switch (level) {
            case 4: {
                if (Logger.level > 4) break;
                log.error(msg.toString());
                break;
            }
            case 3: {
                if (Logger.level > 3) break;
                log.warn(msg.toString());
                break;
            }
            case 2: {
                if (Logger.level > 2) break;
                log.info(msg.toString());
                break;
            }
            case 1: {
                if (Logger.level > 1) break;
                log.info(msg.toString());
                break;
            }
            case 0: {
                if (Logger.level > 0) break;
                log.info(msg.toString());
                break;
            }
        }
    }
}

