/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.config.type;

import com.gollum.core.common.config.type.ConfigJsonType;
import com.gollum.core.tools.simplejson.Json;

public class MobCapacitiesConfigType
extends ConfigJsonType {
    public double moveSpeed = 0.0;
    public double maxHealt = 0.0;
    public double attackStrength = 0.0;
    public double followRange = 0.0;
    public double timeRange = 0.0;

    public MobCapacitiesConfigType() {
    }

    public MobCapacitiesConfigType(double moveSpeed, double maxHealt, double attackStrength, double followRange) {
        this(moveSpeed, maxHealt, attackStrength, followRange, 0.0);
    }

    public MobCapacitiesConfigType(double moveSpeed, double maxHealt, double attackStrength, double followRange, double timeRange) {
        this.moveSpeed = moveSpeed;
        this.maxHealt = maxHealt;
        this.attackStrength = attackStrength;
        this.followRange = followRange;
        this.timeRange = timeRange;
    }

    @Override
    public void readConfig(Json json) {
        if (json.containsKey("moveSpeed")) {
            this.moveSpeed = json.child("moveSpeed").doubleValue();
        }
        if (json.containsKey("maxHealt")) {
            this.maxHealt = json.child("maxHealt").doubleValue();
        }
        if (json.containsKey("attackStrength")) {
            this.attackStrength = json.child("attackStrength").doubleValue();
        }
        if (json.containsKey("followRange")) {
            this.followRange = json.child("followRange").doubleValue();
        }
        if (json.containsKey("timeRange")) {
            this.timeRange = json.child("timeRange").doubleValue();
        }
    }

    @Override
    public Json writeConfig() {
        return Json.create(new Json.EntryObject("moveSpeed", Json.create(this.moveSpeed)), new Json.EntryObject("maxHealt", Json.create(this.maxHealt)), new Json.EntryObject("attackStrength", Json.create(this.attackStrength)), new Json.EntryObject("followRange", Json.create(this.followRange)), new Json.EntryObject("timeRange", Json.create(this.timeRange)));
    }

    public String toString() {
        return "M:" + this.moveSpeed + ", H:" + this.maxHealt + ", A:" + this.attackStrength + ", F:" + this.followRange + ", T:" + this.timeRange;
    }

    public double getMoveSpeed() {
        return this.moveSpeed;
    }

    public double getHealt() {
        return this.maxHealt;
    }

    public double getAttackStrength() {
        return this.attackStrength;
    }

    public double getFollowRange() {
        return this.followRange;
    }

    public double getTimeRange() {
        return this.timeRange;
    }
}

