/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.client.gui.config;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.client.gui.config.GuiConfig;
import com.gollum.core.client.gui.config.element.CategoryElement;
import com.gollum.core.client.gui.config.entry.SubConfigEntry;
import com.gollum.core.common.config.ConfigLoader;
import cpw.mods.fml.client.config.GuiMessageDialog;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class GuiSubConfigConfig
extends GuiConfig {
    private ArrayList<ConfigLoader.ConfigLoad> subConfigLoaded;
    private SubConfigEntry subConfigEntry;

    public GuiSubConfigConfig(SubConfigEntry subConfigEntry) {
        super(subConfigEntry.parent.parent);
        this.titleLine2 = subConfigEntry.getLabel();
        this.subConfigEntry = subConfigEntry;
    }

    @Override
    protected void initConfigElement() {
        this.subConfigLoaded = ConfigLoader.getSubConfig(this.mod);
        for (ConfigLoader.ConfigLoad configLoad : this.subConfigLoaded) {
            this.configElements.add(new CategoryElement(this.subConfigEntry.getName(), configLoad, configLoad.config.getFileName()));
        }
    }

    @Override
    public void displayParent() {
        boolean mcRestart = this.entryList.requiresMcRestart();
        boolean wRestart = this.entryList.requiresWorldRestart();
        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.getMod().getModId(), this.subConfigEntry.getName(), wRestart, mcRestart);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (!event.getResult().equals((Object)Event.Result.DENY)) {
            this.saveValue();
            FMLCommonHandler.instance().bus().post((Event)new ConfigChangedEvent.PostConfigChangedEvent(this.getMod().getModId(), this.subConfigEntry.getName(), wRestart, mcRestart));
            if (mcRestart) {
                this.mc.displayGuiScreen((GuiScreen)new GuiMessageDialog(this.getParent(), "fml.configgui.gameRestartTitle", (IChatComponent)new ChatComponentText(I18n.format((String)"fml.configgui.gameRestartRequired", (Object[])new Object[0])), "fml.configgui.confirmRestartMessage"));
                return;
            }
        }
        super.displayParent();
    }

    @Override
    public void saveValue() {
        ModGollumCoreLib.log.info("Save configuration " + this.getMod().getModId() + " > " + this.subConfigEntry.getLabel());
        for (Map.Entry<String, Object> entry : this.entryList.getValues().entrySet()) {
            String fileName = entry.getKey();
            for (ConfigLoader.ConfigLoad configLoad : this.subConfigLoaded) {
                if (!fileName.equals(configLoad.config.getFileName())) continue;
                ModGollumCoreLib.log.info("Save file: " + fileName);
                configLoad.saveValue((LinkedHashMap)entry.getValue());
                new ConfigLoader(configLoad.config, false).writeConfig();
            }
        }
    }
}

