/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.client.gui.config;

import com.gollum.core.client.gui.config.GuiConfigEntries;
import com.gollum.core.client.gui.config.element.ConfigElement;
import com.gollum.core.common.config.ConfigProp;
import com.gollum.core.common.config.JsonConfigProp;
import com.gollum.core.common.mod.GollumMod;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.client.config.GuiUnicodeGlyphButton;
import cpw.mods.fml.client.config.HoverChecker;
import cpw.mods.fml.common.ModContainer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public abstract class GuiConfig
extends GuiScreen {
    protected ArrayList<ConfigElement> configElements = new ArrayList();
    protected GuiConfigEntries entryList;
    protected GuiButtonExt btDone;
    protected GuiButtonExt btUndo;
    protected GuiButtonExt btReset;
    private HoverChecker undoHoverChecker;
    private HoverChecker resetHoverChecker;
    protected GuiScreen parent;
    public GollumMod mod;
    private String title;
    public String titleLine2 = null;
    protected boolean needsRefresh = true;

    public GuiConfig(GuiScreen parent) {
        this.parent = parent;
        this.mod = this.getMod();
        this.title = this.mod.getModId();
    }

    protected abstract void initConfigElement();

    public GollumMod getMod() {
        if (this.parent instanceof GuiModList) {
            try {
                Field f = this.parent.getClass().getDeclaredField("selectedMod");
                f.setAccessible(true);
                ModContainer modContainer = (ModContainer)f.get(this.parent);
                return (GollumMod)modContainer.getMod();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.parent instanceof GuiConfig) {
            return ((GuiConfig)this.parent).mod;
        }
        return null;
    }

    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.entryList == null) {
            this.initConfigElement();
        }
        if (this.needsRefresh) {
            this.entryList = new GuiConfigEntries(this, this.mc);
            this.needsRefresh = false;
        }
        int undoGlyphWidth = this.mc.fontRenderer.getStringWidth("\u21b6") * 2;
        int resetGlyphWidth = this.mc.fontRenderer.getStringWidth("\u2604") * 2;
        int doneWidth = Math.max(this.mc.fontRenderer.getStringWidth(I18n.format((String)"gui.done", (Object[])new Object[0])) + 20, 100);
        int undoWidth = this.mc.fontRenderer.getStringWidth(" " + I18n.format((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.mc.fontRenderer.getStringWidth(" " + I18n.format((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0])) + resetGlyphWidth + 20;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth) / 2;
        this.buttonList.clear();
        this.btDone = new GuiButtonExt(2000, this.width / 2 - buttonWidthHalf, this.height - 29, doneWidth, 20, I18n.format((String)"gui.done", (Object[])new Object[0]));
        this.buttonList.add(this.btDone);
        this.btUndo = new GuiUnicodeGlyphButton(2002, this.width / 2 - buttonWidthHalf + doneWidth + 5, this.height - 29, undoWidth, 20, " " + I18n.format((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]), "\u21b6", 2.0f);
        this.buttonList.add(this.btUndo);
        this.btReset = new GuiUnicodeGlyphButton(2001, this.width / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.height - 29, resetWidth, 20, " " + I18n.format((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]), "\u2604", 2.0f);
        this.buttonList.add(this.btReset);
        this.undoHoverChecker = new HoverChecker((GuiButton)this.btUndo, 800);
        this.resetHoverChecker = new HoverChecker((GuiButton)this.btReset, 800);
        this.entryList.initGui();
    }

    public int getTopEntryList() {
        return this.titleLine2 != null ? 33 : 23;
    }

    public boolean mustntDisplay() {
        return false;
    }

    public abstract void saveValue();

    public GuiScreen getParent() {
        if (this.parent instanceof GuiConfig && ((GuiConfig)this.parent).mustntDisplay()) {
            return ((GuiConfig)this.parent).getParent();
        }
        return this.parent;
    }

    public void displayParent() {
        this.saveValue();
        if (this.parent instanceof GuiConfig && ((GuiConfig)this.parent).mustntDisplay()) {
            ((GuiConfig)this.parent).displayParent();
            return;
        }
        this.mc.displayGuiScreen(this.getParent());
    }

    protected void actionPerformed(GuiButton button) {
        if (button.id == 2000) {
            this.displayParent();
        } else if (button.id == 2001) {
            this.setToDefault();
        } else if (button.id == 2002) {
            this.undoChanges();
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.entryList.drawScreen(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 8, 0xFFFFFF);
        String title2 = this.titleLine2;
        if (this.titleLine2 != null) {
            int strWidth = this.mc.fontRenderer.getStringWidth(title2);
            int elipsisWidth = this.mc.fontRenderer.getStringWidth("...");
            if (strWidth > this.width - 6 && strWidth > elipsisWidth) {
                title2 = this.mc.fontRenderer.trimStringToWidth(title2, this.width - 6 - elipsisWidth).trim() + "...";
            }
            this.drawCenteredString(this.fontRendererObj, title2, this.width / 2, 18, 0xFFFFFF);
        }
        this.btDone.enabled = this.isValidValues();
        this.btUndo.enabled = this.isChanged() && this.undoIsVisible();
        this.btReset.enabled = !this.isDefault() && this.resetIsVisible();
        this.btUndo.visible = this.undoIsVisible();
        this.btReset.visible = this.resetIsVisible();
        super.drawScreen(mouseX, mouseY, partialTicks);
        if (this.undoHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(this.mc.fontRenderer.listFormattedStringToWidth(I18n.format((String)"fml.configgui.tooltip.undoAll", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        if (this.resetHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(this.mc.fontRenderer.listFormattedStringToWidth(I18n.format((String)"fml.configgui.tooltip.resetAll", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        this.entryList.drawScreenPost(mouseX, mouseY, partialTicks);
    }

    public void drawGradientRect(int p_73733_1_, int p_73733_2_, int p_73733_3_, int p_73733_4_, int p_73733_5_, int p_73733_6_) {
        super.drawGradientRect(p_73733_1_, p_73733_2_, p_73733_3_, p_73733_4_, p_73733_5_, p_73733_6_);
    }

    public boolean resetIsVisible() {
        return true;
    }

    public boolean undoIsVisible() {
        return true;
    }

    protected boolean isValidValues() {
        return this.entryList.isValidValues();
    }

    protected boolean isChanged() {
        return this.entryList.isChanged();
    }

    protected boolean isDefault() {
        return this.entryList.isDefault();
    }

    protected void setToDefault() {
        this.entryList.setToDefault();
    }

    protected void undoChanges() {
        this.entryList.undoChanges();
    }

    public void drawToolTip(List stringList, int x, int y) {
        this.func_146283_a(stringList, x, y);
    }

    protected void mouseClicked(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.func_148179_a(x, y, mouseEvent)) {
            this.entryList.mouseClicked(x, y, mouseEvent);
            super.mouseClicked(x, y, mouseEvent);
        }
    }

    protected void mouseMovedOrUp(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.func_148181_b(x, y, mouseEvent)) {
            super.mouseMovedOrUp(x, y, mouseEvent);
        }
    }

    protected void keyTyped(char eventChar, int eventKey) {
        if (eventKey == 1) {
            this.mc.displayGuiScreen(this.parent);
        } else {
            this.entryList.keyTyped(eventChar, eventKey);
        }
    }

    public void updateScreen() {
        super.updateScreen();
        this.entryList.updateScreen();
    }

    public boolean isArray() {
        return false;
    }

    public boolean displayEntriesLabel() {
        return true;
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canRemove() {
        return false;
    }

    public Object newValue() {
        return null;
    }

    public ConfigProp newConfigProp() {
        return new JsonConfigProp();
    }
}

