/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.client.gui;

import com.gollum.core.common.container.GCLContainer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GCLGuiContainer
extends GuiContainer {
    protected static final ResourceLocation texture = new ResourceLocation("GollumCoreLib".toLowerCase() + ":gui/generic_inventory.png");
    protected IInventory inventoryPlayer;
    protected IInventory inventoryBlock;
    protected int numRows = 0;
    protected int numColumns;

    public GCLGuiContainer(IInventory inventoryPlayer, IInventory inventoryBlock, int numColumns) {
        super((Container)new GCLContainer(inventoryPlayer, inventoryBlock, numColumns));
        this.init(inventoryPlayer, inventoryBlock);
    }

    public GCLGuiContainer(IInventory inventoryPlayer, IInventory inventoryBlock, Class<? extends GCLContainer> containerClass) throws Exception {
        super((Container)containerClass.getConstructor(IInventory.class, IInventory.class).newInstance(inventoryPlayer, inventoryBlock));
        this.init(inventoryPlayer, inventoryBlock);
    }

    public GCLGuiContainer(IInventory inventoryPlayer, IInventory inventoryBlock, Class<? extends GCLContainer> containerClass, int numColumns) throws Exception {
        super((Container)containerClass.getConstructor(IInventory.class, IInventory.class, Integer.TYPE).newInstance(inventoryPlayer, inventoryBlock, numColumns));
        this.init(inventoryPlayer, inventoryBlock);
    }

    private void init(IInventory inventoryPlayer, IInventory inventoryBlock) {
        this.inventoryPlayer = inventoryPlayer;
        this.inventoryBlock = inventoryBlock;
        this.allowUserInput = false;
        this.numColumns = ((GCLContainer)this.inventorySlots).getNumColumns();
        this.numRows = (int)Math.ceil((double)inventoryBlock.getSizeInventory() / (double)this.numColumns);
        this.ySize = 114 + this.numRows * 18;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        int base = 15 + this.numRows * 18;
        int top = base - this.numRows * 18;
        int widthTop = 7 + 18 * this.numColumns;
        int xTop = (this.width - widthTop) / 2;
        int posX = 18 * (9 - this.numColumns) / 2;
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)this.inventoryBlock.getInventoryName()), 8 + posX, top - 13, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)this.inventoryPlayer.getInventoryName()), 8, top + this.numRows * 18 + 6, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        int base = 15 + this.numRows * 18;
        int top = base - 15 - this.numRows * 18 - 3;
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        int widthTop = 14 + 18 * this.numColumns;
        int xTop = (this.width - widthTop) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(texture);
        this.drawTexturedModalRect(x, y + base, 0, 0, this.xSize, 101);
        this.drawTexturedModalRect(xTop, y + top, 0, 101, 7, 15);
        this.drawTexturedModalRect(xTop + 7 + 18 * this.numColumns, y + top, 25, 101, 7, 15);
        for (int i = 0; i < this.numColumns; ++i) {
            this.drawTexturedModalRect(xTop + 7 + 18 * i, y + top, 7, 101, 18, 15);
            this.drawTexturedModalRect(xTop + 7 + 18 * i, y + top + 15 + 18 * this.numRows, 7, 134, 18, 7);
            int posX = xTop + 7 + 18 * i;
            if (posX + 18 < x || posX > x + this.xSize) continue;
            this.drawTexturedModalRect(Math.max(x, posX), y + top + 15 + 18 * this.numRows + 4, 7, 116, 18 + Math.min(x + this.xSize - (posX + 18), 0), 3);
        }
        int slot = 0;
        for (int i = 0; i < this.numRows; ++i) {
            this.drawTexturedModalRect(xTop, y + top + 15 + 18 * i, 0, 116, 7, 18);
            for (int j = 0; j < this.numColumns; ++j) {
                if (slot < this.inventoryBlock.getSizeInventory()) {
                    this.drawTexturedModalRect(xTop + 7 + 18 * j, y + top + 15 + 18 * i, 32, 101, 18, 18);
                } else {
                    this.drawTexturedModalRect(xTop + 7 + 18 * j, y + top + 15 + 18 * i, 7, 116, 18, 18);
                }
                ++slot;
            }
            this.drawTexturedModalRect(xTop + 7 + 18 * this.numColumns, y + top + 15 + 18 * i, 25, 116, 7, 18);
        }
        this.drawTexturedModalRect(xTop, y + top + 15 + 18 * this.numRows, 0, 134, 7, 7);
        this.drawTexturedModalRect(xTop + 7 + 18 * this.numColumns, y + top + 15 + 18 * this.numRows, 25, 134, 7, 7);
        this.drawTexturedModalRect(Math.max(x, xTop), y + top + 15 + 18 * this.numRows + 4, 0, 116, 7, 3);
        this.drawTexturedModalRect(Math.min(x + this.xSize - 7, xTop + 7 + 18 * this.numColumns), y + top + 15 + 18 * this.numRows + 3, 25, 116, 7, 4);
    }
}

