/*
 * Decompiled with CFR 0.152.
 */
package argo.staj;

import argo.saj.InvalidSyntaxException;
import argo.staj.ThingWithPosition;

public abstract class InvalidSyntaxRuntimeException
extends RuntimeException {
    static final char END_OF_STREAM = '\uffff';
    private final int column;
    private final int row;

    private InvalidSyntaxRuntimeException(String s, ThingWithPosition thingWithPosition) {
        super("At line " + thingWithPosition.getRow() + ", column " + thingWithPosition.getColumn() + ":  " + s);
        this.column = thingWithPosition.getColumn();
        this.row = thingWithPosition.getRow();
    }

    private InvalidSyntaxRuntimeException(String s, Throwable throwable, ThingWithPosition thingWithPosition) {
        super("At line " + thingWithPosition.getRow() + ", column " + thingWithPosition.getColumn() + ":  " + s, throwable);
        this.column = thingWithPosition.getColumn();
        this.row = thingWithPosition.getRow();
    }

    static InvalidSyntaxRuntimeException invalidSyntaxRuntimeException(final String s, final ThingWithPosition thingWithPosition) {
        return new InvalidSyntaxRuntimeException(s, thingWithPosition){

            @Override
            public InvalidSyntaxException asInvalidSyntaxException() {
                return new InvalidSyntaxException(s, thingWithPosition.getRow(), thingWithPosition.getColumn());
            }
        };
    }

    static InvalidSyntaxRuntimeException invalidSyntaxRuntimeException(final String s, final Throwable throwable, final ThingWithPosition thingWithPosition) {
        return new InvalidSyntaxRuntimeException(s, throwable, thingWithPosition){

            @Override
            public InvalidSyntaxException asInvalidSyntaxException() {
                return new InvalidSyntaxException(s, throwable, thingWithPosition.getRow(), thingWithPosition.getColumn());
            }
        };
    }

    static InvalidSyntaxRuntimeException unexpectedCharacterInvalidSyntaxRuntimeException(final String expectation, final char actual, final ThingWithPosition thingWithPosition) {
        return new InvalidSyntaxRuntimeException(expectation, thingWithPosition){

            @Override
            public InvalidSyntaxException asInvalidSyntaxException() {
                String message = expectation + ('\uffff' == actual ? " but reached end of input." : " but got [" + actual + "].");
                return new InvalidSyntaxException(message, thingWithPosition.getRow(), thingWithPosition.getColumn());
            }
        };
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.row;
    }

    public abstract InvalidSyntaxException asInvalidSyntaxException();
}

