/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.registry;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.tools.helper.IItemHelper;
import com.gollum.core.utils.reflection.Reflection;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.minecraft.item.Item;

public class ItemRegistry {
    private static ItemRegistry instance = new ItemRegistry();
    private ArrayList<IItemHelper> items = new ArrayList();

    public static ItemRegistry instance() {
        return instance;
    }

    public void add(IItemHelper item) {
        if (!this.items.contains(item)) {
            this.items.add(item);
        }
    }

    public void registerAll() {
        for (IItemHelper item : this.items) {
            item.register();
        }
        this.items.clear();
    }

    public void overrideItemsClassField(Item vanillaItem, Item item) {
        try {
            Field field = null;
            for (Field f : Item.class.getFields()) {
                f.setAccessible(true);
                if (!Modifier.isStatic(f.getModifiers()) || f.get(null) != vanillaItem) continue;
                field = f;
            }
            if (field == null) {
                throw new Exception("This item \"" + vanillaItem.getClass().getName() + "\" not found in fields " + Item.class.getName());
            }
            this.overrideItemsClassField(field.getName(), item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void overrideItemsClassField(String fieldName, Item item) {
        try {
            Reflection.setFinalStatic(Item.class.getDeclaredField(fieldName), item);
            ModGollumCoreLib.log.message("Override Items field fieldName=\"" + fieldName + "\" by " + item.getClass().getSimpleName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void overrideItemId(Item vanillaItem, Item item) {
        int newId = vanillaItem.field_77779_bT;
        int oldId = item.field_77779_bT;
        try {
            Field f = null;
            try {
                f = Item.class.getDeclaredField("field_77779_bT");
            }
            catch (Exception e) {
                try {
                    f = Item.class.getDeclaredField("cv");
                }
                catch (Exception e2) {
                    ModGollumCoreLib.log.message("Unofuscate property " + Item.class.getName() + " : cv => blockId");
                    f = Item.class.getDeclaredField("itemID");
                }
            }
            Reflection.setFinalField(f, item, newId);
            ModGollumCoreLib.log.message("Override Item field fieldName=\"itemID by " + newId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Item.field_77698_e[newId] = item;
        Item.field_77698_e[oldId] = null;
    }
}

