/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.items;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.building.Builder;
import com.gollum.core.common.building.Building;
import com.gollum.core.common.building.BuildingParser;
import com.gollum.core.tools.helper.items.HItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemBuilding
extends HItem {
    private ArrayList<Building.SubBuilding> lastBuildings = new ArrayList();
    private Builder builder = new Builder();
    public ArrayList<String> nameIndex = null;
    public ArrayList<Building> buildingIndex = null;

    public Building.SubBuilding getLastBuild(int i) {
        return this.lastBuildings.get(this.lastBuildings.size() - i - 1);
    }

    public ItemBuilding(int id, String registerName) {
        super(id, registerName);
        this.func_77627_a(true);
    }

    private void initBuildingList() {
        this.nameIndex = new ArrayList();
        this.buildingIndex = new ArrayList();
        for (Map.Entry<String, Building> entry : BuildingParser.getBuildingsList().entrySet()) {
            this.nameIndex.add(entry.getKey());
            this.buildingIndex.add(entry.getValue());
        }
    }

    private ArrayList<String> getNameIndex() {
        this.initBuildingList();
        return this.nameIndex;
    }

    private ArrayList<Building> getNBuildingIndex() {
        this.initBuildingList();
        return this.buildingIndex;
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        int metadata = itemStack.func_77960_j();
        ArrayList<Building> buildings = this.getNBuildingIndex();
        int orientation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (metadata < buildings.size()) {
            Building.SubBuilding subBuilding = new Building.SubBuilding();
            subBuilding.building = buildings.get(metadata);
            subBuilding.x = x;
            subBuilding.y = y + 1;
            subBuilding.z = z;
            subBuilding.orientation = orientation;
            ModGollumCoreLib.log.debug("orientation = " + orientation);
            this.lastBuildings.add(subBuilding);
            this.builder.build(world, subBuilding, true);
        }
        return true;
    }

    public String func_77667_c(ItemStack itemStack) {
        int metadata = itemStack.func_77960_j();
        String name = "Building staff";
        if (metadata < this.getNameIndex().size()) {
            name = name + " : " + this.getNameIndex().get(metadata);
        }
        return name;
    }

    public String func_77628_j(ItemStack itemStack) {
        int metadata = itemStack.func_77960_j();
        String name = ModGollumCoreLib.i18n.trans("Building staff", new Object[0]);
        if (metadata < this.getNameIndex().size()) {
            name = name + " : " + this.getNameIndex().get(metadata);
        }
        return name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int id, CreativeTabs creativeTabs, List list) {
        for (int metadata = 0; metadata < this.getNameIndex().size(); ++metadata) {
            list.add(new ItemStack(id, 1, metadata));
        }
    }
}

