/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.handlers;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.building.Builder;
import com.gollum.core.common.events.BuildingGenerateEvent;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class WorldTickHandler
implements ITickHandler {
    private long time = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        if (tickData.length == 0 || !(tickData[0] instanceof World)) {
            return;
        }
        World world = (World)tickData[0];
        if (!world.field_72995_K && System.currentTimeMillis() - this.time > 200L) {
            this.time = System.currentTimeMillis();
            Iterator<Builder.BuilderRunnable> i = Builder.currentBuilds.iterator();
            while (i.hasNext()) {
                Object newEvent;
                Builder.BuilderRunnable thread = i.next();
                if (thread.getWorld() == world && !thread.isAlive()) {
                    i.remove();
                    newEvent = new BuildingGenerateEvent.Post(world, thread.getBuilding(), thread.getRotate(), thread.getPosition());
                    MinecraftForge.EVENT_BUS.post((Event)newEvent);
                    ModGollumCoreLib.log.debug("Thread " + thread.getId() + " is finish remove of pile.");
                    continue;
                }
                try {
                    newEvent = thread.waiter;
                    synchronized (newEvent) {
                        thread.waiter.notify();
                    }
                    Thread.sleep(10L);
                    thread.lockWorld.lock();
                    thread.unlockWorld();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "GollumCoreLib - Building update tick";
    }
}

