/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core;

import com.gollum.core.common.CommonProxyGolumCoreLib;
import com.gollum.core.common.command.CommandBuilding;
import com.gollum.core.common.config.ConfigGollumCoreLib;
import com.gollum.core.common.context.ModContext;
import com.gollum.core.common.i18n.I18n;
import com.gollum.core.common.log.Logger;
import com.gollum.core.common.mod.GollumMod;
import com.gollum.core.common.version.VersionChecker;
import com.gollum.core.common.worldgenerator.WorldGeneratorByBuilding;
import com.gollum.core.common.worldgenerator.WorldGeneratorByBuildingLoader;
import com.gollum.core.inits.ModBlocks;
import com.gollum.core.inits.ModCreativeTab;
import com.gollum.core.inits.ModItems;
import com.gollum.core.inits.ModTileEntities;
import com.gollum.core.tools.registry.BlockRegistry;
import com.gollum.core.tools.registry.ItemRegistry;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.command.ICommand;

@Mod(modid="GollumCoreLib", name="Gollum Core Lib", version="2.0.0", acceptedMinecraftVersions="1.6.4")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class ModGollumCoreLib
extends GollumMod {
    public static final String MODID = "GollumCoreLib";
    public static final String MODNAME = "Gollum Core Lib";
    public static final String VERSION = "2.0.0";
    public static final String MINECRAFT_VERSION = "1.6.4";
    @Mod.Instance(value="GollumCoreLib")
    public static ModGollumCoreLib instance;
    @SidedProxy(clientSide="com.gollum.core.client.ClientProxyGolumCoreLib", serverSide="com.gollum.core.common.CommonProxyGolumCoreLib")
    public static CommonProxyGolumCoreLib proxy;
    public static Logger log;
    public static I18n i18n;
    public static ConfigGollumCoreLib config;

    @Override
    @Mod.EventHandler
    public void handler(FMLInitializationEvent event) {
        super.handler(event);
    }

    @Override
    @Mod.EventHandler
    public void handler(FMLPostInitializationEvent event) {
        super.handler(event);
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModContext.instance().setCurrent(this);
        config = (ConfigGollumCoreLib)new ConfigGollumCoreLib().loadConfig();
        log = new Logger();
        i18n = new I18n();
        ModCreativeTab.create();
        VersionChecker.setDisplay(ModGollumCoreLib.config.versionChecker);
        Logger.setLevelDisplay(ModGollumCoreLib.config.level);
        new VersionChecker();
        ModBlocks.init();
        ModItems.init();
        BlockRegistry.instance().registerAll();
        ItemRegistry.instance().registerAll();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ModTileEntities.init();
        ModCreativeTab.init();
        proxy.registerEvents();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        this.initWorldGenerators();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBuilding());
    }

    private void initWorldGenerators() {
        WorldGeneratorByBuilding worldGeneratorByBuilding = new WorldGeneratorByBuildingLoader().load();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGeneratorByBuilding);
    }
}

