/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.registry;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.tools.helper.IBlockHelper;
import com.gollum.core.utils.reflection.Reflection;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;

public class BlockRegistry {
    private static BlockRegistry instance = new BlockRegistry();
    private ArrayList<IBlockHelper> blocks = new ArrayList();

    public static BlockRegistry instance() {
        return instance;
    }

    public void add(IBlockHelper block) {
        if (!this.blocks.contains(block)) {
            this.blocks.add(block);
        }
    }

    public void registerAll() {
        for (IBlockHelper block : this.blocks) {
            block.register();
        }
        this.blocks.clear();
    }

    public void overrideBlocksClassField(Block vanillaBlock, Block block) {
        try {
            Field field = null;
            for (Field f : Block.class.getFields()) {
                f.setAccessible(true);
                if (!Modifier.isStatic(f.getModifiers()) || f.get(null) != vanillaBlock) continue;
                field = f;
            }
            if (field == null) {
                throw new Exception("This block \"" + vanillaBlock.getClass().getName() + "\" not found in fields " + Block.class.getName());
            }
            this.overrideBlocksClassField(field.getName(), block);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void overrideBlocksClassField(String fieldName, Block block) {
        try {
            Reflection.setFinalStatic(Block.class.getDeclaredField(fieldName), block);
            ModGollumCoreLib.log.message("Override Blocks field fieldName=\"" + fieldName + "\" by " + block.getClass().getSimpleName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void overrideBlocksId(Block vanillaBlock, Block block) {
        int newId = vanillaBlock.blockID;
        int oldId = block.blockID;
        try {
            Field f = null;
            try {
                f = Block.class.getDeclaredField("field_71990_ca");
            }
            catch (Exception e) {
                try {
                    f = Block.class.getDeclaredField("cF");
                }
                catch (Exception e2) {
                    ModGollumCoreLib.log.message("Unofuscate property " + Block.class.getName() + " : cF => blockID");
                    f = Block.class.getDeclaredField("blockID");
                }
            }
            Reflection.setFinalField(f, block, newId);
            ModGollumCoreLib.log.message("Override Block field fieldName=\"blockID\" from " + oldId + " by " + newId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Item item = Item.itemsList[oldId];
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            try {
                Field f = null;
                try {
                    f = ItemBlock.class.getDeclaredField("field_77885_a");
                }
                catch (Exception e) {
                    try {
                        f = ItemBlock.class.getDeclaredField("a");
                    }
                    catch (Exception e2) {
                        ModGollumCoreLib.log.message("Unofuscate property " + ItemBlock.class.getName() + " : a => blockID");
                        f = ItemBlock.class.getDeclaredField("blockID");
                    }
                }
                f.setAccessible(true);
                f.set(itemBlock, newId);
                ModGollumCoreLib.log.message("Override ItemBlock field fieldName=\"blockID\" from " + oldId + " by " + newId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Block.blocksList[newId] = block;
        Block.blocksList[oldId] = null;
    }
}

