/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.helper.blocks;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.tools.helper.BlockHelper;
import com.gollum.core.tools.helper.IBlockHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.Facing;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class HBlockPistonBase
extends BlockPistonBase
implements IBlockHelper {
    protected BlockHelper helper;
    protected boolean isStickyPiston;
    protected Icon iconTop;
    protected Icon iconOpen;
    protected Icon iconBottom;
    protected String suffixTop = "_top";
    protected String suffixSticky = "_sticky";
    protected String suffixOpen = "_open";
    protected String suffixBottom = "_bottom";
    protected String suffixSide = "_side";

    public HBlockPistonBase(int id, String registerName, boolean isStickyPiston) {
        super(id, isStickyPiston);
        ModGollumCoreLib.log.info("Create block registerName : " + registerName);
        this.helper = new BlockHelper((Block)this, registerName);
        this.isStickyPiston = isStickyPiston;
    }

    @Override
    public BlockHelper getGollumHelper() {
        return this.helper;
    }

    @Override
    public void register() {
        this.helper.register();
    }

    @Override
    public String getRegisterName() {
        return this.helper.getRegisterName();
    }

    @Override
    public Block setItemBlockClass(Class<? extends ItemBlock> itemClass) {
        return this.helper.setItemBlockClass(itemClass);
    }

    @Override
    public Item getBlockItem() {
        return this.helper.getBlockItem();
    }

    @Override
    public void breakBlockInventory(World world, int x, int y, int z, int oldBlockId) {
        this.helper.breakBlockInventory(world, x, y, z, oldBlockId);
    }

    @Override
    public void registerIcons(IconRegister iconRegister) {
        if (this.helper.vanillaTexture) {
            super.registerIcons(iconRegister);
            return;
        }
        this.registerBlockIconsTop(iconRegister);
        this.registerBlockIconsOpen(iconRegister);
        this.registerBlockIconsBottom(iconRegister);
        this.registerBlockIconsSide(iconRegister);
    }

    protected void registerBlockIconsTop(IconRegister iconRegister) {
        this.iconTop = this.helper.loadTexture(iconRegister, this.suffixTop + (this.isStickyPiston ? this.suffixSticky : ""));
    }

    protected void registerBlockIconsOpen(IconRegister iconRegister) {
        this.iconOpen = this.helper.loadTexture(iconRegister, this.suffixOpen);
    }

    protected void registerBlockIconsBottom(IconRegister iconRegister) {
        this.iconBottom = this.helper.loadTexture(iconRegister, this.suffixBottom);
    }

    protected void registerBlockIconsSide(IconRegister iconRegister) {
        this.blockIcon = this.helper.loadTexture(iconRegister, this.suffixSide);
    }

    @Override
    public IBlockHelper setIcon(Icon icon) {
        this.blockIcon = icon;
        return this;
    }

    public Icon getIcon(int side, int metadata) {
        if (this.helper.vanillaTexture) {
            return super.getIcon(side, metadata);
        }
        int orientation = HBlockPistonBase.getOrientation((int)metadata);
        if (orientation > 5) {
            return this.iconTop;
        }
        if (side == orientation) {
            if (HBlockPistonBase.isExtended((int)metadata) || this.minX > 0.0 || this.minY > 0.0 || this.minZ > 0.0 || this.maxX < 1.0 || this.maxY < 1.0 || this.maxZ < 1.0) {
                return this.iconOpen;
            }
            return this.iconTop;
        }
        return side != Facing.oppositeSide[orientation] ? this.blockIcon : this.iconBottom;
    }

    @Override
    public String getTextureKey() {
        return this.helper.getTextureKey();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getPistonExtensionTexture() {
        if (this.helper.vanillaTexture) {
            return super.getPistonExtensionTexture();
        }
        return this.iconTop;
    }
}

