/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.version;

import argo.jdom.JdomParser;
import argo.jdom.JsonRootNode;
import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.context.ModContext;
import com.gollum.core.common.log.Logger;
import com.gollum.core.common.mod.GollumMod;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;

public class VersionChecker
extends Thread {
    private static boolean display = true;
    private GollumMod mod = ModContext.instance().getCurrent();
    private String message = null;
    private String type = "";

    public static void setDisplay(boolean display) {
        VersionChecker.display = display;
    }

    public VersionChecker() {
        TickRegistry.registerTickHandler((ITickHandler)new EnterWorldHandler(), (Side)Side.CLIENT);
        this.start();
    }

    @Override
    public void run() {
        String player = "MINECRAFT_SERVER";
        if (ModGollumCoreLib.proxy.isRemote()) {
            player = Minecraft.getMinecraft().getSession().getUsername();
        }
        try {
            String modid = this.mod.getModId();
            String modidEnc = URLEncoder.encode(this.mod.getModId(), "UTF-8");
            String versionEnc = URLEncoder.encode(this.mod.getVersion(), "UTF-8");
            String playerEnc = URLEncoder.encode(player, "UTF-8");
            String mcVersionEnc = URLEncoder.encode(this.mod.getMinecraftVersion(), "UTF-8");
            String localeEnc = URLEncoder.encode(this.getCurrentLanguage(), "UTF-8");
            URL url = new URL("http://minecraft-mods.elewendyl.fr/index.php/mmods/default/version?mod=" + modidEnc + "&version=" + versionEnc + "&player=" + playerEnc + "&mversion=" + mcVersionEnc + "&locale=" + localeEnc);
            ModGollumCoreLib.log.debug("URL Checker : " + url);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
            String strJSON = bufferedreader.readLine();
            JdomParser parser = new JdomParser();
            JsonRootNode root = parser.parse(strJSON);
            try {
                this.message = root.getStringValue(new Object[]{"message"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.type = root.getStringValue(new Object[]{"type"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.type.equals("info")) {
                Logger.log("VersionChecker " + modid, 1, this.message);
            } else {
                Logger.log("VersionChecker " + modid, 3, this.message);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getCurrentLanguage() {
        if (ModGollumCoreLib.proxy.isRemote()) {
            return Minecraft.getMinecraft().gameSettings.language;
        }
        return "";
    }

    public class EnterWorldHandler
    implements ITickHandler {
        private boolean nagged = false;

        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            if (this.nagged || !display) {
                return;
            }
            if (VersionChecker.this.message != null) {
                EntityPlayer player = (EntityPlayer)tickData[0];
                player.addChatMessage("-------------------------------");
                player.addChatMessage(EnumChatFormatting.YELLOW + VersionChecker.this.message);
                player.addChatMessage("-------------------------------");
            }
            this.nagged = true;
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.PLAYER);
        }

        public String getLabel() {
            return VersionChecker.this.mod.getModId() + " - Player update tick";
        }
    }
}

